

load  "escher_basic_pictures";;

echo_values false;;

let lsty = {linewidth=0.01;
            linecap=roundcap;
            linejoin=roundjoin;
            dashpattern=[]};;



let [P;Q;R;S] = map (hflip_picture o (make_draw_picture) (lsty,gra 0))
                    [skp;skq;skr;sks];;

let rot = rotate_picture 90;;
let small = scale_picture (0.5,0.5);;

let trio(p1,p2,p3) =
   (p1 BPICT p2) OPICT p3;;

let quartet (p1,p2,p3,p4) =
    (p1 BPICT p2) OPICT (p3 BPICT p4);;

let cycle p =
    (p BPICT (rot (rot (rot p)))) 
    OPICT 
    ((rot p) BPICT (rot(rot p)));;

(* Explicitation of all the construction steps *)

let T =quartet(P,Q,R,S);;

let U = cycle (rot Q);;

let C0=U and L0 = rot T and T0=T;;

let C1= quartet(small C0,small(L0 BPICT T0)
               ,small((rot T0)OPICT(rot L0)), U)
and L1 = trio(small L0,small T0,rot T)
and T1 = trio(small L0,small T0, T);;

let C2= quartet(small C1,small (L1 BPICT T1)
               ,small((rot T1)OPICT(rot L1)), U)
and L2 = trio(small L1,small T1,rot T)
and T2 = trio(small L1,small T1, T);;

let corner= quartet(small C2,small L2,
                    small(rot T2),rot Q);;

let SL = cycle corner;;


(*   The recursive definition    *)
let rec iter n (f,g) x =
  if n=0 then g x
         else iter (n-1) (f,g) (f x);;

let square_limit n (P,Q,R,S) =
   let TT=quartet(P,Q,R,S)
   and UU=cycle (rot Q)
     in
   let next_step(C,L,T) =
    (quartet(small C,small(L BPICT T),small((rot T)OPICT(rot L)), UU)
    ,trio(small L,small T,rot TT)
    ,trio(small L,small T, TT))
   and final_step(C,L,T) = quartet(small C,small L, small(rot T),rot Q)
in
  cycle(iter n (next_step,final_step) (TT,rot TT,UU));;



echo_values true;;
