(*************************************************************************)
(*                                                                       *)
(*                     Projet      Formel                                *)
(*                                                                       *)
(*                            CAML                                       *)
(*                                                                       *)
(*************************************************************************)
(*                                                                       *)
(*                            Inria                                      *)
(*                      Domaine de Voluceau                              *)
(*                      78150  Rocquencourt                              *)
(*                            France                                     *)
(*                                                                       *)
(*************************************************************************)

(* gram         The syntax of grammar definitions                        *)
(*		Michel Mauny						 *)

#standard arith true;;
#fast arith true;;

system module Gram ;;

let alpha = <:Caml:Type<'a>>;;

let parse_warning s =
 warning ("line "^string_of_int !line_counter^" "^s);;

let check_box = function
    "hov" -> ()
  | "h" -> ()
  | "v" -> ()
  | "hv" -> ()
  | s -> raise parse s^": illegal box type";;

grammar for programs GRAM = 
delimitor
  string is "\""
  comment is "%"
  ;
precedences
  nonassoc BOOL Literal "it";

rule entry Token = 
    parse ext_token tok -> tok
        
and entry Rule_body = 
    parse cases cl -> prefix :: cl
        
and entry Rules = 
    parse grule_list rl -> rev rl
        
and prec_token = 
    parse predef_token s -> Predef_tok s
        | literal s -> Keyword s
        | IDENT s -> Non_terminal s
        
and grule_list = 
    parse grule_list rl; Literal "and"; grule r -> r::rl
        | grule r -> [r]
        
and grule = 
    parse kind k; typed_ident v; Literal "="; parsing_rule cs
          -> {Kind=k; Rule_name=Rule_name v; Cases=cs}
        
and kind = 
    parse Literal "entry" -> Entry
        | -> Non_exported
        
and typed_ident = 
    parse IDENT name -> (name,alpha)
        | Literal "("; IDENT name; Literal ":"; Caml_Type t;
          Literal ")" -> (name,t)
        
and parsing_rule = 
    parse parse_kwd _; cases cs -> cs
        
and parse_kwd = 
    parse Literal "parse" -> ()
        | Literal "parser" -> ()
        
and cases = 
    parse case_list cl -> uncons (rev cl)
        
and case_list = 
    parse case_list cl; Literal "|"; case c -> c::cl
        | case_list cl; Macro_case mc -> mc cl
        | case c -> [c]
        
and Macro_case = 
    parse Literal "#|"; Caml_Expr0 e -> e
        
and case = 
    parse left_elem_list lml; with_prec wp; rule_action a;
          {MLrecord
           (("Left_member",MLapply (MLvar "@",MLpair (lml,wp),[])),
            ["Bindings",MLvar ""; "Action",a])} c
          -> c
        | rule_action a -> {Left_member=[]; Bindings=[]; Action=a}
        
and left_elem_list = 
    parse left_elem l; ( * (parse Literal ";"; left_elem l -> l
                                )) lml
          -> l::lml
        
and left_elem = 
    parse dollar_binding b -> Dollar_binding b
        | wild_binding tok -> Token tok
        | Literal "-" -> Space_annot
        | Literal "\\" -> Break_annot (0,0)
        | Literal "\\\\" -> Newline_annot
        | Literal "\\-" -> Break_annot (1,0)
        | Literal "\\"; Literal "("; INT n; Literal ","; INT m;
          Literal ")" -> Break_annot (n,m)
        | Literal "["; pp_offset po; {<:Caml:Expr< () >>} _;
          left_elem_list ll; Literal "]" -> Box_annot (po,ll)
        | Literal "("; left_elem e; Literal ")" -> e
        
and dollar_binding = 
    parse token tok; {parse_CAML_Pat0 ()} p -> (p,tok)
        | literal_as_binding b -> b
        
and wild_binding = 
    parse literal s -> Keyword s
        
and ext_token = 
    parse literal s -> Keyword s
        | token tok -> tok
        
and literal_as_binding = 
    parse Literal "Literal"; Literal "("; literal_as_binding b;
          Literal ")" -> b
        | STRING lit; Literal "as"; IDENT name
          -> (MLvarpat name,Keyword lit)
        | Macro e; Literal "as"; IDENT name -> (MLvarpat name,Keyword e)
        
and token = 
    parse predef_token s -> Predef_tok s
        | IDENT s -> Non_terminal s
        | Literal "{"; Caml_Expr esc; Literal "}"
          -> Escape_tok {Esc_bindings=[]; Escape_expr=esc}
        | Literal "("; regular r; Literal ")" -> r
        | Macro e -> e
        
and literal = 
    parse Literal "Literal"; STRING s -> s
        | STRING s -> s
        | Literal "Literal"; Macro e -> e
        
and regular = 
    parse parsing_rule cs -> Regular cs
        | Literal "*"; Literal "("; regular r; Literal ")" -> Star r
        | Literal "+"; Literal "("; regular r; Literal ")"
          -> Concat (r,Star r)
        
and rule_action = 
    parse Literal "accept"; Caml_Expr e -> Exit_action e
        | Literal "->"; Caml_Expr e -> Regular_action e
        
and with_prec = 
    parse -> []
        | Literal "with"; Literal "precedence"; prec_token tok
          -> [With_prec tok]
        
and predef_token = 
    parse Literal ("NUM" as s) -> s
        | Literal ("BOOL" as s) -> s
        | Literal ("IDENT" as s) -> s
        | Literal ("STRING" as s) -> s
        | Literal ("INT" as s) -> s
        | Literal ("INFIX" as s) -> s
        | Literal ("FLOAT" as s) -> s
        | Literal ("CHAR" as s) -> s
        | Literal ("EOF" as s) -> s
        | Literal ("BIGINT" as s) -> s
        | Literal ("RATIO" as s) -> s
        | Literal ("DYN" as s) -> s
        | Literal "Num" -> "NUM"
        | Literal "Bool" -> "BOOL"
        | Literal "Ident" -> "IDENT"
        | Literal "String" -> "STRING"
        | Literal "Int" -> "INT"
        | Literal "Infix" -> "INFIX"
        | Literal "Float" -> "FLOAT"
        | Literal "Char" -> "CHAR"
        | Literal "Eof" -> "EOF"
        | Literal "Bigint" -> "BIGINT"
        | Literal "Ratio" -> "RATIO"
        | Literal "Dyn" -> "DYN"
        
and pp_offset = 
    parse -> ("hov",0)
        | Literal "<"; name_of_box s; offset_box n; Literal ">" -> (s,n)
        
and offset_box = 
    parse INT n -> n
        | -> 0
        
and name_of_box = 
    parse IDENT s -> s
        | INFIX s -> s
        
and Caml_Type = 
    parse {parse_CAML_Type ()} t -> t
        
and Caml_Expr0 = 
    parse {parse_caml_expr0 ()} e -> e
        
and Caml_Expr = 
    parse {parse_CAML_Expr ()} e -> e
        
and Macro = 
    parse Literal "#"; Caml_Expr0 e -> e
        
;;

let parse_GRAM_Token = (GRAM "Token").Parse_raw
and parse_GRAM_Rules = (GRAM "Rules").Parse_raw
and parse_GRAM_Rule_body = (GRAM "Rule_body").Parse_raw;;

end module with
 value parse_GRAM_Token
 and parse_GRAM_Rules
 and parse_GRAM_Rule_body;;
