/*
(c) Copyright Taiichi Yuasa and Masami Hagiya, 1984.  All rights reserved.
Copying of this file is authorized to users who have executed the true and
proper "License Agreement for Kyoto Common LISP" with SIGLISP.
*/

/*
	bds.h

	bind stack
*/

#define BDSSIZE		1024
#define	BDSGETA		16

struct bds_bd {
	object	bds_sym;	/*  symbol  */
	object	bds_val;	/*  previous value of the symbol  */
};

struct bds_bd bind_stack[BDSSIZE + BDSGETA + BDSGETA];

#define bds_org		bind_stack

typedef struct bds_bd *bds_ptr;

bds_ptr bds_limit;

bds_ptr bds_top;		/*  bind stack top  */

#define	bds_check  \
	if (bds_top >= bds_limit)  \
		bds_overflow()

#define	bds_bind(sym, val)  \
	(++bds_top)->bds_sym = (sym);  \
	bds_top->bds_val = (sym)->s.s_dbind;  \
	(sym)->s.s_dbind = (val)

#define	bds_unwind1  \
	((bds_top->bds_sym)->s.s_dbind = bds_top->bds_val, --bds_top)
