/*
(C) Copyright Taiichi Yuasa and Masami Hagiya, 1984.  All rights reserved.
*/

/*
	interrupt.c
	DG-SPECIFIC
*/

#include <sysid.h>
#include <packets:normal_io.h>
#include <packets:task.h>

#include "^h:pio.h"

#include "include.h"

#define WAIT_TIME	1000

object SVinterrupt_enable;					/**/

short	wait_stack[100];

char	*stdin_system_buf;
struct _iobuf
	stdin_system;

init_interrupt()
{
	stdin_system_buf = _fdl[stdin->_fd]->pkt.nio.ibad;
	stdin_system = *stdin;
}

init_interrupt1()						/**/
{								/**/
	SVinterrupt_enable					/**/
	= make_si_special("*INTERRUPT-ENABLE*", Ct);		/**/
}								/**/

sigint()
{
/**************************************************************
	avoid trap of C library read routine.
***************************************************************/
	_fdl[stdin->_fd]->pkt.nio.ibad = stdin_system_buf;
	*stdin = stdin_system;
/**************************************************************/
	interrupt_flag = FALSE;
	terminal_interrupt(FALSE);
}

wait_task()
{
	int ac0, ac1, ac2, ier;

	interrupt_flag = FALSE;
	interrupt_enable = FALSE;	/* FALSE while initializing */

	while (!interrupt_enable) {	/* wait for initializing end */
		ac0 = 100;
		sys($WDELAY, &ac0, &ac1, &ac2);
	}
LOOP:
	sys($INTWT, &ac0, &ac1, &ac2);


/*
	When ^C^A is typed, if the value of SI:*INTERRUPT-ENABLE* is NIL,
	SI:*INTERRUPT-ENABLE* is set to T and the interrupt is ignored.
	By checking the value of SI:*INTERRUPT-ENABLE*,
	the program can control its flow according to terminal interrupts.
	It may have to reset the value of SI:*INTERRUPT-ENABLE*
	for processing successive interrupts.
	If ^C^A is typed twice (or more times) consecutively, however,
	the control will go through the following if statement,
	and the interrupt will be processed in the usual way, i.e.
	an error will be signalled.
*/	
	if (symbol_value(SVinterrupt_enable) == Cnil) {		/**/
		SVinterrupt_enable->s.s_dbind = Ct;		/**/
		goto LOOP;					/**/
	}							/**/

	interrupt_flag = TRUE;

	ac0 = WAIT_TIME;
	sys($WDELAY, &ac0, &ac1, &ac2);

	if (interrupt_flag) {
		while (!interrupt_enable) {
			ac0 = 100;
			sys($WDELAY, &ac0, &ac1, &ac2);
		}
		ac0 = sigint;
		ac1 = 1;
		sys($IDGOTO, &ac0, &ac1, &ac2);
	}

	goto LOOP;
}

/*
	$signal$init is called from C library
*/
$signal$init()
{
	P_TASK	taskp;
	int ac0, ac1, ac2, ier;

	taskp.dlnk = 1;
	taskp.dlnkb = 0;
	taskp.dpri = 0;
	taskp.did = 2;
	taskp.dpc = wait_task;
	taskp.dac2 = 0;
	taskp.dstb = wait_stack;
	taskp.dsflt = -1;
	taskp.dssz = 1024;
	taskp.dflgs = 0;
	taskp.dres = 0;
	taskp.dnum = 1;

	ac2 = &taskp;
	ier = sys($TASK, &ac0, &ac1, &ac2);
	if (ier) sys_emes(ier);

}

