;;; -*- Log: code.log; Package: Lisp -*-
;;;
;;; **********************************************************************
;;; This code was written as part of the CMU Common Lisp project at
;;; Carnegie Mellon University, and has been placed in the public domain.
;;; If you want to use this code or any part of CMU Common Lisp, please contact
;;; Scott Fahlman or slisp-group@cs.cmu.edu.
;;;
(ext:file-comment
  "$Header: salterror.lisp,v 1.3 91/02/08 13:35:20 ram Exp $")
;;;
;;; **********************************************************************
;;;
;;;    Utilities for checking GeneralReturn codes.  This is a truly
;;; stupid idea, but we have put up with a certain amount of Pascal
;;; brain-damage.
;;;
;;; Reluctantly written by Rob MacLachlan.
;;;
(in-package 'lisp)
(in-package 'system)
(export '(gr-error gr-call gr-call* gr-bind *gr-messages*))
(in-package 'lisp)

#-new-compiler
(eval-when (compile)
  (setq lisp::*bootstrap-defmacro* t))

(defvar *gr-messages* (make-hash-table :test #'eql)
  "A hashtable from GeneralReturn codes to the corresponding messages.")

;;; Def-GR  --  Internal
;;;
;;;    Define a gr code.
;;; 
(defun def-gr (code message)
  (declare (simple-string message))
  (setf (gethash code *gr-messages*) message))

;;; GR-Error  --  Public
;;;
;;;    This probably isn't exactly right, but it's better than nothing.
;;; We could do clever things with the context if we knew what the
;;; error meant and what the context was, but this is Pascal...
;;;
(defun gr-error (function gr &optional context)
  "Signal an error indicating that Function returned code GR.  If the code
  is success, then do nothing."
  (unless (eql gr mach:kern-success)
    (let ((found (gethash gr *gr-messages*)))
      (if found
	  (error "~S~@[ ~A~], ~(~A~)." function context found)
	  (error "Unknown generalreturn ~S in call to ~S." gr function)))))

;;; GR-Call  --  Public
;;;
(defmacro gr-call (fun &rest args)
  "GR-Call Function {Arg}*
  Call the function with the specified Args and signal an error if the
  first value returned is not Mach:Kern-Success.  Nil is returned."
  (let ((n-gr (gensym)))
    `(let ((,n-gr (,fun ,@args)))
       (unless (eql ,n-gr mach:Kern-Success) (gr-error ',fun ,n-gr)))))

;;; GR-Call*  --  Public
;;;
(defmacro gr-call* (fun &rest args)
  "GR-Call* Function {Arg}*
  Call the function with the specified Args and signal an error if the
  first value returned is not Mach:Kern-Success.  The second value is
  returned."
  (let ((n-gr (gensym))
	(n-res (gensym)))
    `(multiple-value-bind (,n-gr ,n-res) (,fun ,@args)
       (unless (eql ,n-gr mach:Kern-Success) (gr-error ',fun ,n-gr))
       ,n-res)))

;;; GR-Bind  --  Public
;;;
(defmacro gr-bind (vars (fun . args) &body (body decls))
  "GR-Bind ({Var}*) (Function {Arg}*) {Form}*
  Call the function with the specified Args and signal an error if the
  first value returned is not mach:Kern-Success.  If the call succeeds,
  the Forms are evaluated with remaining return values bound to the
  Vars."
  (let ((n-gr (gensym)))
    `(multiple-value-bind (,n-gr ,@vars) (,fun ,@args)
       ,@decls
       (unless (eql ,n-gr mach:Kern-Success) (gr-error ',fun ,n-gr))
       ,@body)))

;;;; Stuff ripped off kern_return.h

(def-gr mach:kern-success "Kernal success")
(def-gr mach:kern-invalid-address "Invalid address")
(def-gr mach:kern-protection-failure "Protect failure")
(def-gr mach:kern-no-space "No space")
(def-gr mach:kern-invalid-argument "Invalid argument")
(def-gr mach:kern-failure "Kernal failure")
(def-gr mach:kern-resource-shortage "Resource shortage")
(def-gr mach:kern-not-receiver "Not receiver")
(def-gr mach:kern-no-access "No access")

;;;; Stuff ripped off from Salterror.Pas...

;(def-gr mach:BADMSGID "Bad message ID")
;(def-gr mach:WRONGARGS "Wrong arguments given")
;(def-gr mach:BADREPLY "Bad reply received")
;(def-gr mach:NOREPLY "No reply should have been sent")
;(def-gr mach:UNSPECEXCEPTION "Unspecified exception message received")

;(def-gr netname:NameNotYours "Name is Not Yours")
;(def-gr netname:NameNotCheckedIn "Name is Not Checked In")
;(def-gr netname:NoSuchHost "No such host")
;(def-gr netname:HostNotFound "Host not found")

#-new-compiler
(eval-when (compile)
  (setq lisp::*bootstrap-defmacro* nil))
