/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.proxy;

import java.util.Hashtable;
import sun.rmi.transport.proxy.CGIClientException;
import sun.rmi.transport.proxy.CGICommandHandler;
import sun.rmi.transport.proxy.CGIForwardCommand;
import sun.rmi.transport.proxy.CGIGethostnameCommand;
import sun.rmi.transport.proxy.CGIPingCommand;
import sun.rmi.transport.proxy.CGIServerException;
import sun.rmi.transport.proxy.CGITryHostnameCommand;

public final class CGIHandler {
    static int ContentLength = Integer.getInteger("CONTENT_LENGTH", 0);
    static String QueryString = System.getProperty("QUERY_STRING", "");
    static String RequestMethod = System.getProperty("REQUEST_METHOD", "");
    static String ServerName = System.getProperty("SERVER_NAME", "");
    static int ServerPort = Integer.getInteger("SERVER_PORT", 0);
    private static CGICommandHandler[] commands = new CGICommandHandler[]{new CGIForwardCommand(), new CGIGethostnameCommand(), new CGIPingCommand(), new CGITryHostnameCommand()};
    private static Hashtable commandLookup = new Hashtable();

    private CGIHandler() {
    }

    public static void main(String[] stringArray) {
        try {
            String string;
            String string2;
            int n = QueryString.indexOf("=");
            if (n == -1) {
                string2 = QueryString;
                string = "";
            } else {
                string2 = QueryString.substring(0, n);
                string = QueryString.substring(n + 1);
            }
            CGICommandHandler cGICommandHandler = (CGICommandHandler)commandLookup.get(string2);
            if (cGICommandHandler != null) {
                try {
                    cGICommandHandler.execute(string);
                }
                catch (CGIClientException cGIClientException) {
                    CGIHandler.returnClientError(cGIClientException.getMessage());
                }
                catch (CGIServerException cGIServerException) {
                    CGIHandler.returnServerError(cGIServerException.getMessage());
                }
            } else {
                CGIHandler.returnClientError("invalid command: " + string2);
            }
        }
        catch (Exception exception) {
            CGIHandler.returnServerError("internal error: " + exception.getMessage());
        }
        System.exit(0);
    }

    private static void returnClientError(String string) {
        System.out.println("Status: 400 Bad Request: " + string);
        System.out.println("Content-type: text/html");
        System.out.println("");
        System.out.println("<HTML><HEAD><TITLE>Java RMI Client Error</TITLE></HEAD><BODY>");
        System.out.println("<H1>Java RMI Client Error</H1>");
        System.out.println("");
        System.out.println(string);
        System.out.println("</BODY></HTML>");
        System.exit(1);
    }

    private static void returnServerError(String string) {
        System.out.println("Status: 500 Server Error: " + string);
        System.out.println("Content-type: text/html");
        System.out.println("");
        System.out.println("<HTML><HEAD><TITLE>Java RMI Server Error</TITLE></HEAD><BODY>");
        System.out.println("<H1>Java RMI Server Error</H1>");
        System.out.println("");
        System.out.println(string);
        System.out.println("</BODY></HTML>");
        System.exit(1);
    }

    static {
        int n = 0;
        while (n < commands.length) {
            commandLookup.put(commands[n].getName(), commands[n]);
            ++n;
        }
    }
}

