/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.io.Serializable;

public class OrientableFlowLayout
extends FlowLayout {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int TOP = 0;
    public static final int BOTTOM = 2;
    int orientation;
    int vAlign;
    int vHGap;
    int vVGap;

    public OrientableFlowLayout() {
        this(0, 1, 1, 5, 5, 5, 5);
    }

    public OrientableFlowLayout(int n) {
        this(n, 1, 1, 5, 5, 5, 5);
    }

    public OrientableFlowLayout(int n, int n2, int n3) {
        this(n, n2, n3, 5, 5, 5, 5);
    }

    public OrientableFlowLayout(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n2, n4, n5);
        this.orientation = n;
        this.vAlign = n3;
        this.vHGap = n6;
        this.vVGap = n7;
    }

    public synchronized void orientHorizontally() {
        this.orientation = 0;
    }

    public synchronized void orientVertically() {
        this.orientation = 1;
    }

    public Dimension preferredLayoutSize(Container container) {
        Serializable serializable;
        if (this.orientation == 0) {
            return super.preferredLayoutSize(container);
        }
        Dimension dimension = new Dimension(0, 0);
        int n = container.countComponents();
        int n2 = 0;
        while (n2 < n) {
            serializable = container.getComponent(n2);
            if (((Component)serializable).isVisible()) {
                Dimension dimension2 = ((Component)serializable).preferredSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                if (n2 > 0) {
                    dimension.height += this.vVGap;
                }
                dimension.height += dimension2.height;
            }
            ++n2;
        }
        serializable = container.insets();
        dimension.width += ((Insets)serializable).left + ((Insets)serializable).right + this.vHGap * 2;
        dimension.height += ((Insets)serializable).top + ((Insets)serializable).bottom + this.vVGap * 2;
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        Serializable serializable;
        if (this.orientation == 0) {
            return super.minimumLayoutSize(container);
        }
        Dimension dimension = new Dimension(0, 0);
        int n = container.countComponents();
        int n2 = 0;
        while (n2 < n) {
            serializable = container.getComponent(n2);
            if (((Component)serializable).isVisible()) {
                Dimension dimension2 = ((Component)serializable).minimumSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                if (n2 > 0) {
                    dimension.height += this.vVGap;
                }
                dimension.height += dimension2.height;
            }
            ++n2;
        }
        serializable = container.insets();
        dimension.width += ((Insets)serializable).left + ((Insets)serializable).right + this.vHGap * 2;
        dimension.height += ((Insets)serializable).top + ((Insets)serializable).bottom + this.vVGap * 2;
        return dimension;
    }

    public void layoutContainer(Container container) {
        if (this.orientation == 0) {
            super.layoutContainer(container);
            return;
        }
        Insets insets = container.insets();
        Dimension dimension = container.size();
        int n = dimension.height - (insets.top + insets.bottom + this.vVGap * 2);
        int n2 = insets.left + this.vHGap;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = container.countComponents();
        int n7 = 0;
        while (n7 < n6) {
            Component component = container.getComponent(n7);
            if (component.isVisible()) {
                Dimension dimension2 = component.preferredSize();
                component.resize(dimension2.width, dimension2.height);
                if (n3 == 0 || n3 + dimension2.height <= n) {
                    if (n3 > 0) {
                        n3 += this.vVGap;
                    }
                    n3 += dimension2.height;
                    n4 = Math.max(n4, dimension2.width);
                } else {
                    this.moveComponents(container, n2, insets.top + this.vVGap, n4, n - n3, n5, n7);
                    n2 += this.vHGap + n4;
                    n3 = dimension2.width;
                    n4 = dimension2.width;
                    n5 = n7;
                }
            }
            ++n7;
        }
        this.moveComponents(container, n2, insets.top + this.vVGap, n4, n - n3, n5, n6);
    }

    private void moveComponents(Container container, int n, int n2, int n3, int n4, int n5, int n6) {
        switch (this.vAlign) {
            case 1: {
                n2 += n4 / 2;
                break;
            }
            case 2: {
                n2 += n4;
            }
        }
        int n7 = n5;
        while (n7 < n6) {
            Component component = container.getComponent(n7);
            Dimension dimension = component.size();
            if (component.isVisible()) {
                component.move(n + (n3 - dimension.width) / 2, n2);
                n2 += this.vVGap + dimension.height;
            }
            ++n7;
        }
    }

    public String toString() {
        String string = "";
        switch (this.orientation) {
            case 0: {
                string = "orientation=horizontal, ";
                break;
            }
            case 1: {
                string = "orientation=vertical, ";
                break;
            }
        }
        return String.valueOf(this.getClass().getName()) + "[" + string + super.toString() + "]";
    }
}

