/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CollationElementIterator;
import java.text.CollationKey;
import java.text.Collator;
import java.text.CompactIntArray;
import java.text.DecompositionIterator;
import java.text.EntryPair;
import java.text.MergeCollation;
import java.text.ParseException;
import java.text.PatternEntry;
import java.util.Vector;

public class RuleBasedCollator
extends Collator {
    static final long serialVersionUID = 2822366911447564107L;
    static int CHARINDEX = 0x70000000;
    static int EXPANDCHARINDEX = 0x7E000000;
    static int CONTRACTCHARINDEX = 0x7F000000;
    static int UNMAPPED = -1;
    private static final int SHORT_MAX_VALUE = Short.MAX_VALUE;
    private static final int PRIMARYORDERINCREMENT = 65536;
    private static final int MAXIGNORABLE = 65536;
    private static final int SECONDARYORDERINCREMENT = 256;
    private static final int TERTIARYORDERINCREMENT = 1;
    static final int PRIMARYORDERMASK = -65536;
    static final int SECONDARYORDERMASK = 65280;
    static final int TERTIARYORDERMASK = 255;
    static final int PRIMARYDIFFERENCEONLY = -65536;
    static final int SECONDARYDIFFERENCEONLY = -256;
    private static final int SECONDARYRESETMASK = 65535;
    private static final int IGNORABLEMASK = 65535;
    private static final int INITIALTABLESIZE = 20;
    private static final int MAXKEYSIZE = 5;
    static int PRIMARYORDERSHIFT = 16;
    static int SECONDARYORDERSHIFT = 8;
    private static final int MAXTOKENLEN = 256;
    private static final int MAXRULELEN = 512;
    private static final int COLLATIONKEYOFFSET = 1;
    private boolean isFrenchSec = false;
    private String ruleTable;
    private CompactIntArray mapping;
    private Vector contractTable;
    private Vector expandTable;
    private transient MergeCollation mPattern;
    private transient boolean isOverIgnore = false;
    private transient int currentOrder;
    private transient short maxSecOrder;
    private transient short maxTerOrder;
    private transient char lastChar;
    private transient StringBuffer key = new StringBuffer(5);
    private transient int strengthResult = 3;
    private transient StringBuffer primResult = new StringBuffer(256);
    private transient StringBuffer secResult = new StringBuffer(256);
    private transient StringBuffer terResult = new StringBuffer(256);

    public RuleBasedCollator(String string) throws ParseException {
        this.setStrength(2);
        this.build(string);
    }

    public String getRules() {
        if (this.ruleTable == null) {
            this.ruleTable = this.mPattern.emitPattern();
            this.mPattern = null;
        }
        return this.ruleTable;
    }

    public CollationElementIterator getCollationElementIterator(String string) {
        return new CollationElementIterator(string, this);
    }

    public int compare(String string, String string2) {
        int n = 0;
        this.strengthResult = 3;
        CollationElementIterator collationElementIterator = new CollationElementIterator(string2, this);
        CollationElementIterator collationElementIterator2 = new CollationElementIterator(string, this);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = true;
        while (true) {
            int n6 = 0;
            int n7 = 0;
            if (bl2) {
                n2 = collationElementIterator2.next();
            } else {
                bl2 = true;
            }
            if (bl3) {
                n3 = collationElementIterator.next();
            } else {
                bl3 = true;
            }
            if (n2 == -1 || n3 == -1) break;
            n4 = n2;
            n5 = n3;
            if (n2 == n3) continue;
            n6 = CollationElementIterator.primaryOrder(n2);
            if (n6 != (n7 = CollationElementIterator.primaryOrder(n3))) {
                if (n2 == 0) {
                    bl3 = false;
                    continue;
                }
                if (n3 == 0) {
                    bl2 = false;
                    continue;
                }
                if (n6 == 0) {
                    if (n7 == 0) {
                        n = this.checkSecTerDiff(n2, n3, n, false);
                        bl = true;
                        continue;
                    }
                    if (!this.isFrenchSec && (n == 0 || this.strengthResult > 1) || this.isFrenchSec && !bl) {
                        this.strengthResult = 1;
                        n = 1;
                    }
                    bl3 = false;
                    bl = false;
                    continue;
                }
                if (n7 == 0) {
                    if (!this.isFrenchSec && (n == 0 || this.strengthResult > 1) || this.isFrenchSec && !bl) {
                        n = -1;
                        this.strengthResult = 1;
                    }
                    bl2 = false;
                    bl = false;
                    continue;
                }
                if (n6 < n7) {
                    n = -1;
                    break;
                }
                n = 1;
                break;
            }
            n = this.checkSecTerDiff(n2, n3, n, bl);
            if (this.isFrenchSec && CollationElementIterator.isIgnorable(n2) && CollationElementIterator.isIgnorable(n3)) {
                bl = true;
                continue;
            }
            bl = false;
        }
        if (n2 != -1) {
            if (n3 == -1) {
                do {
                    if (CollationElementIterator.primaryOrder(n2) != 0) {
                        return 1;
                    }
                    if (CollationElementIterator.secondaryOrder(n2) == 0 || CollationElementIterator.isIgnorable(n5) && this.strengthResult <= 1) continue;
                    n = this.checkSecTerDiff(n2, 0, n, false);
                } while ((n2 = collationElementIterator2.next()) != -1);
            }
        } else if (n3 != -1) {
            do {
                if (CollationElementIterator.primaryOrder(n3) != 0) {
                    return -1;
                }
                if (CollationElementIterator.secondaryOrder(n3) == 0 || CollationElementIterator.isIgnorable(n4) && this.strengthResult <= 1) continue;
                n = this.checkSecTerDiff(0, n3, n, false);
            } while ((n3 = collationElementIterator.next()) != -1);
        }
        if (n == 0 && this.getStrength() == 3) {
            n = DecompositionIterator.decompose(string, this.getDecomposition()).compareTo(DecompositionIterator.decompose(string2, this.getDecomposition()));
        }
        return n;
    }

    public CollationKey getCollationKey(String string) {
        if (string == null) {
            return null;
        }
        this.primResult.setLength(0);
        this.secResult.setLength(0);
        this.terResult.setLength(0);
        int n = 0;
        boolean bl = this.getStrength() >= 1;
        boolean bl2 = this.getStrength() >= 2;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        CollationElementIterator collationElementIterator = new CollationElementIterator(string, this);
        while ((n = collationElementIterator.next()) != -1) {
            n2 = CollationElementIterator.secondaryOrder(n);
            n3 = CollationElementIterator.tertiaryOrder(n);
            if (!CollationElementIterator.isIgnorable(n)) {
                this.primResult.append((char)(CollationElementIterator.primaryOrder(n) + 1));
                if (bl) {
                    if (this.isFrenchSec && n4 < this.secResult.length()) {
                        this.reverse(this.secResult, n4, this.secResult.length());
                    }
                    this.secResult.append((char)(n2 + 1));
                    n4 = this.secResult.length();
                }
                if (!bl2) continue;
                this.terResult.append((char)(n3 + 1));
                continue;
            }
            if (bl && n2 != 0) {
                this.secResult.append((char)(n2 + this.maxSecOrder + 1));
            }
            if (!bl2 || n3 == 0) continue;
            this.terResult.append((char)(n3 + this.maxTerOrder + 1));
        }
        if (this.isFrenchSec) {
            if (n4 < this.secResult.length()) {
                this.reverse(this.secResult, n4, this.secResult.length());
            }
            this.reverse(this.secResult, 0, this.secResult.length());
        }
        this.primResult.append('\u0000');
        this.secResult.append('\u0000');
        this.secResult.append(this.terResult.toString());
        this.primResult.append(this.secResult.toString());
        if (this.getStrength() == 3) {
            this.primResult.append('\u0000');
            this.primResult.append(DecompositionIterator.decompose(string, this.getDecomposition()));
        }
        return new CollationKey(string, this.primResult.toString());
    }

    public Object clone() {
        RuleBasedCollator ruleBasedCollator = (RuleBasedCollator)super.clone();
        ruleBasedCollator.primResult = new StringBuffer(256);
        ruleBasedCollator.secResult = new StringBuffer(256);
        ruleBasedCollator.terResult = new StringBuffer(256);
        ruleBasedCollator.key = new StringBuffer(5);
        return ruleBasedCollator;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        RuleBasedCollator ruleBasedCollator = (RuleBasedCollator)object;
        return this.getRules().equals(ruleBasedCollator.getRules());
    }

    public int hashCode() {
        return this.getRules().hashCode();
    }

    private void build(String string) throws ParseException {
        int n = 0;
        if (string.length() == 0) {
            throw new ParseException("Build rules empty.", 0);
        }
        this.mapping = new CompactIntArray(UNMAPPED);
        string = DecompositionIterator.decompose(string, this.getDecomposition());
        this.mPattern = new MergeCollation(string);
        n = 0;
        while (n < this.mPattern.getCount()) {
            PatternEntry patternEntry = this.mPattern.getItemAt(n);
            if (patternEntry != null) {
                String string2;
                String string3 = patternEntry.getChars();
                if (string3.length() > 1 && string3.charAt(string3.length() - 1) == '@') {
                    this.isFrenchSec = true;
                    string3 = string3.substring(0, string3.length() - 1);
                }
                if ((string2 = patternEntry.getExtension()).length() != 0) {
                    this.addExpandOrder(string3, string2, patternEntry.getStrength());
                } else if (string3.length() > 1) {
                    this.addContractOrder(string3, patternEntry.getStrength());
                    this.lastChar = string3.charAt(0);
                } else {
                    char c = string3.charAt(0);
                    this.addOrder(c, patternEntry.getStrength());
                    this.lastChar = c;
                }
            }
            ++n;
        }
        this.commit();
        this.mapping.compact();
    }

    private final void commit() {
        if (this.expandTable != null) {
            int n = 0;
            while (n < this.expandTable.size()) {
                int[] nArray = (int[])this.expandTable.elementAt(n);
                int n2 = 0;
                while (n2 < nArray.length) {
                    if (nArray[n2] < EXPANDCHARINDEX && nArray[n2] > CHARINDEX) {
                        char c = (char)(nArray[n2] - CHARINDEX);
                        int n3 = this.mapping.elementAt(c);
                        if (n3 == UNMAPPED) {
                            nArray[n2] = 0xFFFF & nArray[n2 - 1];
                        } else if (n3 >= CONTRACTCHARINDEX) {
                            EntryPair entryPair = null;
                            Vector vector = (Vector)this.contractTable.elementAt(n3 - CONTRACTCHARINDEX);
                            entryPair = (EntryPair)vector.firstElement();
                            nArray[n2] = entryPair.value;
                        } else {
                            nArray[n2] = n3;
                        }
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    private final int increment(int n, int n2) {
        switch (n) {
            case 0: {
                n2 += 65536;
                n2 &= 0xFFFF0000;
                this.isOverIgnore = true;
                break;
            }
            case 1: {
                n2 += 256;
                n2 &= 0xFFFFFF00;
                if (this.isOverIgnore) break;
                this.maxSecOrder = (short)(this.maxSecOrder + 1);
                break;
            }
            case 2: {
                ++n2;
                if (this.isOverIgnore) break;
                this.maxTerOrder = (short)(this.maxTerOrder + 1);
                break;
            }
        }
        return n2;
    }

    private final void addOrder(char c, int n) {
        int n2 = this.mapping.elementAt(c);
        if (n2 >= CONTRACTCHARINDEX) {
            this.key.setLength(0);
            this.key.append(c);
            this.addContractOrder(this.key.toString(), n);
            return;
        }
        this.currentOrder = this.increment(n, this.currentOrder);
        this.mapping.setElementAt(c, this.currentOrder);
    }

    private final void addContractOrder(String string, int n) {
        int n2;
        Vector vector;
        if (this.contractTable == null) {
            this.contractTable = new Vector(20);
        }
        if (n != 3) {
            this.currentOrder = this.increment(n, this.currentOrder);
        }
        if ((vector = this.getContractValues((n2 = this.mapping.elementAt(string.charAt(0))) - CONTRACTCHARINDEX)) != null) {
            int n3 = this.getEntry(vector, string);
            if (n3 != UNMAPPED) {
                EntryPair entryPair = (EntryPair)vector.elementAt(n3);
                entryPair.value = this.currentOrder;
                return;
            }
            vector.addElement(new EntryPair(string, this.currentOrder));
            return;
        }
        vector = new Vector(20);
        int n4 = CONTRACTCHARINDEX + this.contractTable.size();
        vector.addElement(new EntryPair(string.substring(0, 1), n2));
        vector.addElement(new EntryPair(string, this.currentOrder));
        this.contractTable.addElement(vector);
        this.mapping.setElementAt(string.charAt(0), n4);
    }

    private final int getEntry(Vector vector, String string) {
        int n = 0;
        while (n < vector.size()) {
            EntryPair entryPair = (EntryPair)vector.elementAt(n);
            if (entryPair.entryName.equals(string)) {
                return n;
            }
            ++n;
        }
        return UNMAPPED;
    }

    Vector getContractValues(char c) {
        int n = this.mapping.elementAt(c);
        return this.getContractValues(n - CONTRACTCHARINDEX);
    }

    Vector getContractValues(int n) {
        if (n >= 0) {
            return (Vector)this.contractTable.elementAt(n);
        }
        return null;
    }

    private final void addExpandOrder(String string, String string2, int n) throws ParseException {
        int n2;
        Object object;
        EntryPair entryPair = new EntryPair();
        if (this.expandTable == null) {
            this.expandTable = new Vector(20);
        }
        int n3 = EXPANDCHARINDEX + this.expandTable.size();
        this.key.setLength(0);
        int n4 = UNMAPPED;
        if (string.length() > 1) {
            this.addContractOrder(string, n);
            this.lastChar = string.charAt(0);
            object = this.getContractValues(string.charAt(0));
            n2 = UNMAPPED;
            n2 = this.getEntry((Vector)object, string);
            if (n2 != UNMAPPED) {
                entryPair = (EntryPair)((Vector)object).elementAt(n2);
                n4 = entryPair.value;
            }
            entryPair.entryName = string;
            entryPair.value = n3;
        } else {
            char c = string.charAt(0);
            n4 = this.mapping.elementAt(c);
            if (n4 == UNMAPPED) {
                this.addOrder(c, n);
                this.lastChar = c;
                n4 = this.mapping.elementAt(this.lastChar);
            } else {
                n4 = this.increment(n, this.mapping.elementAt(this.lastChar));
            }
            this.mapping.setElementAt(c, n3);
        }
        object = new int[string2.length() + 1];
        object[0] = n4;
        n2 = 0;
        while (n2 < string2.length()) {
            int n5 = this.mapping.elementAt(string2.charAt(n2));
            if (n5 >= CONTRACTCHARINDEX) {
                this.key.append(string2.charAt(n2));
                int n6 = CHARINDEX + string2.charAt(n2);
                Vector vector = this.getContractValues(string2.charAt(n2));
                if (vector != null) {
                    int n7 = UNMAPPED;
                    n7 = this.getEntry(vector, this.key.toString());
                    if (n7 != UNMAPPED) {
                        entryPair = (EntryPair)vector.elementAt(n7);
                        n6 = entryPair.value;
                    }
                }
                this.key.setLength(0);
                object[n2 + 1] = n6;
            } else {
                object[n2 + 1] = n5 != UNMAPPED ? (Object)n5 : (Object)(CHARINDEX + string2.charAt(n2));
            }
            ++n2;
        }
        this.expandTable.addElement(object);
    }

    final int[] getExpandValueList(char c) {
        int n = this.mapping.elementAt(c);
        if (n >= EXPANDCHARINDEX && n < CONTRACTCHARINDEX) {
            int n2 = n - EXPANDCHARINDEX;
            return (int[])this.expandTable.elementAt(n2);
        }
        return null;
    }

    final int[] getExpandValueList(int n) {
        if (n < this.expandTable.size()) {
            return (int[])this.expandTable.elementAt(n);
        }
        return null;
    }

    final int getUnicodeOrder(char c) {
        return this.mapping.elementAt(c);
    }

    private final int checkSecTerDiff(int n, int n2, int n3, boolean bl) {
        int n4 = n3;
        if (CollationElementIterator.secondaryOrder(n) != CollationElementIterator.secondaryOrder(n2)) {
            if (!this.isFrenchSec && (n3 == 0 || this.strengthResult > 1) || this.isFrenchSec && !bl) {
                this.strengthResult = 1;
                n4 = CollationElementIterator.secondaryOrder(n) < CollationElementIterator.secondaryOrder(n2) ? -1 : 1;
            }
        } else if (CollationElementIterator.tertiaryOrder(n) != CollationElementIterator.tertiaryOrder(n2) && n4 == 0) {
            this.strengthResult = 2;
            n4 = CollationElementIterator.tertiaryOrder(n) < CollationElementIterator.tertiaryOrder(n2) ? -1 : 1;
        }
        return n4;
    }

    private final void reverse(StringBuffer stringBuffer, int n, int n2) {
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 < n4) {
            char c = stringBuffer.charAt(n3);
            stringBuffer.setCharAt(n3, stringBuffer.charAt(n4));
            stringBuffer.setCharAt(n4, c);
            ++n3;
            --n4;
        }
    }
}

