/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;

public abstract class ClassLoader {
    private boolean initialized = false;
    private Hashtable classes = new Hashtable();

    protected ClassLoader() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.init();
        this.initialized = true;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, true);
    }

    protected abstract Class loadClass(String var1, boolean var2) throws ClassNotFoundException;

    protected final Class defineClass(byte[] byArray, int n, int n2) {
        return this.defineClass(null, byArray, n, n2);
    }

    protected final Class defineClass(String string, byte[] byArray, int n, int n2) {
        if (!this.initialized) {
            throw new SecurityException("ClassLoader object not initialized.");
        }
        Class clazz = this.defineClass0(string, byArray, n, n2);
        if (clazz != null) {
            this.classes.put(clazz.getName(), clazz);
        }
        return clazz;
    }

    protected final void resolveClass(Class clazz) {
        if (!this.initialized) {
            throw new SecurityException("ClassLoader object not initialized.");
        }
        this.resolveClass0(clazz);
    }

    protected final Class findSystemClass(String string) throws ClassNotFoundException {
        if (!this.initialized) {
            throw new SecurityException("ClassLoader object not initialized.");
        }
        return this.findSystemClass0(string);
    }

    protected final void setSigners(Class clazz, Object[] objectArray) {
        if (!this.initialized) {
            throw new SecurityException("ClassLoader object not initialized.");
        }
        clazz.setSigners(objectArray);
    }

    private native void init();

    private native Class defineClass0(String var1, byte[] var2, int var3, int var4);

    private native void resolveClass0(Class var1);

    private native Class findSystemClass0(String var1) throws ClassNotFoundException;

    private void check() {
        if (this.initialized) {
            return;
        }
        throw new SecurityException("ClassLoader object not initialized.");
    }

    protected final Class findLoadedClass(String string) {
        return (Class)this.classes.get(string);
    }

    final Class loadClassInternal(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = (Class)this.classes.get(string = string.replace('/', '.'));
        if (clazz == null) {
            clazz = this.loadClass(string, false);
            if (clazz == null) {
                throw new ClassNotFoundException(string);
            }
            String string2 = clazz.getName();
            if (!string2.equals(string)) {
                throw new ClassNotFoundException(string);
            }
            this.classes.put(string2, clazz);
        }
        if (bl) {
            if (!this.initialized) {
                throw new SecurityException("ClassLoader object not initialized.");
            }
            this.resolveClass0(clazz);
        }
        return clazz;
    }

    public static final InputStream getSystemResourceAsStream(String string) {
        return ClassLoader.getSystemResourceAsStream0(string);
    }

    public static final URL getSystemResource(String string) {
        URL uRL;
        String string2 = ClassLoader.getSystemResourceAsName0(string);
        try {
            uRL = new URL(string2);
        }
        catch (Exception exception) {
            uRL = null;
        }
        return uRL;
    }

    public InputStream getResourceAsStream(String string) {
        return null;
    }

    public URL getResource(String string) {
        return null;
    }

    private static native InputStream getSystemResourceAsStream0(String var0);

    private static native String getSystemResourceAsName0(String var0);
}

