/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueueListener;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.ActiveEvent;
import java.io.Serializable;

class LightweightDispatcher
implements Serializable,
EventQueueListener {
    private static final long serialVersionUID = 5184291520170872969L;
    private static final int LWD_MOUSE_DRAGGED_OVER = 2000;
    private Container nativeContainer;
    private Component focus;
    private transient Component mouseEventTarget;
    private transient Component targetLastEntered;
    private transient boolean isMouseInNativeContainer = false;
    private boolean dragging;
    private Cursor nativeCursor;
    private long eventMask;
    private static final long PROXY_EVENT_MASK = 60L;
    private static final long MOUSE_MASK = 48L;
    static /* synthetic */ Class class$java$awt$event$MouseEvent;

    LightweightDispatcher(Container container) {
        this.nativeContainer = container;
        this.focus = null;
        this.mouseEventTarget = null;
        this.eventMask = 0L;
    }

    void enableEvents(long l) {
        this.eventMask |= l;
    }

    boolean setFocusRequest(Component component) {
        boolean bl = true;
        Window window = this.nativeContainer.getWindow();
        if (window != null && component != null) {
            Component component2 = window.getFocusOwner();
            if (component2 == null) {
                this.focus = component;
            } else if (component2 == this.nativeContainer) {
                this.focus = component;
                component.dispatchEvent(new FocusEvent(component, 1004, false));
                bl = false;
            } else if (component2 == component) {
                this.focus = component;
                bl = false;
            } else if (component2 == this.focus) {
                if (this.focus != null) {
                    this.focus.dispatchEvent(new FocusEvent(this.focus, 1005, false));
                }
                this.focus = component;
                component.dispatchEvent(new FocusEvent(component, 1004, false));
                bl = false;
            } else {
                this.focus = component;
            }
        }
        return bl;
    }

    boolean dispatchEvent(AWTEvent aWTEvent) {
        if ((this.eventMask & 0x3CL) != 0L) {
            if (aWTEvent instanceof MouseEvent && (this.eventMask & 0x30L) != 0L) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                return this.processMouseEvent(mouseEvent);
            }
            if (aWTEvent instanceof FocusEvent) {
                FocusEvent focusEvent = (FocusEvent)aWTEvent;
                return this.processFocusEvent(focusEvent);
            }
            if (aWTEvent instanceof KeyEvent) {
                KeyEvent keyEvent = (KeyEvent)aWTEvent;
                return this.processKeyEvent(keyEvent);
            }
        }
        return false;
    }

    private boolean processKeyEvent(KeyEvent keyEvent) {
        if (this.focus != null) {
            Component component = keyEvent.getComponent();
            keyEvent.setSource(this.focus);
            this.focus.dispatchEvent(keyEvent);
            keyEvent.setSource(component);
            return keyEvent.isConsumed();
        }
        return false;
    }

    private boolean processFocusEvent(FocusEvent focusEvent) {
        if (this.focus != null) {
            int n = focusEvent.getID();
            FocusEvent focusEvent2 = new FocusEvent(this.focus, n, focusEvent.isTemporary());
            this.focus.dispatchEvent(focusEvent2);
            if (n == 1005 && !focusEvent.isTemporary()) {
                this.focus = null;
            }
            return true;
        }
        return false;
    }

    private boolean processMouseEvent(MouseEvent mouseEvent) {
        Component component;
        int n = mouseEvent.getID();
        Component component2 = this.nativeContainer.getMouseEventTarget(mouseEvent.getX(), mouseEvent.getY(), true);
        this.trackMouseEnterExit(component2, mouseEvent);
        if (this.mouseEventTarget == null && (n == 503 || n == 501)) {
            component = component2 != this.nativeContainer ? component2 : null;
            this.setMouseTarget(component, mouseEvent);
        }
        if (this.mouseEventTarget != null) {
            switch (n) {
                case 506: {
                    if (!this.dragging) break;
                    this.retargetMouseEvent(this.mouseEventTarget, n, mouseEvent);
                    break;
                }
                case 501: {
                    this.dragging = true;
                    this.retargetMouseEvent(this.mouseEventTarget, n, mouseEvent);
                    break;
                }
                case 502: {
                    this.dragging = false;
                    this.retargetMouseEvent(this.mouseEventTarget, n, mouseEvent);
                    component = this.nativeContainer.getMouseEventTarget(mouseEvent.getX(), mouseEvent.getY(), false);
                    this.setMouseTarget(component, mouseEvent);
                    break;
                }
                case 500: {
                    this.retargetMouseEvent(this.mouseEventTarget, n, mouseEvent);
                    break;
                }
                case 505: {
                    if (this.dragging) break;
                    this.setMouseTarget(null, mouseEvent);
                    break;
                }
                case 503: {
                    component = this.nativeContainer.getMouseEventTarget(mouseEvent.getX(), mouseEvent.getY(), false);
                    this.setMouseTarget(component, mouseEvent);
                    this.retargetMouseEvent(this.mouseEventTarget, n, mouseEvent);
                    break;
                }
            }
            mouseEvent.consume();
        }
        return mouseEvent.isConsumed();
    }

    private void setMouseTarget(Component component, MouseEvent mouseEvent) {
        if (component != this.mouseEventTarget) {
            this.mouseEventTarget = component;
        }
    }

    private void trackMouseEnterExit(Component component, MouseEvent mouseEvent) {
        Component component2 = null;
        int n = mouseEvent.getID();
        if (n != 505 && n != 506 && n != 2000 && !this.isMouseInNativeContainer) {
            this.isMouseInNativeContainer = true;
            this.startListeningForOtherDrags();
        } else if (n == 505) {
            this.isMouseInNativeContainer = false;
            this.stopListeningForOtherDrags();
        }
        if (this.isMouseInNativeContainer) {
            component2 = component;
        }
        if (this.targetLastEntered == component2) {
            return;
        }
        this.retargetMouseEvent(this.targetLastEntered, 505, mouseEvent);
        if (n == 505) {
            mouseEvent.consume();
        }
        this.retargetMouseEvent(component2, 504, mouseEvent);
        if (n == 504) {
            mouseEvent.consume();
        }
        this.targetLastEntered = component2;
    }

    private void startListeningForOtherDrags() {
        Toolkit.getEventQueue().addEventQueueListener(this);
    }

    private void stopListeningForOtherDrags() {
        Toolkit.getEventQueue().removeEventQueueListener(this);
        Toolkit.getEventQueue().removeEvents(class$java$awt$event$MouseEvent != null ? class$java$awt$event$MouseEvent : (class$java$awt$event$MouseEvent = LightweightDispatcher.class$("java.awt.event.MouseEvent")), 2000);
    }

    public void eventPosted(AWTEvent aWTEvent) {
        boolean bl;
        boolean bl2 = bl = aWTEvent instanceof MouseEvent && aWTEvent.id == 506 && aWTEvent.getSource() != this.nativeContainer;
        if (!bl) {
            return;
        }
        Toolkit.getEventQueue().postEvent(new TrackEnterExitEvent(this.nativeContainer, (MouseEvent)aWTEvent));
    }

    void retargetMouseEvent(Component component, int n, MouseEvent mouseEvent) {
        if (component == null) {
            return;
        }
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        Component component2 = component;
        while (component2 != null && component2 != this.nativeContainer) {
            n2 -= component2.x;
            n3 -= component2.y;
            component2 = component2.getParent();
        }
        if (component2 != null) {
            MouseEvent mouseEvent2 = new MouseEvent(component, n, mouseEvent.getWhen(), mouseEvent.getModifiers(), n2, n3, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            if (component == this.nativeContainer) {
                ((Container)component).dispatchEventToSelf(mouseEvent2);
            } else {
                component.dispatchEvent(mouseEvent2);
            }
            Cursor cursor = component.getCursor();
            if (this.nativeContainer.getCursor() != cursor) {
                this.nativeContainer.setCursor(cursor);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ int access$1() {
        return 2000;
    }

    private class TrackEnterExitEvent
    extends AWTEvent
    implements ActiveEvent {
        MouseEvent srcEvent;

        public TrackEnterExitEvent(Component component, MouseEvent mouseEvent) {
            super(component, 0);
            LightweightDispatcher.this = LightweightDispatcher.this;
            this.srcEvent = mouseEvent;
        }

        public void dispatch() {
            MouseEvent mouseEvent;
            Object object = LightweightDispatcher.this.nativeContainer.getTreeLock();
            synchronized (object) {
                Component component;
                block6: {
                    block5: {
                        component = this.srcEvent.getComponent();
                        if (!component.isShowing()) break block5;
                        if (LightweightDispatcher.this.nativeContainer.isShowing()) break block6;
                    }
                    Object var3_3 = null;
                    return;
                }
                mouseEvent = new MouseEvent(LightweightDispatcher.this.nativeContainer, LightweightDispatcher.access$1(), this.srcEvent.getWhen(), this.srcEvent.getModifiers(), this.srcEvent.getX(), this.srcEvent.getY(), this.srcEvent.getClickCount(), this.srcEvent.isPopupTrigger());
                Point point = component.getLocationOnScreen();
                Point point2 = LightweightDispatcher.this.nativeContainer.getLocationOnScreen();
                mouseEvent.translatePoint(point.x - point2.x, point.y - point2.y);
            }
            object = LightweightDispatcher.this.nativeContainer.getMouseEventTarget(mouseEvent.getX(), mouseEvent.getY(), true);
            LightweightDispatcher.this.trackMouseEnterExit((Component)object, mouseEvent);
        }
    }
}

