tutorial_038 :
  using(Standard, StartWindowApplication, BBExternal, Adapter, Quit, QuitDispatcher)
  process (Init: WindowApplicationIn)
  declare
    Parms: WindowApplicationInterface; -- initialization callmessage
    Client: StandardOut; -- client process
    ParmString: Charstring; -- parameter to client process
    ClientPutLine: PutLineOut; -- PutLine from Client to Adapter
    ClientGetLine: GetLineOut; -- GetLine from Client to Buffer
    ClientGetPgm: GetProgramOut; -- GetProgram from Client to Adapter
  begin
    receive Parms from Init;
    block
      declare
        AdapterQuit: QuitOut; -- adapter's quit port
        BufferQuit: QuitOut; -- buffer's quit port
      begin
        call (AdapterOut # (create of Parms.GetProgram("Adapter")))
          (Parms.WriteToWindow, Parms.WindowName, Parms.GetProgram,
          AdapterQuit, ClientPutLine, ClientGetPgm);
        call (BBout # (create of Parms.GetProgram("UnboundedBuffer")))
          (0, Parms.InputToWindow, ClientGetLine, BufferQuit);
          
          -- EXAMPLE_TYPE STATEMENTS
          
          call (QuitDispOut # (create of process (Init: QuitDispIn)
            declare
              Parms: QuitDispInterface;
              Quit1: QuitOut;
              Quit2: QuitOut;
              Quit: QuitIn;
              QuitCM: QuitInterface;
            begin
              receive Parms from Init;
              new Quit; connect Parms.Quit to Quit;
              Quit1 := Parms.Quit1;
              Quit2 := Parms.Quit2;
              return Parms;
              
              receive QuitCM from Quit;
              call Quit1();
              call Quit2();
              return QuitCM;
            end process))
            (AdapterQuit, BufferQuit, Parms.Quit);
            
            
            ParmString := Parms.ParmString;
          Client := create of Parms.GetProgram(Parms.ProgramName);
          call Client(ClientGetLine, ClientPutLine, ClientGetPgm, ParmString);
          return Parms;
        on (others)
          return Parms exception NotCreated;
        end block;
    end process
    
