-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
window: 
using (predefined,common,window,wininternal,terminalio,fdhandlers)
linking (openwindow,writewin,readwin,closewin)
  process (Q: windowQ)
  declare
    args: window;
    openWindow: openWindowFn;
    readWin: readHandlerFn;
    writeWin: writeHandlerFn;
    closeWin: closeHandlerFn;
    read: readFn;
    write: writeFn;
    close: closeFn;
    closeReadQ: signalQ;
    closeWriteQ: signalQ;
    closeRead: signalPort;
    closeWrite: signalPort;
    closeClose: signalPort;
    terminal: terminalFunctions;
  begin
    receive args from Q;
    -- we will need openWindow, readWin, writeWin, closeWin
    openWindow <- procedure of process openwindow;
    readWin <- procedure of process readwin;
    writeWin <- procedure of process writewin;
    closeWin <- procedure of process closewin;
    -- first open the window
    call openWindow(args.cloader,args.label,args.options,read,write,close);
    -- setup the handlers
    new closeReadQ;
    connect closeRead to closeReadQ;
    new closeWriteQ;
    connect closeWrite to closeWriteQ;
    call closeWin(close,copy of read,copy of write,closeRead,closeWrite,closeClose);
    new terminal;
    call readWin(read,copy of closeClose,closeReadQ,terminal.getChar,terminal.getString);
    call writeWin(write,copy of closeClose,closeWriteQ,terminal.putChar,terminal.putString,terminal.putLine);
    -- return the args
    args.terminal <- terminal;
    args.close <- closeClose;
    return args;
  end process
