-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: pocopyts.p
-- Author: Rob Strom
-- SCCS Info: @(#)pocopyts.p	1.2 3/13/90

pocopyts : USING( tscheck, Predefined  ) PROCESS (PostCopyTSInit : DeterminePostconditionInport )
-- Compute Postcondition of COPY
-- Algorithm:
-- 1. For each attribute involving source object, 
--    substitute destination object for source
--    put that attribute in the Adds list
--    Correction when attributes may be implied: for each ancestral callmessage,
--    merge attributes involving source in minimum typestate for each such CM
-- 2. For each attribute involving destination object,
--    put that attribute in the Drops list unless it's in the Adds list
-- 3. Eliminate from both lists any attributes on both lists
--    
  DECLARE
    FP: DeterminePostconditionCall ;
    AttributesInvolvingSource : Typestate;
    AttributesInvolvingDestination : Typestate;
    EmptyAttributeList:  Typestate;
    DeletedAttribute: Attribute;
    AncestralObject: ObjectName; -- ancestor of SourceObject;
    Type: TypeName; -- type of ancestral object
    ComponentPosition: Integer; -- position of first source object component not in ancestral object
    SourceComponent: ComponentId; -- component of source object at ComponentPosition
    ImpliedTS: Typestate; -- typestate implied by ancestral callmessage
    ImpliedAttrsInvolvingSource: Typestate; -- attributes involving source derived from ImpliedTS
  BEGIN
    RECEIVE FP FROM PostCopyTSInit ;
    INSPECT SourceObject IN FP.Statement.Operands WHERE(POSITION OF SourceObject = Offset IN FP.Affected_Operands WHERE(POSITION OF Offset = 0))
      BEGIN
        INSPECT DestinationObject IN FP.Statement.Operands WHERE(POSITION OF DestinationObject = Offset IN FP.Affected_Operands WHERE(POSITION OF Offset = 1))
          BEGIN
            -- 1.
            NEW EmptyAttributeList; 
	    CALL FP.Services.Involving(FP.CurrentTS, SourceObject, EmptyAttributeList, AttributesInvolvingSource);
	    IF SIZE OF SourceObject.Components > 0 -- redundant test which avoids some unnecessary ops when no components
	      THEN
	        NEW AncestralObject;
	        AncestralObject.Root := SourceObject.Root;
	        NEW AncestralObject.Components;
	        Type <- FP.Services.TypeOf(FP.Services, FP.Declarations, FP.Definitions, FP.Context, AncestralObject);
	        ComponentPosition <- 0;
	        WHILE (ComponentPosition < SIZE OF SourceObject.Components)
	          REPEAT
		    INSPECT CAModule IN FP.Definitions WHERE(CAModule.Id = Type.ModuleId)
		      BEGIN
			INSPECT CADefinition IN CAModule.Type_definitions WHERE(CADefinition.Id = Type.TypeId)
			  BEGIN
			    BLOCK
			      BEGIN				
				REVEAL CADefinition.Specification.Callmessage_Info;
				INSPECT Min IN CADefinition.Specification.Callmessage_Info.Exception_Specifications[CADefinition.Specification.Callmessage_Info.Minimum]
				  BEGIN
				    ImpliedTS <- FP.Services.Substitute(FP.Services, AncestralObject, Min.Post_Typestate);
				    CALL FP.Services.Involving(ImpliedTS, SourceObject, EmptyAttributeList, ImpliedAttrsInvolvingSource);
				    -- MERGE ImpliedAttrsInvolvingSource INTO AttributesInvolvingSource
				    BLOCK
				      DECLARE
				        A: Attribute;
				      BEGIN
				        WHILE('true')
				          REPEAT
				            REMOVE A FROM Attr IN ImpliedAttrsInvolvingSource[];
				            INSERT A INTO AttributesInvolvingSource;
				          END WHILE;
				      ON (NotFound)
				      END BLOCK;
				  END INSPECT;
		              ON (CaseError)
		              END BLOCK;
			    SourceComponent <- SourceObject.Components[ComponentPosition];
			    INSPECT CD IN CADefinition.Component_Declarations WHERE(CD.Id = SourceComponent)
			      BEGIN
				Type := CD.Type;
			      END INSPECT;
			    INSERT SourceComponent INTO AncestralObject.Components;
		          END INSPECT;
		      END INSPECT;
		    ComponentPosition <- ComponentPosition + 1;
	          END WHILE;
	      END IF;
	    FOR Attribute IN AttributesInvolvingSource WHERE('true')
	      INSPECT
	        INSERT (EVALUATE TransformedAttribute : Attribute FROM
	          NEW TransformedAttribute;
	          TransformedAttribute.Name := Attribute.Name;
	          NEW TransformedAttribute.Objects;
	          FOR Object IN Attribute.Objects WHERE('true')
	            INSPECT
	              INSERT (EVALUATE TransformedObject : ObjectName FROM
	                IF (EVALUATE Substitutable : Boolean FROM
	                  Substitutable <- (Object.Root = SourceObject.Root) AND (SIZE OF Object.Components >= SIZE OF SourceObject.Components);
	                  IF Substitutable
	                    THEN
	                      Substitutable <- FORALL OF Component IN SourceObject.Components WHERE(Mate IN Object.Components WHERE(POSITION OF Mate = POSITION OF Component) = Component);
	                    END IF;
	                  END)
	                  THEN
	                    NEW TransformedObject;
	                    TransformedObject.Root := DestinationObject.Root;
	                    TransformedObject.Components := DestinationObject.Components;
	                    FOR Component IN Object.Components WHERE(POSITION OF Component >= SIZE OF SourceObject.Components)
	                      INSPECT
	                        INSERT COPY OF Component INTO TransformedObject.Components;
	                      END FOR;
	                  ELSE
	                    TransformedObject := Object;
	                  END IF;
	                END) INTO TransformedAttribute.Objects;
	            END FOR;
	          END) INTO FP.NormalPostcondition.Adds;
	      END FOR;
	    -- 2.
	    CALL FP.Services.Involving(FP.CurrentTS, DestinationObject, EmptyAttributeList, AttributesInvolvingDestination);
	    WHILE (SIZE OF AttributesInvolvingDestination > 0)
	      REPEAT
	        REMOVE DeletedAttribute FROM Attribute IN AttributesInvolvingDestination WHERE('true');
	        IF EXISTS OF Mate IN FP.NormalPostcondition.Adds WHERE(Mate = DeletedAttribute)
	          THEN
	            DISCARD DeletedAttribute;
	          ELSE
	            INSERT DeletedAttribute INTO FP.NormalPostcondition.Drops;
	          END IF;
	      END WHILE;
	    -- 3. not done now -- only affects case where src/dst overlap
          END INSPECT;
      END INSPECT;
    RETURN FP;
  END PROCESS
