-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: impliedat.p
-- Author: Rob Strom
-- SCCS Info: @(#)impliedat.p	1.1 7/27/89

-- Function: Get attributes which must be dropped to lower TS to particular value
 --    INIT(cm) is present or implied, and the required attribute
 --    present in the minimum typestate for cm.  This is checked as follows:
 --      a. Find a root object present in all parameters.  If there is
 --         none, quit.  (Attributes like GT(X, Y) can't be implied.)
 --      b. Get the type of that root.
 --      c. Now loop:
 --         c.1. If the type is a callmessage, check if INIT(CM) is present/implied.
 --              If it isn't present, give up:  the attribute isn't implied.
 --         c.2. If it is present, see if the required attribute is
 --              present in the minimum formal typestate.  If it is,
 --              quit:  the attribute is implied
 --         c.3. If not, remember CM and the minimum typestate, because
 --              these attributes are all implied for a future iteration of loop.
 --         c.4. If object isn't a callmessage, or if required attribute not implied,
 --              look for a subcomponent present in all parameters.
 --              If there is none, quit: attribute is not implied.
 --              If there is one, continue loop.
ImpliedAt : USING( Predefined, tscheck, Tsapre ) PROCESS ( ImpliedAttributeInit : ImpliedAttributeInport )
  DECLARE
    FP: ImpliedAttributeCall;
  BEGIN
    RECEIVE FP From ImpliedAttributeInit;
    -- all this deals with implied required attribute
    BLOCK
      DECLARE
	FirstParameter: ObjectName; -- arbitrary parm in req'd attr
	CommonComponent: ComponentId; -- component being checked for membership in common ancestor
	CommonAncestor: ObjectName; -- ancestor of arbitrary parm which is a prefix of all parameters
	Index: Integer; -- Component Index of CM (-1 if root); i.e.
			-- Index + 1 is index of first CM component
	Type: TypeName; -- type of CommonAncestor
	ImpliedAttributes: LabelledFormalTypestates;
      BEGIN
        FP.Implied <- 'false';
	FirstParameter <- Param IN FP.Attribute.Objects[];
	-- a., b.
	IF FORALL OF Param IN FP.Attribute.Objects WHERE(Param.Root = FirstParameter.Root)
	  THEN
	    NEW CommonAncestor;
	    CommonAncestor.Root := FirstParameter.Root;
	    NEW CommonAncestor.Components;
	    Type <- FP.Services.TypeOf(FP.Services, FP.Declarations, FP.Definitions, FP.Context, CommonAncestor);
	    Index <- -1;
	  ELSE
	    EXIT NotImplied;
	  END IF;
	-- c.
	NEW ImpliedAttributes;
	WHILE ('true')
	  REPEAT
	    INSPECT CAModule IN FP.Definitions WHERE(CAModule.Id = Type.ModuleId)
	      BEGIN
		INSPECT CADefinition IN CAModule.Type_definitions WHERE(CADefinition.Id = Type.TypeId)
		  BEGIN
		    BLOCK
		      BEGIN
			
			REVEAL CADefinition.Specification.Callmessage_Info;
			INSPECT Min IN CADefinition.Specification.Callmessage_Info.Exception_Specifications[CADefinition.Specification.Callmessage_Info.Minimum]
			  BEGIN
			    -- c.1. (short-circuit evaluation)
			    IF EVALUATE InitCM: Boolean FROM
			      InitCM <- EXISTS OF Attr IN FP.CurrentTS WHERE(Case Of Attr.Name = 'initialized' AND Attr.Objects[] = CommonAncestor);
			      IF InitCM
				THEN
				ELSE
				  InitCM <- EXISTS OF ImpliedAttribute IN ImpliedAttributes WHERE(EVALUATE Present: Boolean FROM
				    BLOCK
				    DECLARE
				      ExpectedAttr: Formal_Attribute;
				    BEGIN
				      NEW ExpectedAttr;
				      UNITE ExpectedAttr.Attribute_Name.Init FROM EVALUATE Empty: Empty FROM END;
				      NEW ExpectedAttr.Parameters;
				      INSERT EVERY OF P IN CommonAncestor.Components WHERE(POSITION OF P >= ImpliedAttribute.Label) INTO ExpectedAttr.Parameters ;
				      Present <- EXISTS OF Attr IN ImpliedAttribute.Minimum WHERE(Attr = ExpectedAttr);
				    END BLOCK;
				  END);
				END IF;
			      END
			      THEN
				-- c.2.
				IF EVALUATE RequiredImplied: Boolean FROM
				  BLOCK
				    DECLARE
				      ExpectedAttribute: Formal_Attribute;
				    BEGIN
				      NEW ExpectedAttribute;
				      ExpectedAttribute.Attribute_Name := FP.Attribute.Name;
				      NEW ExpectedAttribute.Parameters;
				      FOR Parameter IN FP.Attribute.Objects[]
					INSPECT
					  
  --					            INSERT EVERY OF Component IN Parameter.Components WHERE(POSITION OF Component > Index) INTO ExpectedAttribute.Parameters;
  -- Simulated because EVERY OF is broken
					   BLOCK
					     DECLARE
					       Temp: Component_List;
					     BEGIN
					       NEW Temp;
					       FOR Component IN Parameter.Components WHERE(POSITION OF Component > Index)
						 INSPECT
						   INSERT COPY OF Component INTO Temp;
						 END FOR;
					       INSERT Temp INTO ExpectedAttribute.Parameters;
					     END BLOCK;
					END FOR;
  
				      RequiredImplied <- EXISTS OF EA IN Min.Post_Typestate WHERE(EA = ExpectedAttribute);
				    END BLOCK;
				  END
				  THEN
				    EXIT Implied;
				  END IF;
			      ELSE
				EXIT NotImplied;
			      END IF;
			    -- c.3.
			    INSERT EVALUATE IA: LabelledFormalTypestate FROM
			      NEW IA;
			      IA.Label := Index;
			      IA.Minimum := Min.Post_Typestate;
			      END INTO ImpliedAttributes;
			  END INSPECT;
		      ON (CaseError)
		      END BLOCK;
		    -- c.4.
	            Index <- Index + 1;
		    CommonComponent <- FirstParameter.Components[Index];
		    IF FORALL OF Param IN FP.Attribute.Objects WHERE(Param.Components[Index] = CommonComponent)
		      THEN
			INSPECT CD IN CADefinition.Component_Declarations WHERE(CD.Id = CommonComponent)
			  BEGIN
			    Type := CD.Type;
			  END INSPECT;
			INSERT CommonComponent INTO CommonAncestor.Components;
		      ELSE
			EXIT NotImplied;
		      END IF;
		  END INSPECT;
	      END INSPECT;
	    
	  END WHILE;  
	
      ON (NotFound)
      ON EXIT(Implied)
	FP.Implied <- 'true';
      ON EXIT(NotImplied)
      END BLOCK;
    RETURN FP;
  END PROCESS
