-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: stmtchecker.bs
-- Author: Dan Yellin
-- SCCS Info: @(#)stmtchecker.bs	1.6 3/13/90

-- This process checks a statement for type correctness, and infers
-- types of its operands where possible.  New inferences, errors, and
-- backpatch entries all may be generated.  If any new inferences are
-- made, the rootnames of the variables inferred will appear in
-- newlyInferred upon return.

stmtchecker: using(predefined, inferredtype, errors, type, positions)
process(stmtCheckPort:stmtCheckQueue)
declare
  stmtCall: stmtCheckMessage;
  object: objectname;
  argument: objectname;
  position: aposition;
begin
  receive stmtCall from stmtCheckPort;

  -- build a position object for use in errors reported for this
  -- statement
  new position;
  position.clause := stmtCall.clause_id;
  position.statement := stmtCall.stmt.id;

  --  first check type assigment rules
  for assign_rule IN stmtCall.checking_record.type_assignment_rules[] inspect
    object <- objectname#(op in stmtCall.stmt.operands
	  where(boolean#(integer#(position of op) = assign_rule.result)));

    call stmtCall.assignPort(assign_rule.function, object,
      stmtCall.inferred, stmtCall.newlyInferred, stmtCall.backpatch,
      stmtCall.errors, position);

  end for;    	    		    	            

  -- next invoke the inference rules
  for infer_rule in stmtCall.checking_record.type_inference_rules[] inspect
    object <- objectname#(op in stmtCall.stmt.operands
	  where (boolean#(integer#(position of op) = infer_rule.result)));
    argument <- objectname#(op in stmtCall.stmt.operands
	  where (boolean#(integer#(position of op) = infer_rule.argument)));

    call stmtCall.inferPort(infer_rule.function, object, argument,
      stmtCall.inferred, stmtCall.newlyInferred, stmtCall.backpatch,
      stmtCall.errors, position);

  end for;
  
#if FullChecking
  -- Finally, invoke the class rules for this statement
  for class_rule IN stmtCall.checking_record.type_class_rules[] inspect
    argument := operand IN stmtCall.stmt.operands[class_rule.argument];

    call stmtCall.classPort(class_rule.function, argument,
      stmtCall.inferred, stmtCall.backpatch, stmtCall.errors, position);

  end for;
#endif

  -- if this is a 'call' statement, invoke the special interface
  -- checker
  if boolean#(stmtCall.stmt.operator = operator#'call') then
    call stmtCall.interfaceCheckPort(stmtCall.stmt, stmtCall.clause_id,
      stmtCall.scopes, stmtCall.definitions, stmtCall.inferred,
      stmtCall.backpatch, stmtCall.errors, stmtCall.findTypePort,
      stmtCall.findDefPort, stmtCall.componentsOverlap, stmtCall.newlyInferred);
  end if;
  
  return stmtCall;

end process
    
