-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS info: @(#)variantcomponent.p	1.4 3/13/90 
-- The following function is given an object (of type objectname) and 
-- returns true if the object is of the form x.a (or x.a.b.c etc) and
-- x  (x.a.b) is of type variant
variantcomponent: using(type)
process(VarCompQ: VariantComponentQueue)
DECLARE
  VarCompM: VariantComponentMessage;
  root_type: optional_typename;
  parent_type: typename;
  place: integer;
BEGIN
  RECEIVE VarCompM FROM VarCompQ;
  if size of VarCompM.argument.components = 0 then
    exit return_false;
  else
    -- get type of root object
    inspect scope in VarCompM.scopes[VarCompM.argument.root.scope] begin
      inspect declaration IN scope.declarations[VarCompM.argument.root.root] 
      begin
	root_type := declaration.typename;
      end inspect;
    end inspect;
  end if;

  reveal root_type.typename;
  dissolve root_type.typename into parent_type;
  place := 0;
  while place < (size of VarCompM.argument.components) - 1 repeat
    inspect defs_module in VarCompM.definitions[parent_type.moduleid] begin
      inspect def in defs_module.type_definitions[parent_type.typeid] begin
	inspect component in def.component_declarations
	      where (component.id = id in VarCompM.argument.components[place])
	begin
	  parent_type := component.type;
	end inspect;    	        	 
      end inspect;    	        	 
    end inspect;    	        	   	    
    place := place + 1;
  end while;
	
  if VarCompM.VariantPort(parent_type, VarCompM.definitions) 
  then
    exit return_true;
  else
    exit return_false;
  end if;

on exit(return_true)
  VarCompM.result <- 'true';
  return VarCompM;
on exit(return_false)
  VarCompM.result <- 'false';
  return VarCompM;

END process
