-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)unixcmd.p	1.4 3/13/90

unixCmd: using (predefined, unixCmd, unix)
process (q: unixCmdQ)

declare
  m: unixCmd;
  inpipe: handle;
  buffer: unix!buffer;
  rc: int;
  status: integer;

begin
  receive m from q;

  block begin
    call m.popen(m.cmd, "r", inpipe);

    -- pre-allocate the buffer space (yuck)
    new buffer;
    buffer.size <- 256;
    buffer.string <- "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";

    rc <- 1;

    while rc <> 0 repeat
      call m.fgets(buffer, inpipe, rc);
      if rc <> 0 then
	call m.putString(buffer.string);
      end if;
    end while;

    call m.pclose(inpipe);
    return m;
  on (others)
    return m exception cantExec;
  end block;

end process
