-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)shell.p	1.5 3/13/90

-- Hermes shell.  Runs programs with the main!main_intf interface.  The prompt
-- may be set by use of the HPROMPT environment variable; it defaults to 
-- "shell: ".  Additionally, the commands "cd", "pwd", and "exit" are 
-- supported directly.
--
-- David F. Bacon, 1 June 1989

shell: using (predefined, main, common, stdenv, root, tokenize,
  terminalIO, load)
process (initQ: main_Q)

declare
  init: main_Intf;
  compiler: main_Func;
  input: charstring;
  command: charstring;
  argv: charstringList;
  oldargv: charstringList;
  enventry: root!enventry;
  tokenize: tokenizeFn;
  initTokenize: tokenizeInitFn;
  tokenStrings: tokenStringsFn;
  prompt: charstring;

begin
  receive init from initQ;

  initTokenize <- create of init.std.pathload("tokenize");
  block declare
    wordChars: charString;
    whiteChars: charString;
  begin
    wordChars <- "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    wordChars <- wordChars | "1234567890!@#$%^&*_+|~-=\`;:,./?";
    whiteChars <- " ";
    insert 'HT' into whiteChars;
    tokenize <- initTokenize(wordChars, whiteChars, "'""", "(){}[]<>");
  end block;
  tokenStrings <- procedure of init.std.pathload("tokenstrings");

  block begin
    enventry <- enventry#(var in init.environ where (boolean#(
	var.variable = charstring#"HPROMPT")));
    prompt <- enventry.value;
  on (NotFound)
    prompt <- charstring#"shell: ";
  end block;

  while boolean#'true' repeat block begin
    call init.std.terminal.putString(prompt);
    input <- init.std.terminal.getString();
    argv <- tokenStrings(tokenize(input));
    command := charstring#(arg in argv 
	where (boolean#(integer#(position of arg) = integer#0)));
    insert charstring#"shell" into argv at integer#0;

    select command
      where (charstring#"exit")
        exit controlD;

      where (charstring#"cd")
	block
	  begin
	    call init.std.setCwd(charstring#(arg in argv 
		where (boolean#(integer#(position of arg) = integer#2))));
	  on (others)
	end block;

      where (charstring#"pwd")
	block
	  begin
	    call init.std.terminal.putLine(charstring#(init.std.getCwd()));
	  on (others)
	end block;

      otherwise
        block 
          declare
            main: main_Func;
          begin
	    main <- main_Func#(create of program#(
		init.Std.pathload(command)));
            call main(argv, init.environ, init.Std, init.unix, init.CLoader);

          on (load_intf.file_not_found)
	    call init.Std.terminal.putString(charstring#"Can't find '");
	    call init.Std.terminal.putString(command);
	    call init.Std.terminal.putLine(charstring#"'.");
          on (InterfaceMismatch)
	    call init.Std.terminal.putString(charstring#"Module '");
	    call init.Std.terminal.putString(command);
	    call init.Std.terminal.putLine(
		charstring#"' is not a main program.");
	  on (main_intf.discarded)
	    -- just a rude main process... we can't be bothered!
          on (others)
	    call init.Std.terminal.putString(charstring#"Can't run '");
	    call init.Std.terminal.putString(command);
	    call init.Std.terminal.putLine(charstring#"' -- reason unknown.");
        end block;
            
    end select;

  on (getStringIntf.endOfInput)
    exit controlD;
  on (tokenize.illFormed)
    call init.std.terminal.putLine("Invalid command syntax");
  on (notFound)
    -- user entered a null command; do nothing.
  end block; end while;

  return init;

on exit (controlD)
  call init.std.terminal.putLine(charstring#"^D");
  return init;

end process
