-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: profdetail.p
-- Author: David Bacon
-- SCCS Info: @(#)profdetail.p	1.2 3/13/90

profdetail: using (profile, main, common, string) linking(itoa, justify)
 -- program to print a detailed summary of a module  
   process (q: main_q)
    
  declare
    args: main_intf;
    argv: charstringList;
    junk: charstring;
    proffile: charstring;
    profiles: profiles;
    itoa: int2stringFn;
    justify: justifyFn;
    
  begin
    itoa := procedure of process itoa;
    justify := procedure of process justify;
    
    receive args from q;
    argv := args.argv;
    remove junk from argv[0];
    remove junk from argv[0];
    block begin
	remove proffile from argv[0];
      on (NotFound)
	proffile := "hprof";
      end block;
    
    unwrap profiles from args.std.pathReadObj(proffile) { init };
    for module_name in argv[]  inspect
        call args.std.terminal.putLine("Module "|module_name);
	for profile in profiles where(profile.name = module_name) inspect
	    call args.std.terminal.putLine("----");
	    for count in profile.counts[] inspect
	        call args.std.terminal.putLine(justify(itoa(count), 8));
	      end for;
	    
	    
	  end for;
      end for;
    
    return args;
  end process
   
