-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: cat.p
-- Author: Andy Lowry
-- SCCS Info: @(#)cat.p	1.2 3/13/90

-- Takes file names as command line arguments.  Reads each file and
-- then sends its contents out on stdout.  If "-" appears on the
-- command line, stdin is read and copied to stdout until endOfInput.

cat: using (rmain, stdio, common, unix, terminalIO)

process (Q: rmainQ)
  
declare
  args: rmain;
  stdout: stdout;
  stdin: stdin;
  argv: charStringList;
  unix: unix;
  rbuf: unix!array;
  bufString: charString;
begin
  receive args from Q;
  
  -- get file reading capabilities and set up read buffer
  unwrap unix from args.rm.get("unix", "") {
    init, init(stdio), init(stdio.fopen), init(stdio.fclose),
    init(stdio.fread)};
  bufString <- "12345678901234567890123456789012345678901234567890123456789012345678901234567890";
  new rbuf;
  rbuf.size <- int#1;
  rbuf.string := bufString;
  rbuf.count <- int#(convert of size of rbuf.string);

  -- get output capabilities
  unwrap stdout from args.rm.get("stdout", "stdio")
      {init, init(putChar), init(putString), init(putLine)};
  
  -- get list of files to be output
  unwrap argv from args.rm.get("argv", "") {init};
  
  -- process each file in turn, skipping interpreter name and our
  -- program name
  for arg in argv where (position of arg >= 2) inspect
    if arg = "-" then
      block begin
	unwrap stdin from args.rm.get("stdin", "stdio") 
	    {init, init(getString), init(getChar)};
	while 'true' repeat
	  call stdout.putLine(stdin.getString());
	end while;
      on (getStringIntf.endOfInput)
      end block;
    else
      block declare
	nread: int;
	handle: handle;
      begin
	handle <- handle#(unix.stdio.fopen(copy of arg, "r"));
	if handle = handle#0 then
	  exit problem;
	end if;
	nread <- int#(unix.stdio.fread(rbuf, handle));
	while nread <> int#0 repeat
	  -- make sure the buffer string isn't shared, because the
	  -- unix stuff can't handle that
	  block declare
	    junk: char;
	  begin
	    remove junk from c in rbuf.string[-1];
	  on (notFound)
	  end block;
	  call stdout.putString(rbuf.string);
	  rbuf.string := bufString;
	  nread <- int#(unix.stdio.fread(rbuf, handle));
	end while;
	call unix.stdio.fclose(handle);
      on exit(problem)
	-- couldn't open this file
      end block;

    end if;
  end for;
  return args;
end process
