-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: mustmake.p
-- Author: Daniel Yellin
-- SCCS Info: "@(#)mustmake.p	1.4 3/13/90"
-- description:
-- mustMake takes a Hermes object name and a table of dependent objects.  It 
-- returns true if the any of the dependencies has a later 
-- (modification) time stamp than the object.  
-- The initialization of mustMake receives a timestamp function (which, given
-- an object name returns its timestamp) and returns the mustMake service.  

mustmake: using(mustmake,timestamp,unix)
process(initQ: mustMakeInitQ)

declare
   initargs: mustMakeInitIntf;
   q: mustMakeQ;
   args: mustmakeIntf;
   timestamp: timestamp!tsrequestFn;   
   fileMTime: unix!long;
begin

  receive initargs from initQ;
-- copy out timestamp function and return mustmake function
  timestamp := initargs.timestampFn;
  new q;
  connect initargs.mustMake to q;
  return initargs;

  while 'true' repeat
    block begin
      receive args from q;
      fileMTime <- timestamp(args.fn);
      if fileMTime = -1 
      then  -- object doesn't exist so it must be made
         args.mustmake <- 'true';
         exit ret;
      end if;
-- otherwise check that dependencies exist and have an earlier timestamp
      for dependency in args.dependencies where('true')
      inspect
        if fileMTime < timestamp(dependency)
        then 
	    args.mustMake <- 'true';
            exit ret;
        end if;
      end for;
      args.mustMake <- 'false';  
      return args;
    on exit (ret) 
      return args;
    end block;
  end while;

end process

