-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: charposition.p
-- Author: Daniel Yellin
-- SCCS Info: "@(#)charposition.p	1.3 3/13/90"
-- description: this function is passed a character c and a string s.
-- It returns the integer p, where s[p] is the FIRST occurence of c in s.
-- returns the position of the FIRST 
charposition: using(predefined, getuses)
process (Q: CharPosQ)

declare
  args: CharPosIntf;
  found: boolean;
  pos: integer;

  begin
  receive args from Q;
  found := 'false';
  args.pos <- -1;
  pos := 0;
  while (not found) and pos < size of args.s repeat
    if args.c = args.s[pos]
    then
      args.pos := pos; found := 'true';
    else pos <- pos + 1;
    end if;
  end while;
  return args;
end process
