/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
#ifndef lint
static char sccsinfo[] = "@(#)recursiv.c	1.9 3/13/90";
#endif

/*
 * recursiv.c
 *
 * builds the static table of data-representation-dependent functions to
 * invoke when performing a generic recursive operation.
 *
 * There are three generic operations: finalize, copy, and equal.  The pseudo-
 * interface declarations are as follows:
 *
 * void finalize(valcell value, finalize_op f_op, schedblock *sched);
 * predef_exception copy(valcell dst, valcell src);
 * status equal(valcell value1, valcell value2);
 *
 * The copy operation could return Normal, Depletion or UnCopyable.
 * In the non-Normal cases, the destination operand is guaranteed not
 * to have been touched.
 */

#include <stdio.h>

#include "li.h"

void
    fin_bottom(),
    fin_scalar(),
    fin_nominal(), fin_real(),
    fin_record(), fin_variant(), fin_table(),
    fin_polymorph(),
    fin_inport(), fin_outport(), fin_callmessage(),
    fin_program();

predef_exception
    cp_bottom(),
    cp_scalar(), 
    cp_nominal(), cp_real(),
    cp_record(), cp_variant(), 
    cp_table(),
    cp_polymorph(),
    cp_outport(), 
    cp_program();

status
    eq_bottom(),
    eq_boolean(), eq_integer(), eq_enumeration(), eq_ord_enumeration(),
    eq_nominal(), eq_real(),
    eq_record(), eq_variant(), eq_table(),
    eq_polymorph(),
    eq_inport(), eq_outport(), eq_callmessage(),
    eq_program();


void
  prt_noop(),
  prt_bottom(),
  prt_ord_scalar(), prt_boolean(), prt_ord_enumeration(),
  prt_nominal(), 
  prt_record(), prt_variant(), prt_table(),
  prt_polymorph(),
  prt_inport(), prt_callmessage(),
  prt_program();


xdr_status
  hxdr_noop(),
  hxdr_bottom(),
  hxdr_integer(), hxdr_enumeration(), hxdr_boolean(),
  hxdr_nominal(),
  hxdr_record(), hxdr_variant(), hxdr_program(),
  hxdr_callmessage(), hxdr_outport(),
  hxdr_polymorph(),
  hxdr_table();

comparison
  cmp_noop(), cmp_illegal(),
  cmp_bottom(),
  cmp_integer(), cmp_unsigned(), cmp_boolean(), cmp_real(), cmp_nominal(),
  cmp_record(), cmp_variant(), cmp_table();




/*ARGSUSED*/
predef_exception
cp_noop(dst,src)
valcell *dst, src;
{
    return(Uncopyable);
}


/* Hash functions haven't been implemented yet */
void h_noop() {}


/*
 * scalar data representations
 */

datarep dr_bottom = {
    1,
    "Uninitialized Object",
    fin_bottom,
    cp_bottom,
    eq_bottom,
    prt_bottom,
    hxdr_bottom,
    cmp_bottom,
    h_noop
  };

datarep dr_boolean = {
    2,
    "Boolean",
    fin_scalar,
    cp_scalar,
    eq_boolean,
    prt_boolean,
    hxdr_boolean,
    cmp_boolean,
    h_noop
  };


datarep dr_integer = {
    3,
    "Integer",
    fin_scalar,
    cp_scalar,
    eq_integer,
    prt_ord_scalar,
    hxdr_integer,
    cmp_integer,
    h_noop
  };

datarep dr_enumeration = {
    4,
    "Enumeration",
    fin_scalar,
    cp_scalar,
    eq_enumeration,
    prt_ord_scalar,
    hxdr_enumeration,
    cmp_unsigned,
    h_noop
  };

datarep dr_ord_enumeration = {
    5,
    "Ordered Enumeration",
    fin_scalar,
    cp_scalar,
    eq_ord_enumeration,
    prt_ord_enumeration,
    hxdr_enumeration,
    cmp_unsigned,
    h_noop
  };


/*
 * scalars that don't just occupy a single word
 */

datarep dr_nominal = {
    6,
    "Nominal",
    fin_nominal,
    cp_nominal,
    eq_nominal,
    prt_nominal,
    hxdr_nominal,
    cmp_nominal,
    h_noop
  };

#ifdef UNIMPLEMENTED

datarep dr_real = {
    7,
    "Real",
    fin_real,
    cp_real,
    eq_real,
    prt_real,
    hxdr_noop,
    cmp_real,
    h_noop
  };

#endif

/*
 * composite datatypes
 */

datarep dr_record = {
    8,
    "Record",
    fin_record,
    cp_record,
    eq_record,
    prt_record,
    hxdr_record,
    cmp_record,
    h_noop
  };

datarep dr_variant = {
    9,
    "Variant",
    fin_variant,
    cp_variant,
    eq_variant,
    prt_variant,
    hxdr_variant,
    cmp_variant,
    h_noop
  };

datarep dr_table = {
    10,
    "Table",
    fin_table,
    cp_table,
    eq_table,
    prt_table,
    hxdr_table,
    cmp_table,
    h_noop
  };



datarep dr_polymorph = {
    11,
    "Polymorph",
    fin_polymorph,
    cp_polymorph,
    eq_polymorph,
    prt_polymorph,
    hxdr_polymorph,
    cmp_noop,
    h_noop
  };

/*
 * programming-in-the-large types
 */

datarep dr_inport = {
    12,
    "Inport",
    fin_inport,
    cp_noop,
    eq_inport,
    prt_inport,
    hxdr_noop,
    cmp_unsigned,		/* inports are "nominal" values. */
    h_noop
  };


datarep dr_outport = {
    13,
    "Outport",
    fin_outport,
    cp_outport,
    eq_outport,
    prt_noop,
    hxdr_outport,
    cmp_unsigned,
    h_noop,
  };


datarep dr_callmessage = {
    15,
    "Callmessage",
    fin_callmessage,
    cp_noop,
    eq_callmessage,
    prt_callmessage,
    hxdr_callmessage,
    cmp_noop,
    h_noop
  };



datarep dr_program = {
    16,
    "Program",
    fin_program,
    cp_program,
    eq_program,
    prt_program,
    hxdr_program,
    cmp_noop,
    h_noop
  };


datarep *datarepmap[] =
{
    nil,			/* 0 is reserved */
    &dr_bottom,
    &dr_boolean,
    &dr_integer,
    &dr_enumeration,
    &dr_ord_enumeration,
    &dr_nominal,
    nil,			/* real */
    &dr_record,
    &dr_variant,
    &dr_table,
    &dr_polymorph,
    &dr_inport,
    &dr_outport,
    nil,			/* used to be procport */
    &dr_callmessage,
    &dr_program,
};

#define NDATAREP (sizeof(datarepmap)/sizeof(datarepmap[0]))

static datarep qdatareps[NDATAREP];
datarep *qdatarepmap[NDATAREP];

/* routine to finalize a quopy... it's a noop, since quopies should */
/* never be finalized */

/*ARGSUSED*/
static void
fin_quopy(v, f_op, sched)
valcell v;
finalize_op f_op;
schedblock *sched;
{
}

/* This routine creates the table of quopy datareps.  Each is */
/* identical to the normal datarep in every way, except that its */
/* finalization routine is set to fin_quopy */

void
make_quopy_datareps()
{
    void fin_quopy();

    int i;

    for (i = 0; i < NDATAREP; i++) {
	if (datarepmap[i] isnt nil) {
	    qdatareps[i] = *datarepmap[i];
	    qdatareps[i].finalize = fin_quopy;
	    qdatarepmap[i] = &qdatareps[i];
	}
	else
	  qdatarepmap[i] = nil;
    }
}


