/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: o_enum.c */
/* Author: David F. Bacon */
#ifndef lint
static char sccsinfo[] = "@(#)o_enum.c	1.5 3/13/90";
#endif

#include "ops.h"
#include "sysdep.h"
#include "accessors.h"

#include "interpform.cd"

extern datarep dr_enumeration, dr_ord_enumeration, dr_integer, dr_boolean;

/* un-ordered enumerations */

#define init_enumeration(objectp, val) \
	(set_init((objectp), dr_enumeration), \
        (objectp)->value.enumeration = (val))


NILOP(o_enum_lit)
{
  init_enumeration(DstObj, args->qualifiers.integer);
}

status
eq_ord_enumeration(s1, s2)
valcell s1, s2;
{
    if (s1.ord_enum is s2.ord_enum)
      return(SUCCESS);
    else
      return(FAILURE);
}


/* ordered enumerations */

#define Dst (DstObj->value.ord_enum)
#define Src (SrcObj->value.ord_enum)
#define Src1 (Src1Obj->value.ord_enum)
#define Src2 (Src2Obj->value.ord_enum)

#define init_ord_enumeration(objectp, val) \
	(set_init((objectp), dr_ord_enumeration), \
        (objectp)->value.ord_enum = (val))


NILOP(o_ordenum_lit)
{
  init_ord_enumeration(DstObj, args->qualifiers.integer);
}

NILOP(o_oegt)
{
    OPCHK(Src1Obj,ord_enumeration);
    OPCHK(Src2Obj,ord_enumeration);
    if (Src1 > Src2)
      DstObj->value.boolean = nil_true;
    else
      DstObj->value.boolean = nil_false;

    set_init(DstObj, dr_boolean);
}


NILOP(o_oege)
{
    OPCHK(Src1Obj,ord_enumeration);
    OPCHK(Src2Obj,ord_enumeration);
    if (Src1 >= Src2)
      DstObj->value.boolean = nil_true;
    else
      DstObj->value.boolean = nil_false;

    set_init(DstObj, dr_boolean);
}


NILOP(o_oelt)
{
    OPCHK(Src1Obj,ord_enumeration);
    OPCHK(Src2Obj,ord_enumeration);
    if (Src1 < Src2)
      DstObj->value.boolean = nil_true;
    else
      DstObj->value.boolean = nil_false;

    set_init(DstObj, dr_boolean);
}


NILOP(o_oele)
{
    OPCHK(Src1Obj,ord_enumeration);
    OPCHK(Src2Obj,ord_enumeration);
    if (Src1 <= Src2)
      DstObj->value.boolean = nil_true;
    else
      DstObj->value.boolean = nil_false;

    set_init(DstObj, dr_boolean);
}

NILOP(o_oecvt_int)
{
  OPCHK(SrcObj,ord_enumeration);
  Dst = Src;
  set_init(DstObj, dr_integer);
}


status
eq_enumeration(s1, s2)
valcell s1, s2;
{
    if (s1.enumeration is s2.enumeration)
      return(SUCCESS);
    else
      return(FAILURE);
}


NILOP(o_oeinitloop)
{
    init_ord_enumeration(DstObj, 0);
}


NILOP(o_oeloop)
{
    OPCHK(DstObj,ord_enumeration);

    Dst++;

    if (Dst < dot(args->qualifiers, integer_pair__int_two).integer) 
      args->nextop = dot(args->qualifiers, integer_pair__int_one).integer;
}
