-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)unix.d	1.3 3/13/90

unix: using (predefined) definitions

  unix: record (
    call: unixcall_func,
    access: access_func,
    r_external:read_external_variablefunction,
    stdio: stdio
  );


  unixcall_intf: callmessage (
    function: syscall,
    operands: unixoperand_list,
    return: unixoperand
  ) constant (function)
    exit { full }
    exception bad_arguments { init(function), init(operands) };
-- fill in all the standard unix exceptions

  unixcall_q: inport of unixcall_intf { init(function), init(operands) };

  unixcall_func: outport of unixcall_q;


  int: pragma "C int" integer;

  short: pragma "C short" integer;

  long: pragma "C long" integer;

  unsigned_int: pragma "C unsigned int" integer;

  unsigned_short: pragma "C unsigned short" integer;

  unsigned_long: pragma "C unsigned long" integer;

  handle: pragma "C long" integer;


  unixoperand_type: enumeration (
    'void',
    'char',
    'int',
    'short',
    'long',
    'unsigned_int',
    'unsigned_short',
    'unsigned_long',
    'handle',
    'boolean',
    'string',
    'buffer',
    'array'
  );


  unixoperand: variant of unixoperand_type (
    'void' -> void: empty { },
    'char' -> char: predefined!char { init },
    'int' -> int : int { init },
    'short'-> short: short { init },
    'long' -> long: long { init },
    'unsigned_int' -> unsigned_int: unsigned_int { init },
    'unsigned_short'-> unsigned_short: short { init },
    'unsigned_long' -> unsigned_long: unsigned_long { init },
    'handle' -> handle: handle { init },
    'boolean' -> boolean: predefined!boolean { init },
    'string' -> string: predefined!charstring { init },
    'buffer' -> buffer: buffer { full },
    'array' -> array: array { full }
  );

  unixoperand_list: ordered table of unixoperand { init };


  buffer: record (
    string: predefined!charstring,
    size: int
  );

  array: record (
    string: predefined!charstring,
    size: int,
    count: int
  );


-- fill in automatically from man pages or include files:

  syscall: enumeration (
    'test',
    'MakeNotBlock', /* int MakeNotBlock(handle) */
    'ClearErrno', /* void ClearErrno() */
    'clearerr', /* void clearerr(handle) */
    'ctermid',  /* void ctermid(buffer) */
    'cuserid',  /* void cuserid(buffer) */
    'fclose',   /* void fclose(handle) */
    'fdopen',   /* handle fdopen(handle) */
    'feof',     /* boolean feof(handle) */
    'ferror',   /* boolean ferror(handle) */ 
    'fflush',   /* void fflush(handle) */
    'fgetc',    /* int fgetc(handle) */
    'fgets',    /* int fgets(buffer,handle) */
    'fileno',   /* handle fileno(handle) */
    'fopen',    /* handle fopen(string,string) */
    'fputc',    /* int fputc(char, handle) */
    'fputs',    /* int fputs(string, handle) */
    'fread',    /* int fread(array, handle) */
    'freopen',  /* handle freopen(string, string, handle) */
    'fseek',    /* int fseek(handle,long,int) */
    'ftell',    /* long ftell(handle) */
    'fwrite',   /* int fwrite(array, handle) */
    'getc',     /* int getc(handle) */
    'getchar',  /* int getchar() */
    'getw',     /* int getw(handle) */
    'pclose',   /* int pclose(handle) */
    'popen',    /* handle popen(string,string) */
    'putc',     /* int putc(char, handle) */
    'putchar',  /* int putchar(char) */
    'puts',     /* int puts(string) */
    'putw',     /* int putw(int,handle) */
    'rewind',   /* void rewind(handle) */
    'setlinebuf', /* void setlinebuf(handle) */
    'tmpfile',  /* handle tmpfile() */ 
    'tmpnam'    /* int tmpnam(buffer) */
  );

-- specific calls

  access: enumeration ( 'read', 'write', 'execute', 'exists' );

  access_Intf: callmessage (
    file: charstring,
    mode: access,
    ok: boolean
  ) constant (file, mode)
    exit { full };

  access_Q: inport of access_Intf { init(file), init(mode) };

  access_Func: outport of access_Q;

  external_variable: enumeration (
     'errno',
     'stdin',
     'stdout',
     'stderr'
  );

  read_external_variablecall: CALLMESSAGE (
   variable:external_variable,
   result: unixoperand
   )
   constant (variable)
   exit { full };
  read_external_variableinport: INPORT of read_external_variablecall { init(variable) };
  read_external_variablefunction: OUTPORT of read_external_variableinport;

stdio_server_call: CALLMESSAGE (
 unixCall: unixCall_func,
 unixRExternal: read_external_variableFunction,
 stdio: stdio
 ) constant (unixCall, unixRExternal)
 exit {full};

stdio_server_inport: INPORT of stdio_server_call 
	{ init(unixCall), init(unixRExternal) };
stdio_server_function: OUTPORT of stdio_server_inport;

stdio: RECORD (
 stdin: handle,
 stdout: handle,
 stderr: handle,
 clearerr:clearerr_function, 
 ctermid:ctermid_function,  
 cuserid:cuserid_function,  
 fclose:fclose_function,   
 fdopen:fdopen_function,   
 feof:feof_function,     
 ferror:ferror_function,   
 fflush:fflush_function,   
 fgetc:fgetc_function,    
 fgets:fgets_function,    
 fileno:fileno_function,   
 fopen:fopen_function,    
 fputc:fputc_function,    
 fputs:fputs_function,    
 fread:fread_function,    
 freopen:freopen_function,  
 fseek:fseek_function,    
 ftell:ftell_function,    
 fwrite:fwrite_function,   
 getc:getc_function,     
 getchar:getchar_function,  
 getw:getw_function,     
 pclose:pclose_function,   
 popen:popen_function,    
 putc:putc_function,     
 putchar:putchar_function,  
 puts:puts_function,     
 putw:putw_function,     
 rewind:rewind_function,   
 setlinebuf:setlinebuf_function,
 tmpfile:tmpfile_function,   
 tmpnam:tmpnam_function
 );

clearerr_call: CALLMESSAGE (
 op1: handle
 )
 constant(op1)
 exit { full }
 exception semantic_error { full (op1) };
clearerr_inport: INPORT of clearerr_call { full(op1) };
clearerr_function: OUTPORT of clearerr_inport;

ctermid_call: CALLMESSAGE (
 op1: buffer
 )
 exit { full }
 minimum { full(op1) }
 exception semantic_error { full (op1) };
ctermid_inport: INPORT of ctermid_call { full(op1) };
ctermid_function: OUTPORT of ctermid_inport;

cuserid_call: CALLMESSAGE (
 op1: buffer
 )
 exit { full }
 minimum { full(op1) }
 exception semantic_error { full (op1) };
cuserid_inport: INPORT of cuserid_call { full(op1) };
cuserid_function: OUTPORT of cuserid_inport;

fclose_call: CALLMESSAGE (
 op1: handle
 )
 constant(op1)
 exit { full }
 exception semantic_error { full (op1) };
fclose_inport: INPORT of fclose_call { full(op1) };
fclose_function: OUTPORT of fclose_inport;

fdopen_call: CALLMESSAGE (
 op1: handle,
 ret: handle
 )
 constant(op1)
 exit { full }
 exception semantic_error { full (op1) };
fdopen_inport: INPORT of fdopen_call { full(op1) };
fdopen_function: OUTPORT of fdopen_inport;

feof_call: CALLMESSAGE (
 op1: handle,
 ret: boolean
 )
 constant(op1)
 exit { full }
 exception semantic_error { full (op1) };
feof_inport: INPORT of feof_call { full(op1) };
feof_function: OUTPORT of feof_inport;

ferror_call: CALLMESSAGE (
 op1: handle,
 ret: boolean
 )
 constant(op1)
 exit { full }
 exception semantic_error { full (op1) };
ferror_inport: INPORT of ferror_call { full(op1) };
ferror_function: OUTPORT of ferror_inport;

fflush_call: CALLMESSAGE (
 op1: handle
 )
 constant(op1)
 exit { full }
 exception semantic_error { full (op1) };
fflush_inport: INPORT of fflush_call { full(op1) };
fflush_function: OUTPORT of fflush_inport;

fgetc_call: CALLMESSAGE (
 op1: handle,
 ret: int
 )
 constant(op1)
 exit { full }
 exception semantic_error { full(op1) };
fgetc_inport: INPORT of fgetc_call { full(op1) };
fgetc_function: OUTPORT of fgetc_inport;

fgets_call: CALLMESSAGE (
 op1: buffer,
 op2: handle,
 ret: int
 )
 constant(op2)
 exit { full }
 minimum { full(op1), full(op2) }
 exception semantic_error { full(op1), full(op2) };
fgets_inport: INPORT of fgets_call { full(op1), full(op2) };
fgets_function: OUTPORT of fgets_inport;

fileno_call: CALLMESSAGE (
 op1: handle,
 ret: int
 )
 constant(op1)
 exit { full }
 exception semantic_error { full(op1) };
fileno_inport: INPORT of fileno_call { full(op1) };
fileno_function: OUTPORT of fileno_inport;

fopen_call: CALLMESSAGE (
 op1: charstring,
 op2: charstring,
 ret: handle
 )
 constant(op1, op2)
 exit { full }
 exception semantic_error { full(op1), full(op2) };
fopen_inport: INPORT of fopen_call { full(op1), full(op2) };
fopen_function: OUTPORT of fopen_inport;

fputc_call: CALLMESSAGE (
 op1: char,
 op2: handle,
 ret: int
 )
 constant(op1, op2)
 exit { full }
 exception semantic_error { full (op1), full(op2) };
fputc_inport: INPORT of fputc_call { full(op1), full(op2) };
fputc_function: OUTPORT of fputc_inport;

fputs_call: CALLMESSAGE (
 op1: charstring,
 op2: handle,
 ret: int
 )
 constant(op1, op2)
 exit { full }
 exception semantic_error { full (op1), full(op2) };
fputs_inport: INPORT of fputs_call { full(op1), full(op2) };
fputs_function: OUTPORT of fputs_inport;

fread_call: CALLMESSAGE (
 op1: array,
 op2: handle,
 ret: int
 )
 constant(op2)
 exit { full }
 minimum { full(op1), full(op2) }
 exception semantic_error { full(op1), full(op2) };
fread_inport: INPORT of fread_call { full(op1), full(op2) };
fread_function: OUTPORT of fread_inport;

freopen_call: CALLMESSAGE (
 op1: charstring,
 op2: charstring,
 op3: handle,
 ret: handle
 )
 constant(op1, op2, op3)
 exit { full }
 exception semantic_error { full(op1), full(op2), full(op3) };
freopen_inport: INPORT of freopen_call { full(op1), full(op2), full(op3) };
freopen_function: OUTPORT of freopen_inport;

fseek_call: CALLMESSAGE (
 op1: handle,
 op2: long,
 op3: int,
 ret: int
 )
 constant(op1, op2, op3)
 exit { full }
 exception semantic_error { full(op1), full(op2), full(op3)  };
fseek_inport: INPORT of fseek_call { full(op1), full(op2), full(op3) };
fseek_function: OUTPORT of fseek_inport;

ftell_call: CALLMESSAGE (
 op1: handle,
 ret: long
 )
 constant(op1)
 exit { full }
 exception semantic_error { full(op1) };
ftell_inport: INPORT of ftell_call { full(op1) };
ftell_function: OUTPORT of ftell_inport;

fwrite_call: CALLMESSAGE (
 op1: array,
 op2: handle,
 ret: int
 )
 constant(op1, op2)
 exit { full }
 exception semantic_error { full(op1), full(op2) };
fwrite_inport: INPORT of fwrite_call { full(op1), full(op2) };
fwrite_function: OUTPORT of fwrite_inport;

getc_call: CALLMESSAGE (
 op1: handle,
 ret: int
 )
 constant(op1)
 exit { full }
 exception semantic_error { full(op1) };
getc_inport: INPORT of getc_call { full(op1) };
getc_function: OUTPORT of getc_inport;

getchar_call: CALLMESSAGE (
 ret: int
 )
 exit { full }
 exception semantic_error { };
getchar_inport: INPORT of getchar_call { };
getchar_function: OUTPORT of getchar_inport;

getw_call: CALLMESSAGE (
 op1: handle,
 ret: int
 )
 constant(op1)
 exit { full }
 exception semantic_error { full(op1) };
getw_inport: INPORT of getw_call { full(op1) };
getw_function: OUTPORT of getw_inport;

pclose_call: CALLMESSAGE (
 op1: handle
 )
 constant(op1)
 exit { full }
 exception semantic_error { full (op1) };
pclose_inport: INPORT of pclose_call { full(op1) };
pclose_function: OUTPORT of pclose_inport;

popen_call: CALLMESSAGE (
 op1: charstring,
 op2: charstring,
 ret: handle
 )
 constant(op1, op2)
 exit { full }
 exception semantic_error { full(op1), full(op2) };
popen_inport: INPORT of popen_call { full(op1), full(op2) };
popen_function: OUTPORT of popen_inport;

putc_call: CALLMESSAGE (
 op1: char,
 op2: handle,
 ret: int
 )
 constant(op1, op2)
 exit { full }
 exception semantic_error { full(op1), full(op2) };
putc_inport: INPORT of putc_call { full(op1), full(op2) };
putc_function: OUTPORT of putc_inport;

putchar_call: CALLMESSAGE (
 op1: char,
 ret: int
 )
 constant(op1)
 exit { full }
 exception semantic_error { full(op1) };
putchar_inport: INPORT of putchar_call { full(op1) };
putchar_function: OUTPORT of putchar_inport;

puts_call: CALLMESSAGE (
 op1: charstring,
 ret: int
 )
 constant(op1)
 exit { full }
 exception semantic_error { full(op1) };
puts_inport: INPORT of puts_call { full(op1) };
puts_function: OUTPORT of puts_inport;

putw_call: CALLMESSAGE (
 op1: int,
 op2: handle,
 ret: int
 )
 constant(op1, op2)
 exit { full }
 exception semantic_error { full(op1), full(op2) };
putw_inport: INPORT of putw_call { full(op1), full(op2) };
putw_function: OUTPORT of putw_inport;

rewind_call: CALLMESSAGE (
 op1: handle
 )
 constant(op1)
 exit { full }
 exception semantic_error { full (op1) };
rewind_inport: INPORT of rewind_call { full(op1) };
rewind_function: OUTPORT of rewind_inport;

setlinebuf_call: CALLMESSAGE (
 op1: handle
 )
 constant(op1)
 exit { full }
 exception semantic_error { full (op1) };
setlinebuf_inport: INPORT of setlinebuf_call { full(op1) };
setlinebuf_function: OUTPORT of setlinebuf_inport;

tmpfile_call: CALLMESSAGE (
 ret: handle
 )
 exit { full }
 exception semantic_error { };
tmpfile_inport: INPORT of tmpfile_call { };
tmpfile_function: OUTPORT of tmpfile_inport;

tmpnam_call: CALLMESSAGE (
 op1: buffer,
 ret: int
 )
 exit { full }
 minimum { full(op1) }
 exception semantic_error { full (op1) };
tmpnam_inport: INPORT of tmpnam_call { full(op1) };
tmpnam_function: OUTPORT of tmpnam_inport;

end definitions
