/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* SCCS Info: @(#)procenv.h	1.4 3/13/90 */

#ifndef procenv_included

/* Each process is provided with a set of "registers", and all
** operands in LI code begin with a register number (an offset into
** the register set).  A few registers are reserved for fixed internal
** use.  FIRSTOBJECT is the index of the first register available for
** general use (equivalently, it is the number of reserved registers).
*/

/* Here are the fixed register assignments */
#define INITPORT 0
				/* the initport always goes here */

#define CALLMESSAGE 1
				/* the callmessage for the pending call of */
				/*  this process (which is anonymous) */

#define LASTERROR 2
				/* we store a faked-up handlername */
				/*  variant here.  this is used by the */
				/*  error handling routines.  it can */
				/*  also be used by the debugger to */
				/*  display the last error for the */
				/*  process. */

#define FIRSTOBJECT 3
				/* must be greater than any of the above */

#endif
#define procenv_included
