-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)findfile.p	1.5 3/13/90

findfile: using (findfile, initFindFile, common, unix, cwd)
process (initQ: initFindFileQ)

declare
  path: common!charstringList;
  access: unix!access_func;
  findfileQ: findfile_q;
  getCwd: cwd!getCwdFn;

begin
  block -- initialization block
  declare
    pos: integer;
    directory: charstring;
    char: char;
    initArgs: initFindFile;

  begin
    receive initArgs from initQ;

-- convert the hokey unix-style colon-separated string into an charstringList

    pos := integer#0;  directory := charstring#"";
    new path;

    while boolean#(pos < integer#(size of initArgs.path)) repeat
      char := char#( c in initArgs.path where (boolean#(integer#(
	      position of c) = pos)) );
      if boolean#(char = char#':') then
        insert directory into path;
        directory := charstring#"";
      else
        insert char into directory;
      end if;

      pos := integer#(pos + integer#1);
    end while;


    if boolean#(directory <> charstring#"") then
      insert directory into path;
    end if;

-- create the service port and return it

    access := initArgs.access;
    getCwd := initArgs.getCwd;

    new findfileQ;
    connect initArgs.pathfunc to findfileQ;
    
    return initArgs;
    discard initQ;
  end block;

-- go into an infinite service loop

  block
  declare
    file: charstring;
    args: findfile_intf;
    dot: char;

  begin
    while boolean#'true' repeat
      receive args from findfileQ;

      block begin
	
	if boolean#(char#(args.file[]) = char#'/') then
	  if boolean#(access(args.file, args.mode)) then
	    file := args.file;
	    exit foundfile;
	  end if;
	else
	  for dir in path[] inspect
	    file := dir;
	    if boolean#( integer#( size of file ) = integer#0) then
	      dot <- char#' ';
	    else
	      dot <- char#( file[] );
	    end if;
	    if boolean#( char#'.' = dot) then
	      remove dot from file[];
	      if boolean# (integer#( size of file ) = integer#0) then
		dot <- char#' ';
	      else
		dot <- char#(file[]);
	      end if;
	      if boolean#( char#'.' = dot) then
		remove dot from file[];
		block declare
		  cwd: charstring;
		  slashpos: integer;
		begin
		  cwd <- charstring#( getCwd() );
		  slashpos <- integer#0;
		  for c in cwd[] inspect
		    if boolean#(c = char#'/') then
		      slashpos <- integer#(position of c);
		    end if;
		  end for;
		  if boolean#(slashpos <> integer#0) then
		    cwd <- charstring#(every of c in cwd where
			  (boolean#(integer#(position of c) < slashpos)));
		    file <- charstring#(cwd | file);
		  end if;
		end block;
	      else
		file := charstring#( charstring#( getCwd() ) | file );
	      end if;
	    end if;
	    insert char#'/' into file;
	    merge charstring#(copy of args.file) into file;

	    if boolean#(access(file, args.mode)) then
	      exit foundFile;
	    end if;
	  end for;
	end if;

	return args exception file_not_found;

      on exit (foundFile)
	args.foundfile <- file;
	return args;
      end block;

    end while;

  end block;
end process
