/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: stack.c */
/* Author: David F. Bacon */
#ifndef lint
static char sccsinfo[] = "@(#)stack.c	1.4 3/13/90";
#endif


#include "li.h"
#include "storage.h"

#include "resolve.h"
#include "stack.h"


void
stack_create(stk)
stackpp stk;
{
    *stk = nil;
}


void
stack_push(stk, elem)
stackpp stk;
objectp elem;
{
    stackp new_frame;

    new_frame = tnew(stack);
    new_frame->value = elem;
    cdr(new_frame) = *stk;
    *stk = new_frame;
}



objectp 
stack_top(stk)
stackpp stk;
{
    if (*stk)
      return((*stk)->value);
    else
      return(nil);
}


objectp 
stack_pop(stk)
stackpp stk;
{
    objectp topval;
    stackp newtop;

    topval = stack_top(stk);
    newtop = cdr(*stk);

    *stk = newtop;

    return(topval);
}


void
stack_popndrop(stk)
stackpp stk;
{
    (void) stack_pop(stk);
}


objectp 
stack_popntop(stk)
stackpp stk;
{
    stack_popndrop(stk);
    return(stack_top(stk));
}


/* there be times when we want to use the stack like a list */

objectp 
stack_next(stk)
stackpp stk;
{
    *stk = cdr(*stk);
    return(stack_top(stk));
}
