/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: integrated.ch */
/* Author: David F. Bacon */
#ifndef lint
static char sccsinfo[] = "@(#)integrated.ch	1.9 4/20/90";
#endif

#include <string.h>
#include <sys/file.h>

#include "cherm.h"
#include "resolve.h"
#include "storage.h"
#include "unixenv.h"

#include "predefined.cd"
#include "filedef.cd"
#include "initparse.cd"
#include "parse.cd"
#include "errors.cd"
#include "positions.cd"


flag integrated = TRUE;


objectp
io_read_definition(Name)
objectp Name;			/* constant chs_table */
{
    status hermcall();

    extern objectp Porthackp;
    extern schedblock *schedhack;

    objectp Filedef;		/* filed_definition */
    lobject(Poly);
    lobject(Filename);
    lobject(Extension);
    status rc;
    
    chs_lit(Extension, DEF_OBJECT_EXTENSION);
    concat(Filename, Name, Extension);

    Filedef = new_object();
    copy(Poly, Bottom);
    rc = hermcall(schedhack, Porthackp@parsefns__readobj, Filename, Poly, nil);
    discard(Extension);
    discard(Filename);

    if (rc) {
	unwrap(Filedef, Poly, nil);
	return(Filedef);
    }
    else {			/* an exception was raised.... */
				/* read in the module.  if error reading... */
	fe_error(LASTPHASE, errorcode__general_error,
		"Compiled definition module '%s' not found", stringval(Name));

	return(nil);
    }
}


void
io_write_definition(modulename, Moduleid, Defs, Printmaps, Procmaps, Modmap)
char *modulename;
objectp Moduleid;		/* constant */
objectp Defs;
objectp Printmaps;
objectp Procmaps;
objectp Modmap;
{
    extern object *ParsedefCmsgp;

    copy(ParsedefCmsgp@parsedef__id, Moduleid);
    move(ParsedefCmsgp@parsedef__definitions, Defs);
    move(ParsedefCmsgp@parsedef__printmaps, Printmaps);
    move(ParsedefCmsgp@parsedef__constraintmaps, Procmaps); /* always bottom */
    move(ParsedefCmsgp@parsedef__modulemap, Modmap); 
    /* errors are created on entry and entered by fe_error */
}



objectp
io_read_proc(Name)
objectp Name;			/* constant chs_table */
{
  status hermcall();

  extern objectp Porthackp;
  extern schedblock *schedhack;

  objectp Fileproc;		/* filed proc */
  status rc;

  Fileproc = new_object();
  rc = hermcall(schedhack, Porthackp@parsefns__load, Name, Fileproc, nil);
  
  if (rc) {
    return(Fileproc);
  }
  else {			/* an exception was raised */
    fe_error(LASTPHASE, errorcode__general_error,
	     "Compiled process module '%s' not found", stringval(Name));
    return(nil);
  }
}

void
io_write_proc(modulename, Absprog, Defmaps, Printmaps, Posmaps, Modmap, Links)
char *modulename;
objectp Absprog;
objectp Defmaps;
objectp Printmaps;
objectp Posmaps;
objectp Modmap;
objectp Links;
{
    extern object *ParseprocCmsgp;

    move(ParseprocCmsgp@parseproc__absprog, Absprog);
    move(ParseprocCmsgp@parseproc__defmap, Defmaps);
    move(ParseprocCmsgp@parseproc__execmap, Printmaps);
    move(ParseprocCmsgp@parseproc__posmap, Posmaps);
    move(ParseprocCmsgp@parseproc__modulemap, Modmap);
    move(ParseprocCmsgp@parseproc__links, Links);
    /* errors are created on entry and entered by fe_error */
}


/*ARGSUSED*/
void
io_printerror(filename, code, lineno, severity, msg)
char *filename;
int code, lineno;
char *severity;
char *msg;
{
    extern object *ParseprocCmsgp;
    extern object *ParsedefCmsgp;

    flag is_definitions_module();

    lobject(Error);
    lobject(CPos);
    lobject(Errobj);
    lobject(Etext);
    lobject(Emsg);

    new_record(Error, error);
    new_record(CPos, cposition);
    if (filename isnt nil)
      chs_lit(CPos@cposition__file, filename);
    else
      chs_lit(CPos@cposition__file, "");
    ilit(CPos@cposition__line, lineno);
    ilit(CPos@cposition__column, 0);
    unite(Error@error__position, CPos, positiontype__source);
    enum_lit(Error@error__code, code);
    vec_new_table(Error@error__objects, 0);
    chs_lit(Etext, severity);
    chs_lit(Emsg, msg);
    merge(Etext, Emsg);
    copy(Errobj, Bottom);
    unite(Errobj, Etext, errorobjecttype__charstring);
    insert(Error@error__objects, Errobj);
    if (is_definitions_module()) {
	insert(ParsedefCmsgp@parsedef__errors, Error);
    }
    else {
	insert(ParseprocCmsgp@parseproc__errors, Error);
    }
}
