-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: cgtheelement.pp
-- Author: Andy Lowry
-- SCCS Info: @(#)cgtheelement.pp	1.10 3/13/90

-- This process generates code for a table element copy operation (the
-- operation performed when a selector is used directly as an
-- expression.  The code is based on an 'exactlyOne' loop skeleton
-- produced by cgSelector.  In the body of the loop, a matching table
-- element is copied from the source table into the destination object..

-- A 'scan' style loop ends up looking like this:
--
-- 	initget 	r,t
-- loop:get_or_err 	r,t
--	[additional tests, result in 'test']
--	bfalse 		test {loop}
--      copy 		dst,r
--	endget		r,t
--

#include "typemark.h"
#include "codegen.h"

cgTheElement: using (cgInternal, interpform)

process (Q: cgStmtQ)

declare
  args: cgStmt;
  tbl: objectname;		-- source table
  tblAddr: interpform!operand;	-- its LI address
  lk: lookupInfo;		-- describes lookup method used in loop
  endLoop: cgSelectorContinueFn; -- call this to tie off the loop
  empty: empty;

begin
  receive args from Q;
  reveal args.stmt.qualifier.selector;

  -- Get source table LI address
  tbl <- objectname#(AREF(tmp,args.stmt.operands,ONE));
  tblAddr <- interpform!operand#(args.cgData.Proc.objAddr(tbl));

  -- Now generate the top part of the loop skeleton
  endLoop <- cgSelectorContinueFn#(FNS.cgSelector(
      args.stmt.qualifier.selector, args.cgData,
      typename#(args.cgData.Proc.objType(tbl)),
      selectorLoopType#'exactlyOne', lk, tblAddr));

  -- Now the copy operation in the loop body
  block declare
     op: interpform!operation;
  begin
    new op;
    op.opcode <- interpform!opcode#'copy';
    new op.operands;
    insert interpform!operand#(args.cgData.Proc.objAddr(
	objectname#(AREF(tmp,args.stmt.operands,ZERO)))) into op.operands;
    insert interpform!operand#(args.cgData.Proc.rootAddr(
	    args.stmt.qualifier.selector.element,
	    args.stmt.qualifier.selector.scope))
	into op.operands;
    unite op.qualifier.empty from empty;

    ADDINSTR(op);

  end block;

  -- Now finish up the loop skeleton
  call endLoop(args.cgData);

  return args;

end process
