-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
opentracewindow:  using(tracewindow, safewindowgen, safewindow, terminalio, common) linking(tracewindow) process (init: opentracewindow_initQ)
  declare 
    parms: opentracewindow_init; -- request to build opentracewindow
    safewindowgen: safewindowgenFn; -- generate safewindow callmessage
    openwindow: safewindowFn; -- open window 
    opentracewindow: safewindowQ; -- open trace window
    tracewindow_filter_init: tracewindow_filter_initFn; -- filter process
    openRQ: safewindow; -- request to open a window
    realwindow: terminalCM; -- the real window
  begin
    receive parms from init;
    -- build the filter-init program
    -- save access to the openwindow service
    -- return access to the opentracewindow program
    tracewindow_filter_init <- procedure of process tracewindow;
    openwindow := parms.openwindow;
    new opentracewindow;
    connect parms.opentracewindow to opentracewindow;
    return parms;
    
    while ('true')
      repeat
	receive openRQ from opentracewindow;
	-- open a real window
	-- then create a filter and return access to the filter
	call openwindow(openRQ.label, openRQ.options, realwindow);
	call tracewindow_filter_init(realwindow, openRQ.terminal);
	return openRQ;
      end while;
      
  end process
