-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
wshell2: using(umain, common, terminalio, load, rManager, usub, tokenize, safewindow) process (init: umainIn)
  declare
    parms: umain; -- initialization parameters
    getprogram: load_func; -- program loader
    io: useraccess; -- access to outside world
    terminal: terminalFunctions; -- terminal i/o
    username: charstring; -- user name
    application: usubout; -- port to start application
    continue: boolean; -- continue looping
    rm: rManager; -- ports to resource manager
    initTokenize: tokenizeInitFn;
    tokenize: tokenizeFn;
    tokenStrings: tokenStringsFn;
    shellname: charstring;
    
    -- trace data
    opentracewindow: safewindowFn;
    tracewindow: terminalCM;
    
  begin
    -- Algorithm:
    -- 1. Get GetProgram service
    -- 2. Loop
    --    2.1. parse the application name -- prepend 'wshell' to it, like shell
    --    2.2. Load the application
    --    2.3. run the application
    receive parms from init;
    terminal := parms.io.terminal;
    username := parms.io.username;
    rm := parms.io.resource;
    io <- parms.io;
    unwrap getprogram from rm.get("GetProgram", "") {init};
    return parms;
    
    initTokenize <- create of GetProgram("tokenize");
    block declare
      wordChars: charString;
      whiteChars: charString;
    begin
      wordChars <- "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
      wordChars <- wordChars | "1234567890!@#$%^&*_+|~-=\`;:,./?";
      whiteChars <- " ";
      insert 'HT' into whiteChars;
      tokenize <- initTokenize(wordChars, whiteChars, "'""", "(){}[]<>");
    end block;
    tokenStrings <- procedure of GetProgram("tokenstrings");

    continue <- 'true';
    shellname <- "shell";
    unwrap opentracewindow from rm.get("OpenTraceWindow", "shell "|username) {init};
    tracewindow <- opentracewindow("trace shell "|username, "-Wh 5 -Ww 40 -inverse");
    call tracewindow.terminal.PutLine("Initialized");

    while (continue)
      repeat
        BLOCK
          declare
            commandline: charstring; -- raw command line
            argv: charstringList; -- commands after tokenization
            applname: charstring; -- name of application
            parameters: charstring; -- parameters
          BEGIN
            call terminal.PutString(shellname|":");
            call terminal.Getstring(commandline);
	    argv <- tokenStrings(tokenize(commandline));
            insert copy of shellname into argv at (0);
            if size of argv > 1
              then
                applname := argv[1];
              else
                applname := " ignore ";
              end if;
            select (applname)
              where (" ignore ")
              where ("newprompt")
                if size of argv > 2
                  then
                    shellname <- argv[2];
                  end if;
              where ("quit")
                continue <- 'false';
              otherwise
                call tracewindow.terminal.PutLine("Creating application "|applname);
                application <- create of GetProgram(applname);
                call tracewindow.terminal.PutLine("Calling application "|applname);
                call application(argv, io);
                call tracewindow.terminal.PutLine("Application returned normally");
              end select;
          on (NotFound)
            call terminal.PutLine("Unexpected Not-Found");
          on (load_intf.file_not_found)
            call terminal.PutLine("Not found:"|applname);
          on (InterfaceMismatch)
            call terminal.PutLine("Not compatible:"|applname);
          on (usub.discarded)
            call tracewindow.terminal.PutLine("Application returned abnormally");
            call terminal.PutLine("Application returned abnormally");
          on (others)
            call terminal.PutLine("unexpected error");
          END BLOCK;
      end while;
    return io;
  end process
