-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
wshell: using(application_init, terminalio, load, sysRManager) process (init: application_init_In)
  declare
    parms: application_init; -- initialization parameters
    getprogram: load_func; -- program loader
    terminal: terminalFunctions; -- terminal i/o
    username: charstring; -- user name
    application: application_init_out; -- port to start application
    continue: boolean; -- continue looping
    rm: sysRManager; -- ports to resource manager
  begin
    -- Algorithm:
    -- 1. Get GetProgram service
    -- 2. Loop
    --    2.1. Prompt for an application name and parameters or 'quit'
    --    2.2. Load the application
    --    2.3. run the application
    receive parms from init;
    terminal := parms.terminal;
    username := parms.username;
    rm := parms.resource;
    unwrap getprogram from rm.get(username, "GetProgram", "") {init};
    return parms;
    
    continue <- 'true';
    while (continue)
      repeat
        BLOCK
          declare
            applname: charstring; -- name of application
            parameters: charstring; -- parameters
          BEGIN
            call terminal.PutString("application name, or quit:");
            call terminal.Getstring(applname);
            if applname = "quit"
              then
                continue <- 'false';
              else
                application <- create of GetProgram(applname);
                call terminal.PutString("parameters:");
                call terminal.Getstring(parameters);
                call application(username, parameters, terminal, rm);
              end if;
          on (load_intf.file_not_found)
            call terminal.PutLine("Not found:"|applname);
          on (InterfaceMismatch)
            call terminal.PutLine("Not compatible:"|applname);
          END BLOCK;
      end while;
  end process
