-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
master4: using(rmain, stdenv, CLoad, rmDemoD, sysRManager, rManager, safewindow, safewindowinit, umain, appt_scheduler_init, load, terminalio, appt_scheduler_operator, appt_scheduler_registrant, master2_internal, master_monitor, usermonitor, ufilter_init, solicitor, common, tokenize, tracewindow) linking(ac_trivial, solicitor, usermonitor, ufilter)
  process (init: sysRMainQ)
  declare
    parms: sysRMain; -- initialization parameters
    
    -- procedures
    ac_trivial: AccessFn; -- trivial access control (gives to everybody)
    ac_tracewin: AccessFn; -- access control for trace windows
    solicitor: solicitorOut; -- creates process which prompts for commands
    usermonitor: usermonitorOut; -- creates user monitor
    ufilter: ufilter_initOut; -- creates filter
    tokenize: tokenizeFn;
    initTokenize: tokenizeInitFn;
    tokenStrings: tokenStringsFn;
    
    -- ports to processes
    rm_ports: sysRManager; -- ports to the resource manager
    openwindow: safewindowFn; -- port to open a window
    opentracewindowinit: opentracewindow_initFn; -- create opentracewindows
    opentracewindow: safewindowFn; -- port to open a trace window
    shutdown: Shutdown_Appt_Scheduler_out; -- operator shutdown port
    reset: Reset_Appt_Scheduler_out; -- operator reset port
    register: add_member_out; -- port to register with scheduler
    resource: polymorph; -- polymorph resource being posted
    getprogram: load_func; -- program to load other programs
    
    -- data
    masterwindow: terminalCM; -- window to use for future commands
    smallwindowoptions: charstring; -- options for small window
    users: users; -- user's windows, user's filters
    continue: boolean; -- true to continue looping
    tracewindow: terminalCM; -- window for trace data
    
    -- input ports
    obituary: master_monitorIn; -- notifications that users have died
    commandq: putStringQ; -- commands from user
    useraccessq: useraccessIn; -- user access right callmessages
    
    -- callmessages
    obituarycm: master_monitor; -- a user has died
    commandcm: putStringIntf; -- a command was received from the user
    useraccesscm: useraccess; -- access rights for a new user
    
    -- temporaries
    std: stdenv; -- environment expected by appt_scheduler
    CLoader: CLoad!CLoadFn; -- C Loader
    argv: charstringList; -- command
    argvindex : integer; -- position in argv
    scheduler_name: charstring; -- name of appointment scheduler to use
    commandq_cap: putstringFunc; -- connection to commandq
    obituary_cap: master_monitorOut; -- connection to obituary
    rm_init: rmDemoInitFn; -- initialization port for RM
    safewindow_init: safewindowinitFn; -- initialization port for windows
    appt_scheduler_init: appt_scheduler_init_out; -- initialization port for AS
  begin
    -- Command: master [-nowindow] [scheduler-name]
    -- If -nowindow is specified,
    --   then the openwindow and opentracewindow reources will be
    --   assumed to be available from the resource manager
    --   Otherwise "safewindows" and "tracewindows" will be installed.
    -- Algorithm:
    -- 1. Reconstruct CLoader and stdenv
    -- 2. If -nowindows not specified, build and post windows and tracewindows
    -- 3. Open a trace window, and a tracing front-end to rm
    -- 3a. If scheduler specified, start it
    -- 4. Open a small window. Future I/o to this window
    -- 5. Loop
    --    5.1. prompt for command, and tokenize it
    --    'create' username optional-shell-name
    --       5.1.1. If no shell name, use 'wshell2'
    --       5.1.2. load the shell
    --       5.1.3. create a small window for the shell to run in; 
    --       5.1.4. create a filter and a usermonitor
    --       5.1.5. get useraccess call message 
    --       5.1.6. start the shell, passing him RM, terminal, useraccess
    --       5.1.7. save in table: userid, window, quit port
    --    'kill'
    --       5.1.1. remove table entry
    --       5.1.2. tell the filter he's dying because user was killed
    --       5.1.3. discard the window
    --    'quit'
    --       5.1.1. kill everybody
    --       5.1.1. break out of loop
    --    'user died'
    --       5.1.1. kill him, but tell the filter he's terminating because he quit
    receive parms from init;

    new obituary; connect obituary_cap to obituary;
    new commandq; connect commandq_cap to commandq;
    new useraccessq;
    -- 1., 2.
    new std;
    unwrap std.load from parms.rm.get("master", "load", "master") {init};
    unwrap std.pathLoad from parms.rm.get("master", "pathLoad", "master") {init};
    unwrap std.readObj from parms.rm.get("master", "readObj", "master") {init};
    unwrap std.pathReadObj from parms.rm.get("master", "pathReadObj", "master") {init};
    unwrap std.writeObj from parms.rm.get("master", "writeObj", "master") {init};
    unwrap std.libWriteObj from parms.rm.get("master", "libWriteObj", "master") {init};
    unwrap std.store from parms.rm.get("master", "store", "master") {init};
    unwrap std.libStore from parms.rm.get("master", "libStore", "master") {init};
    unwrap std.getCwd from parms.rm.get("master", "getCwd", "master") {init};
    unwrap std.setCwd from parms.rm.get("master", "setCwd", "master") {init};
    unwrap std.terminal from parms.rm.get("master", "terminal", "master") {init, init(putString), init(putLine), init(getString), init(putChar), init(getChar)};
    unwrap CLoader from parms.rm.get("master", "CLoader", "master") {init};
    unwrap argv from parms.rm.get("master", "argv", "master") {init};
    getprogram := Std.Pathload;
    smallwindowoptions := "-Wh 5 -Ww 40";
    solicitor <- procedure of process solicitor;
    usermonitor <- procedure of process usermonitor;
    ufilter <- procedure of process ufilter;
    initTokenize <- create of GetProgram("tokenize");
    block declare
      wordChars: charString;
      whiteChars: charString;
    begin
      wordChars <- "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
      wordChars <- wordChars | "1234567890!@#$%^&*_+|~-=\`;:,./?";
      whiteChars <- " ";
      insert 'HT' into whiteChars;
      tokenize <- initTokenize(wordChars, whiteChars, "'""", "(){}[]<>");
    end block;
    tokenStrings <- procedure of GetProgram("tokenstrings");
    ac_trivial <- procedure of process ac_trivial;
    wrap copy of GetProgram as resource;
    call parms.rm.post("master", "GetProgram", resource, ac_trivial);
    -- 2.
    argvindex <- 2;
    if evaluate Window: boolean from
      window <- size of argv <= argvindex;
      If window
        then
        else
          window <- argv[argvindex] <> "-nowindow";
        end if;
      end
      then
        safewindow_init <- create of GetProgram("safewindow");
        openwindow <- safewindow_init(CLoader);
        wrap copy of openwindow as resource;
        call parms.rm.post("master", "OpenWindow", resource, ac_trivial);
        opentracewindowinit <- create of Getprogram("opentracewindow");
        opentracewindow <- opentracewindowinit(openwindow);
        ac_tracewin <- procedure of GetProgram("ac_tracewin");
        wrap copy of opentracewindow as resource;
        call parms.rm.post("master", "OpenTraceWindow", resource, ac_tracewin);
      else
	argvindex <- argvindex + 1;
	unwrap openwindow from parms.rm.get("master", "OpenWindow", "master") {init};
	unwrap opentracewindow from parms.rm.get("master", "OpenTraceWindow", "master") {init};
      end if;     
    -- 3.
    tracewindow <- opentracewindow("trace master", smallwindowoptions|" -inverse");
    rm_init <- create of GetProgram("rmdemod");
    call rm_init(opentracewindow, parms.rm, rm_ports);                       
    -- 3a.
    if size of argv > argvindex
      then
        appt_scheduler_init <- create of GetProgram(argv[argvindex]);
        call appt_scheduler_init(std, rm_ports, shutdown, reset, register);
        wrap copy of register as resource;
        call parms.rm.post("master", "RegisterCalendar", resource, ac_trivial);
      end if;
    -- 4.
    masterwindow <- openwindow("master", smallwindowoptions);
    call std.terminal.putLine("Done");
    call solicitor(masterwindow.terminal, ">", commandq_cap);
    -- 5.
    call tracewindow.terminal.PutLine("Initialized");
    new users;
    continue <- 'true';
    while (continue)
      repeat
        select
          event commandq
            receive commandcm from commandq;
            call tracewindow.terminal.PutLine("Received command line");
	    argv <- tokenStrings(tokenize(commandcm.string));
            if size of argv > 0
              then
		select (argv[0])
		  where ("create")
		    block
		      declare
			username: charstring;
			shellname: charstring;
			shellinit: umainOut; -- port to start shell
			shellwindow: terminalFunctions; -- window for shell to run in
			entry: user_info; -- entry in table of users
			filteredterminal: terminalFunctions; -- filtered functions
			filteredresource: rManager; -- user's RM
		      begin
			-- 5.1.1.
			username <- "";
			username <- argv[1];
			if exists of users[username]
			  then
			    call masterwindow.terminal.putLine("User already exists:"|username);
			  else
			    if size of argv > 2 
			      then
				shellname <- argv[2];
			      else
				shellname <- "wshell2";
			      end if;
			    -- 5.1.2.
			    call tracewindow.terminal.PutLine("Creating shell process "|shellname);
			    shellinit <- create of GetProgram(shellname);
			    -- 5.1.3.
			    new entry;
			    entry.name := username;
			    call tracewindow.terminal.PutLine("Creating window for user "|username);
			    entry.window <- openwindow(username, smallwindowoptions);
			    shellwindow := entry.window.terminal;
			    -- 5.1.4.
			    call tracewindow.terminal.PutLine("Creating filter for user "|username);
			    call ufilter(username, shellwindow, filteredterminal, rm_ports, filteredresource, entry.quit);
			    call tracewindow.terminal.PutLine("Created filter");
			    call tracewindow.terminal.PutLine("Creating monitor for user "|username);
			    call usermonitor(username, filteredterminal, filteredresource, useraccessq, obituary_cap);
			    call tracewindow.terminal.PutLine("Created monitor");
			    -- 5.1.5.
			    receive useraccesscm from useraccessq;
			    -- 5.1.6.
			    call tracewindow.terminal.PutLine("Initializing shell");
			    call shellinit(argv, useraccesscm);
			    call tracewindow.terminal.PutLine("Shell initialized");
			    -- 5.1.7.
			    insert entry into users;
			    call masterwindow.terminal.PutLine("OK");
			  end if;
		      on (NotFound)
			call masterwindow.terminal.putLine("No such user:"|username);
		      on (DuplicateKey)
			call masterwindow.terminal.putLine("User already exists:"|username);
		      on (load_intf.file_not_found)
			call masterwindow.terminal.putLine("Not found:"|shellname);
		      on (InterfaceMismatch)
			call masterwindow.terminal.putLine("Not compatible:"|shellname);
		      on (others)
			call masterwindow.terminal.putLine("Couldn't execute");
		      end block;
		    return commandCM;
		  where("kill")
		    block
		      declare
			entry: user_info;
		      begin
			remove entry from users[argv[1]];
			call tracewindow.terminal.putLine("Calling quit service in filter for user "|entry.name);
			call entry.quit("master console killed the user");
			call tracewindow.terminal.PutLine("Filter.Quit completed");
			discard entry;
			call masterwindow.terminal.PutLine("OK");
		      on (NotFound)
			call masterwindow.terminal.PutLine("No such user");
		      on (others)
			call masterwindow.terminal.PutLine("Unknown error");
		      end block;
		    return commandCM;
		  where("quit")
		    pragma "trace=0" while (size of users > 0)
		      repeat
			block
			  declare
			    entry: user_info;
			  begin
			    remove entry from users[];
			    call tracewindow.terminal.putLine("Calling quit service in filter for user "|entry.name);
			    call entry.quit("master console shutting down");
			    call tracewindow.terminal.PutLine("Filter.Quit completed");
			    discard entry;
			  on (others)
			    call masterwindow.terminal.PutLine("Unknown error");
			  end block;
		      end while;
		    continue <- 'false';
		    discard commandCM;
		  otherwise
		    call masterwindow.terminal.PutLine("Unrecognized command:"|argv[0]);
		    return commandcm;
		  end select;
              else
                return commandcm;
              end if;
            call tracewindow.terminal.putLine("Returned command");
	  event obituary
	    receive obituaryCM from obituary;
	    call tracewindow.terminal.putLine("Received obituary from monitor for user "|obituaryCM.username);
	    block
	      declare
	        entry: user_info;
	        why: charstring;
	      begin
	        remove entry from users[obituaryCM.username];
		if obituaryCM.normal
		  then
		    why <- "normally";
		  else
		    why <- "abnormally";
		  end if;
	        call entry.quit("user terminated "|why);
	        call masterwindow.terminal.PutLine("User "|obituaryCM.username|" died "|why);
	        call tracewindow.terminal.PutLine("User "|obituaryCM.username|" died "|why);

	      on (others)
	        call masterwindow.terminal.PutLine("Problems with death of "|obituaryCM.username);
	      end block;
	    call tracewindow.terminal.putLine("Returned obituary");
	    return obituaryCM;
	  otherwise
	  end select;
      end while;
    call tracewindow.terminal.putLine("Master terminating");
    return parms;
  on (InterfaceMismatch)
    call Std.terminal.PutLine("Aborting because of interface mismatch");
  on (load_intf.file_not_found)
    call Std.terminal.PutLine("Aborting because cannot load programs");
  
  end process
    
    
