-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
master: using(main, sysRManager, rManager, rmDemo, safewindow, safewindowinit, application_init, appt_scheduler_init, load, terminalio, appt_scheduler_operator, appt_scheduler_registrant, master_internal, common) linking(ac_trivial)
  process (init: main_q)
  declare
    parms: main_intf; -- initialization parameters
    ac_trivial: AccessFn; -- trivial access control (gives to everybody)
    rm_ports: sysRManager; -- ports to the resource manager
    openwindow: safewindowFn; -- port to open a window
    shutdown: Shutdown_Appt_Scheduler_out; -- operator shutdown port
    reset: Reset_Appt_Scheduler_out; -- operator reset port
    register: add_member_out; -- port to register with scheduler
    resource: polymorph; -- polymorph resource being posted
    masterwindow: terminalCM; -- window to use for future commands
    getprogram: load_func; -- program to load other programs
    smallwindowoptions: charstring; -- options for small window
    userwindows: named_windows; -- windows opened by users
    rm_init: rmDemoInitFn; -- initialization port for RM
    safewindow_init: safewindowinitFn; -- initialization port for windows
    appt_scheduler_init: appt_scheduler_init_out; -- initialization port for AS
    continue: boolean; -- true to continue looping
  begin
    -- Algorithm:
    -- 1. Create and start RM, Safewindows, Appt_scheduler
    -- 2. Post Pathload, Openwindow, Register services to RM
    -- 3. Open a small window. Future I/o to this window
    -- 4. Loop
    --    4.1. prompt for command
    --    'create'
    --       4.1.1. prompt for a username, and shell name
    --       4.1.2. load the shell
    --       4.1.3. create a small window for the shell to run in; save in table
    --       4.1.4. start the shell, passing him RM, window, username
    --    'kill'
    --       4.1.1. remove table entry -- this will destroy the window
    --    'quit'
    --       4.1.1. break out of loop
    receive parms from init;
    getprogram := Parms.Std.Pathload;
    smallwindowoptions := "-Wh 5 -Ww 40";
    -- 1.
    rm_init <- create of GetProgram("rmdemo");
    safewindow_init <- create of GetProgram("safewindow");
    call safewindow_init(parms.CLoader, openwindow);
    call rm_init(openwindow,rm_ports);
    Call Parms.Std.Terminal.Putstring("Name of Appointment Scheduler:");
    appt_scheduler_init <- create of GetProgram(Parms.Std.Terminal.Getstring());
    call appt_scheduler_init(Parms.Std, rm_ports, shutdown, reset, register);
    -- 2.
    ac_trivial <- procedure of process ac_trivial;
    wrap copy of GetProgram as resource;
    call rm_ports.post("master", "GetProgram", resource, ac_trivial);
    wrap copy of openwindow as resource;
    call rm_ports.post("master", "OpenWindow", resource, ac_trivial);
    wrap copy of register as resource;
    call rm_ports.post("master", "RegisterCalendar", resource, ac_trivial);
    -- 3.
    masterwindow <- openwindow("master", smallwindowoptions);
    call parms.std.terminal.putLine("Done");
    -- 4.
    new userwindows;
    continue <- 'true';
    while (continue)
      repeat
        block
          declare
            command: charstring;
            username: charstring;
            shellname: charstring;
            shellinit: application_init_Out; -- port to start shell
            shellwindow: terminalFunctions; -- window for shell to run in
            entry: named_window; -- entry in table of users
          begin
            call masterwindow.terminal.Putstring("Command:");
            call masterwindow.terminal.Getstring(command);
            select (command)
              where ("create")
		-- 4.1.1.
		call masterwindow.terminal.Putstring("User Name:");
		call masterwindow.terminal.Getstring(username);
		call masterwindow.terminal.Putstring("Shell Name:");
		call masterwindow.terminal.Getstring(shellname);
		-- 4.1.2.
		shellinit <- create of GetProgram(shellname);
		-- 4.1.3.
		new entry;
		entry.name := username;
		entry.window <- openwindow(username, smallwindowoptions);
		shellwindow := entry.window.terminal;
		insert entry into userwindows;
		-- 4.1.4.
		call shellinit(username, "", shellwindow, rm_ports);
		call masterwindow.terminal.PutLine("OK");
	      where("kill")
		call masterwindow.terminal.Putstring("User Name:");
		call masterwindow.terminal.Getstring(username);
		remove entry from userwindows[username];
		discard entry;
		call masterwindow.terminal.PutLine("OK");
              where("quit")
                continue <- 'false';
	      otherwise
	        call masterwindow.terminal.Putstring("Illegal Command:"|command);
	      end select;
	  on (NotFound)
	    call masterwindow.terminal.putLine("No such user:"|username);
	  on (DuplicateKey)
	    call masterwindow.terminal.putLine("User already exists:"|username);
          on (load_intf.file_not_found)
            call masterwindow.terminal.putLine("Not found:"|shellname);
          on (InterfaceMismatch)
            call masterwindow.terminal.putLine("Not compatible:"|shellname);
          on (others)
            call masterwindow.terminal.putLine("Couldn't execute");
          end block;
      end while;
    return parms;
  end process
    
    
