-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
calendartool: using(usub, terminalio, safewindow, load, rManager, member2_init, member2_fe_init, appt_scheduler_registrant, member_window, events, times) process (init: usubIn)
  declare
    parms: usub; -- initialization parameters
    getprogram: load_func; -- program loader
    openwindow: safewindowFn; -- port to open a window
    register: add_member_out; -- port to connect to appt scheduler
    username: charstring; -- my user name
    membername: charstring; -- name of member process
    rm: rManager; -- ports to resource manager
    calendarwindow: terminalCM; -- window opened by calendar
    terminalq: putstringQ; -- front end message queue
    notify: notify_appt_in; -- front end notify service
    memberinit: member_init_out; -- to initialize member
    notify_cap: notify_appt_out; -- capability to call notify
    plan: plan_appt_out; -- capability to plan service
    schedule: schedule_appt_out; -- capability to schedule service
    cancel: cancel_appt_out; -- capability to schedule service
    list_appts: list_appts_out; -- capability to list appts service
    list_members: list_members_out; -- capability to list members service
    continue: boolean; -- process is active
  begin
    -- Algorithm:
    -- 0. Save username, parameters ( = name of member process), rm
    -- 1. Get services: GetProgram, OpenWindow, and RegisterCalendar
    -- 2. Create a new window to run the front end
    -- 3. Create the input ports of the front end
    -- 4. Create the "member" process.
    -- 5. Start the member process, passing it connections to front-end,
    --    and receiving back connections to member's service ports
    -- 6. Return initialization message to caller
    -- 7. Loop
    --    7.1. Prompt for the name of a front-end process, or 'quit'
    --    7.2. Load the front-end process
    --    7.3. run the front-end process, passing it its own service port,
    --         and capabilities to window, rm, and member.  It will
    --         terminate and return service port when it wants to
    --         replace itself with a new front end.
    receive parms from init;
    -- 0.
    BLOCK
      declare
        frontendname: charstring; -- name of front-end process;
        emptytimes: time_set; -- temporary substitute for "depart" call
        emptyparticipants: member_ids;
        bogusids: member_ids;
        bogustimes: time_set;
      BEGIN
        new emptytimes;
        new emptyparticipants;
        username := parms.io.username;
        if size of parms.argv > 2
          then
            membername := parms.argv[2];
          else
            membername := "member2";
          end if;
        rm := parms.io.resource;
        -- 1.
        unwrap getprogram from rm.get("GetProgram", "") {init};
        unwrap openwindow from rm.get("OpenWindow", "") {init};
        unwrap register from rm.get("RegisterCalendar", "") {init};
        -- 2.
        calendarwindow <- openwindow(username, "-Wh 20 -Ww 40");
        -- 3.
        new terminalq;
        new notify;
        connect notify_cap to notify;
        -- 4.
        memberinit <- create of GetProgram(membername);
        -- 5.
        call memberinit(username, calendarwindow.terminal, rm, register, notify_cap, plan, schedule, cancel, list_appts, list_members);
        -- 6. 
        return parms;
        -- 7.
        continue <- 'true';
        frontendname <- "fe2";
        while  (continue)
          repeat
            block
              declare
                frontend_init: member_fe_init_out; -- initialize port;
              begin
                -- 7.1.
		-- 7.2.
		frontend_init <- create of GetProgram(frontendname);
		-- 7.3.
		call frontend_init(username, calendarwindow.terminal, rm, plan, schedule, cancel, list_appts, list_members, notify, terminalq);
              on (load_intf.file_not_found)
                call calendarwindow.terminal.PutLine("Not found:"|frontendname);
              on (InterfaceMismatch)
                call calendarwindow.terminal.PutLine("Not compatible:"|frontendname);
              on (others)
                call calendarwindow.terminal.PutLine("Could not create:");
              end block;
            call calendarwindow.terminal.putstring("Name of front-end, or quit:");
            call calendarwindow.terminal.getstring(frontendname);
            continue <- frontendname <> "quit";
          end while;
        call calendarwindow.terminal.PutLine("Shutting down.");
        -- until the interface is changed, we'll send a shutdown less than elegantly
        call plan(emptytimes, emptyparticipants, bogusids, bogustimes);
        
      on (load_intf.file_not_found)
	call parms.io.terminal.PutLine("Not found:"|membername);
	return parms;
      on (InterfaceMismatch)
	call parms.io.terminal.PutLine("Not compatible:"|membername);
	return parms;
      END BLOCK;
    
  end process
