#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include "gdbm.h"


#define TRUE 1
#define FALSE 0

GDBM_FILE gdbm_file;

  datum key_data;
  datum data_data;
  datum return_data;

  char key_line[500];
  char data_line[1000];

  char make_lexicon = FALSE;
  char reorganize_lexicon = FALSE;

  char *file_name;

int main (argc, argv)
     int argc;
     char *argv[];

{

  /* Argument checking. */
  if (argc > 3)
    {
      fprintf (stderr,"Usage: %s [-make|reorganize] [lexicon-file] \n",argv[0]);
      exit (2);
    }
  if (argc > 2)
      file_name = argv[2];
  else file_name = "lexicon.gdbm";
  if (argc >1) {
 
    if (strcmp(argv[1],"-make") == 0) 
        make_lexicon = TRUE;
    else if (strcmp(argv[1],"-reorganize") == 0) 
        reorganize_lexicon = TRUE;
    else file_name = argv[1];
  }
  /* Initialize variables. */
  key_data.dptr = NULL;
  data_data.dptr = data_line;

  if (make_lexicon || reorganize_lexicon) 
   gdbm_file = gdbm_open (file_name, 512, GDBM_WRCREAT, 00664, NULL);
  else 
   gdbm_file = gdbm_open (file_name, 512, GDBM_READER, 00664, NULL);
      
  if (gdbm_file == NULL)
    {
	fprintf (stderr,"gdbm_open(%s) failed.\n", file_name);
        exit (2);
    }
  
  strcpy (file_name, data_line);
  if (make_lexicon)
     while ( gets (key_line))
         store();
  else  if (reorganize_lexicon)
	  {
	    if (gdbm_reorganize (gdbm_file))
	      fprintf (stderr, "Reorganization failed. \n\n");
	    else
	      fprintf (stderr, "Reorganization succeeded. \n\n");
	  }
  else 
    while (gets (key_line))
     fetch();
  return 0;
}

void store()
{
	  if (key_data.dptr != NULL) free (key_data.dptr);
	  key_data.dptr = key_line;
	  key_data.dsize = strlen (key_line)+1;
	  data_data.dsize = strlen (data_line)+1;
	  if (gdbm_store (gdbm_file, key_data, data_data, GDBM_REPLACE) != 0)
	    printf ("Item not inserted. \n");
	  key_data.dptr = NULL;
}

void fetch()
{
	  if (key_data.dptr != NULL) free (key_data.dptr);
	  key_data.dptr = key_line;
	  key_data.dsize = strlen (key_line)+1;
	  return_data = gdbm_fetch (gdbm_file, key_data);
	  if (return_data.dptr != NULL)
	    {
	      printf ("1\n", return_data.dptr);
	      free (return_data.dptr);
	    }
	  else
	    printf ("0\n");
          fflush(stdout);
	  key_data.dptr = NULL;
}
