#-m
%^TEX
\documentstyle[glammar]{article}
\topmargin      0 mm
\headheight     0 mm
\headsep        0 mm
\textheight     240 mm
\footskip       7 mm
\footheight     11 mm

\oddsidemargin  0 mm
\evensidemargin 0 mm
\textwidth      159.2 mm
\author{Eric Voss}
\title{Demonstration grammar}
\makeindex
\begin{document}
\maketitle
%

%
The original list of used terms:
 
ADJE  adjective
ADVB  adverb
AUXV  auxiliary verb
AVPH  active verb phrase
FPES  first person singular
FPPS  first person personal singular
HAVE  to have
IINT  intransitive, no "to form" verb (inf. form)
IMEI  intransitive, "to form" verb (inf. form)
IMET  transitive, "to form" verb (inf. form)
IMPR  impersonal
INFI  infinitive
INTV  intransitive, no "to form" verb
MEIV  intransitive, "to form" verb
METV  transitive, "to form" verb
MVPH  "to form"
NDVG  nominal part of verb
NONM  no object, no "to form"
NOUN  noun; adjectives still can be generated
NOWM  no object, "to form"
NPOV  nominal part of verb, no adjective
NPPL  noun, plural
NPSI  noun, singular
OBJE  object
OPER  second person sing. or any person plur.
OPPX  second person sing. or first/second person plur., personal
PABE  to be, past tense
PAHV  to have, past tense
PAPL  past participle
PAST  past tense
PERS  personal
PHRS  sentence, affixes already generated
PLIM  SUPL + IMPR
PLPR  SUPL + PERS
PLUR  plural
PRBE  to be, present tense
PRHV  to have, present tense
PRPL  present participle
PRST  present tense
PVPH  passive verb phrase
QINT  TINT + TPES
QMEI  TMEI + TPES
QMET  TMET + TPES
QTRA  TTRA + TPES
REBY  relative sentence
RELO  relative pronoun, object
RELS  relative pronoun, subject
SENT  sentence
SIIM  SUSI + IMPR
SING  singular 
SIPR  SUSI + PLUR
SUBJ  subject
SUBS  noun; adjectives already generated
SUPH  subject phrase
SUPL  SUBS + PLUR
SUSI  SUBS + SING
TAUX  AUXV + PRST
TENS  tense (past or present)
TINT  INTV + PRST
TMEI  MEIV + PRST
TMET  METV + PRST
TNOP  phrase, with transitive verb, but no object
TOBE  to be
TOPH  object phrase
TPES  third person singular
TPIP  third person impersonal plural
TPIS  third person impersonal singular
TPPS  third person personal singular
TRAV  transitive, no "to form" verb
TTRA  TRAV + PRST
VAUX  AUXV + PAST
VBPH  verb phrase
VERB  verb; an adverb can still be generated
VINT  INTV + PAST
VMEI  MEIV + PAST
VMET  METV + PAST
VTRA  TRAV + PAST
VWAV  verb; adverbs already generated
WONM  object, no "to form"
WOWM  object, "to form"
XINT  INTV + PRPL
XMEI  MEIV + PRPL
XMET  METV + PRPL
XTRA  TRAV + PRPL
YINT  INTV + PAPL
YMEI  MEIV + PAPL
YMET  METV + PAPL
YTRA  TRAV + PAPL

=======================================================================

Added features:

n      number (affix; singular or plural) 
p      person (affix; 1, 2 or 3) 
g      gender (affix; personal or impersonal) 
nobnof [NO] oBject [NO] "to Form" (affix; nonm of nowm of wonm of wowm) 

COOR   COOR dinate
RMKS   ReMarKS
ARTS   ARTicle Singular
DETS   DETerminer Singular  
POSP   POSsessive Pronoun
ARTP   ARTicle Plural
DETP   DETerminer Plural
TO     "to"
OBPH   object phrase (not in original list)
OBJJ
FIVE   FInal VErb
STAX   Singular TAuX 
PTAX   Plural or 2nd singular TAuX
SVAX   Singular VAuX 
PVAX   Plural or 2nd singular VAuX

ITRA    
OBPH   object phrase

=======================================================================

Terms for verbs grouped together:

INTV = intransitive, no 'to form' verb
TRAV = transitive, no 'to form' verb
MEIV = intransitive, 'to form' verb
METV = transitive, 'to form' verb

INTV + PRST = TINT = IINT = sleep/sneeze      [you sleep]
		             QINT = sleeps/sneezes    [he sleeps]
     + PAST = VINT =        slept             [she slept]
     + INFI = IINT =                          [they have to sleep]
     + PRPL = XINT =        sleeping/sneezing [I am sleeping]
     + PAPL = YINT =        slept/sneezed     [I have slept]

TRAV + PRST = TTRA = ITRA = wash/want/see     [you see (him)]
                     QTRA = washes/wants      [he wants (her)]
     + PAST = VTRA =        washed/wanted     [she wanted (him)]
     + INFI = ITRA =        wash/want         [they (ought to) wash (you)]
     + PRPL = XTRA =        washing/seeing    [I am seeing (you)]
     + PAPL = YTRA =        washed/seen       [you have seen (me)]

MEIV + PRST = TMEI = IMEI = go/walk/come      [you walk]
		             QMEI = goes/walks/comes  [he walks]
     + PAST = VMEI =        went/walked       [she went]
     + INFI = IMEI =        go/walk/come      [they have to come]
     + PRPL = XMEI =        going/walking     [you are walking]
     + PAPL = YMEI =        gone/walked       [they are gone]

METV + PRST = TMET = IMET   give/take/ask     [I give (you)]
		             QMET   gives/takes/asks  [he asks (me)]
     + PAST = VMET =        gave/took         [they gave (her)]
     + INFI = IMET =        give/take/ask     [they (must) give]
     + PRPL = XMET =        giving/taking     [I am giving (him)]
     + PAPL = YMET =        given/taken       [they have given (me)]
%



START (t>):
    setup connection to unix (>"lexicon ADIE.gdbm",>LEX ADIE),
    setup connection to unix (>"lexicon SIIM.gdbm",>LEX SIIM),
    setup connection to unix (>"lexicon SIPR.gdbm",>LEX SIPR),
    sentences (t>).

LEX ADIE::.
LEX SIPR::.
LEX SIIM::.

sentences (t+tt>):
    SENT (t>), more sentences(tt>).

more sentences (t>): nlcr, sentences(t>);
more sentences (empty>):.

SENT("SENT("+phrs+")"+n+p+g+nlcr>):
    PHRS(phrs>,n,p,g);
SENT("SENT("+phrs+","+coor+","+sent+")"+n+p+g+nlcr>):
    PHRS(phrs>,n,p,g),
    COOR(coor>),
    SENT(sent>);
SENT("SENT("+rmks+sent+")">):
    RMKS(rmks>),
    SENT(sent>).

PHRS("PHRS("+SUPH+")">,n,p,g):		SUPH(SUPH>,n,p,g);
PHRS("PHRS("+SUPH+","+VBPH+")">,n,p,g):    
    SUPH(SUPH>,n,p,g),
    VBPH(VBPH>,tens,n,p,g).

SUPH("SUPH("+SUBJ+")">,n,p,g):		SUBJ(SUBJ>,n,p,g);
SUPH("SUPH("+SUBJ+","+REBY+")">,n,p,g):    
    SUBJ(SUBJ>,n,p,g),
    REBY(REBY>,n,p,g).

SUBJ("SUBJ(I)">,SING,ONE,PERS):			"I", l;
SUBJ("SUBJ(you)">,SING,TWO,PERS):		"you",l;
SUBJ("SUBJ(he)">,SING,THREE,PERS):		"he",l;
SUBJ("SUBJ(she)">,SING,THREE,PERS):		"she", l;
SUBJ("SUBJ(it)">,SING,THREE,IMPR):		"it", l;
SUBJ("SUBJ("+NPSI+")">,SING,THREE,g):		NPSI(NPSI>,SING,g);
SUBJ("SUBJ(we)">,PLU,ONE,PERS): 		"we", l;
SUBJ("SUBJ(you)">,PLU,TWO,PERS):		"you", l;
SUBJ("SUBJ(they)">,PLU,THREE,g):		"they", l;
SUBJ("SUBJ("+NPPL+")">,PLU,THREE,g):		NPPL(NPPL>,PLU,g).

NPSI("NPSI("+ARTS+","+NOUN+")">,SING,g):    
    ARTS(ARTS>),
    NOUN(NOUN>,SING,g);
NPSI("NPSI("+DETS+","+NOUN+")">,SING,g):    
    DETS(DETS>),
    NOUN(NOUN>,SING,g);
NPSI("NPSI("+POSP+","+NOUN+")">,SING,g):    
    POSP(POSP>),
    NOUN(NOUN>,n,g).

NPPL("NPPL("+ARTP+","+NOUN+")">,PLU,g):    
    ARTP(ARTP>),
    NOUN(NOUN>,PLU,g);
NPPL("NPPL("+DETP+","+NOUN+")">,PLU,g):    
    DETP(DETP>),
    NOUN(NOUN>,PLU,g);
NPPL("NPPL("+NOUN+")">,PLU,g):		
    NOUN(NOUN>,PLU,g).

NOUN("NOUN("+ADIE+","+NOUN+")">,n,g):    
    ADIE(ADIE>),
    NOUN(NOUN>,n,g);
NOUN("NOUN("+SUBS+")">,n,g):		SUBS(SUBS>,n,g).

SUBS("SUBS("+SUSI+")">,SING,g):		SUSI(SUSI>,g);
SUBS("SUBS("+SUPL+")">,PLU,g):		SUPL(SUPL>,g).

SUSI("SUSI("+SPR+")">,PERS):		SIPR(SPR>);
SUSI("SUSI("+SM+")">,IMPR):		SIIM(SM>).

SUPL("SUPL("+PLPR+")">,PERS):		PLPR(PLPR>);
SUPL("SUPL("+PLIM+")">,IMPR):		PLIM(PLIM>).

REBY("REBY("+RELS+","+VBPH+")">,n,p,g):    
    RELS(RELS>,n,p,g),
    VBPH(VBPH>,tens,n,p,g);
REBY("REBY("+RELO+","+TNOP+")">,n,p,g):    
    RELO(RELO>,n,p,g),
    TNOP(TNOP>).

RELS("RELS(who)">,SING,ONE,PERS):		"who", l;
RELS("RELS(who)">,SING,TWO,PERS):		"who", l;
RELS("RELS(who)">,SING,THREE,PERS):		"who", l;
RELS("RELS(that)">,SING,THREE,IMPR):		"that", l;
RELS("RELS(which)">,SING,THREE,IMPR):		"which", l;
RELS("RELS(who)">,PLU,ONE,PERS):		"who", l;
RELS("RELS(who)">,PLU,TWO,PERS):		"who", l;
RELS("RELS(who)">,PLU,THREE,PERS):		"who", l;
RELS("RELS(that)">,PLU,THREE,IMPR):		"that", l;
RELS("RELS(which)">,PLU,THREE,IMPR):		"which", l.

RELO("RELO(whom)">,SING,ONE,PERS):		"whom", l;
RELO("RELO(whom)">,SING,TWO,PERS):		"whom", l;
RELO("RELO(whom)">,SING,THREE,PERS):		"whom", l;
RELO("RELO(that)">,SING,THREE,IMPR):		"that", l;
RELO("RELO(which)">,SING,THREE,IMPR):		"which", l;
RELO("RELO(whom)">,PLU,ONE,PERS):		"whom", l;
RELO("RELO(whom)">,PLU,TWO,PERS):		"whom", l;
RELO("RELO(whom)">,PLU,THREE,PERS):		"whom", l;
RELO("RELO(that)">,PLU,THREE,IMPR):		"that", l;
RELO("RELO(which)">,PLU,THREE,IMPR):		"which", l.

TNOP("TNOP("+SUPH+","+VERB+")">):    
    SUPH(SUPH>,n,p,g),
    VERB(VERB>,wonm,tens,n,p,g);
TNOP("TNOP("+SUPH+","+VERB+","+MVPH+")">):    
    SUPH(SUPH>,n,p,g),
    VERB(VERB>,wonm,tens,n,p,g),
    MVPH(MVPH>).

MVPH("MVPH("+TO+","+TOPH+")">):    
    TO(TO>),
    TOPH(TOPH>).

TOPH("TOPH("+OBPH+")">):		OBPH(OBPH>).

OBPH("OBPH("+OBJE+")">):		OBJE(OBJE>,n,p,g);
OBPH("OBPH("+OBJE+","+REBY+")">):    
    OBJE(OBJE>,n,p,g),
    REBY(REBY>,n,p,g);
OBPH("OBPH("+OBJE+","+OBJJ+")">):    
    OBJE(OBJE>,n,p,g),
    OBJJ(OBJJ>).

OBJJ("OBJJ("+NPSI+")">):		NPSI(NPSI>,SING,g);
OBJJ("OBJJ("+NPPL+")">):		NPPL(NPPL>,PLU,g).

OBJE("OBJE(me)">,SING,ONE,PERS):		"me", l;
OBJE("OBJE(you)">,SING,TWO,PERS):		"you", l;
OBJE("OBJE(him)">,SING,THREE,PERS):		"him", l;
OBJE("OBJE(her)">,SING,THREE,PERS):		"her", l;
OBJE("OBJE(it)">,SING,THREE,IMPR):		"it", l;
OBJE("OBJE("+NPSI+")">,SING,THREE,g):		NPSI(NPSI>,SING,g);
OBJE("OBJE(us)">,PLU,ONE,PERS): 		"us", l;
OBJE("OBJE(you)">,PLU,TWO,PERS):		"you", l;
OBJE("OBJE(them)">,PLU,THREE,g):		"them", l;
OBJE("OBJE("+NPPL+")">,PLU,THREE,g):		NPPL(NPPL>,PLU,g).

NDVG("NDVG("+ADIE+")">,n,p,g):		ADIE(ADIE>);
NDVG("NDVG("+NPOV+")">,n,p,g):		NPOV(NPOV>,n,p,g).

NPOV("NPOV("+SUPH+")">,SING,ONE,PERS):		SUPH(SUPH>,SING,ONE,PERS);
NPOV("NPOV("+SUPH+")">,SING,ONE,PERS):		SUPH(SUPH>,SING,THREE,g);
NPOV("NPOV("+SUPH+")">,SING,THREE,g):		SUPH(SUPH>,SING,THREE,g);
NPOV("NPOV("+SUPH+")">,SING,TWO,PERS):		SUPH(SUPH>,SING,TWO,PERS);
NPOV("NPOV("+SUPH+")">,SING,TWO,PERS):		SUPH(SUPH>,SING,THREE,IMPR);
NPOV("NPOV("+SUPH+")">,SING,TWO,PERS):		SUPH(SUPH>,PLU,p,g);
NPOV("NPOV("+SUPH+")">,PLU,p,g):		SUPH(SUPH>,SING,THREE,IMPR);
NPOV("NPOV("+SUPH+")">,PLU,p,g):		SUPH(SUPH>,PLU,p,g).

VBPH("VBPH("+AVPH+")">,tens,n,p,g):		AVPH(AVPH>,tens,n,p,g);
VBPH("VBPH("+PVPH+")">,tens,n,p,g):		PVPH(PVPH>,tens,n,p,g).

AVPH("AVPH("+VERB+")">,tens,n,p,g):		VERB(VERB>,nobnof,tens,n,p,g);
AVPH("AVPH("+VERB+","+TOPH+")">,tens,n,p,g):    
    VERB(VERB>,nobnof,tens,n,p,g),
    TOPH(TOPH>);
AVPH("AVPH("+VERB+","+MVPH+")">,tens,n,p,g):    
    VERB(VERB>,nobnof,tens,n,p,g),
    MVPH(MVPH>);
AVPH("AVPH("+VERB+","+TOPH+","+MVPH+")">,tens,n,p,g):    
    VERB(VERB>,nobnof,tens,n,p,g),
    TOPH(TOPH>),
    MVPH(MVPH>);
AVPH("AVPH("+VERB+","+TOBE+","+NDVG+")">,tens,n,p,g):    
    VERB(VERB>,nobnof,tens,n,p,g),
    TOBE(TOBE>,tens,n,p,g),
    NDVG(NDVG>,n,p,g).

VERB("VERB("+VWAV+")">,nobnof,tens,n,p,g):		VWAV(VWAV>,nobnof,tens,n,p,g);
VERB("VERB("+ADVB+","+VWAV+")">,nobnof,tens,n,p,g):    
    ADVB(ADVB>),
    VWAV(VWAV>,nobnof,tens,n,p,g).

VWAV("VWAV("+TINT+")">,INTV,PRST,n,p,g):		TINT(TINT>,n,p,g);
VWAV("VWAV("+VINT+")">,INTV,PAST,n,p,g):		VINT(VINT>);
VWAV("VWAV("+TTRA+")">,TRAV,PRST,n,p,g):		TTRA(TTRA>,n,p,g);
VWAV("VWAV("+VTRA+")">,TRAV,PAST,n,p,g):		VTRA(VTRA>);
VWAV("VWAV("+TMEI+")">,MEIV,PRST,n,p,g):		TMEI(TMEI>,n,p,g);
VWAV("VWAV("+VMEI+")">,MEIV,PAST,n,p,g):		VMEI(VMEI>);
VWAV("VWAV("+TMET+")">,METV,PRST,n,p,g):		TMET(TMET>,n,p,g);
VWAV("VWAV("+VMET+")">,METV,PAST,n,p,g):		VMET(VMET>);
VWAV("VWAV("+TOBE+","+FIVE+")">,nobnof,tens,n,p,g):    
    TOBE(TOBE>,PRST or PAST,n,p,g),
    FIVE(FIVE>,nobnof,PRPL,n,p,g);
VWAV("VWAV("+HAVE+","+FIVE+")">,nobnof,tens,n,p,g):    
    HAVE(HAVE>,PRST or PAST,n,p,g),
    FIVE(FIVE>,nobnof,PAPL,n,p,g);
VWAV("VWAV("+HAVE+","+TOBE+","+FIVE+")">,nobnof,tens,n,p,g):    
    HAVE(HAVE>,PRST or PAST,n,p,g),
    TOBE(TOBE>,PAPL,n,p,g),
    FIVE(FIVE>,nobnof,PRPL,n,p,g);
VWAV("VWAV("+AUXV+","+FIVE+")">,nobnof,tens,n,p,g):    
    AUXV(AUXV>,PRST or PAST,n,p,g),
    FIVE(FIVE>,nobnof,INFI,n,p,g);
VWAV("VWAV("+AUXV+","+TOBE+","+FIVE+")">,nobnof,tens,n,p,g):    
    AUXV(AUXV>,PRST or PAST,n,p,g),
    TOBE(TOBE>,INFI,n,p,g),
    FIVE(FIVE>,nobnof,PRPL,n,p,g);
VWAV("VWAV("+AUXV+","+HAVE+","+FIVE+")">,nobnof,tens,n,p,g):    
    AUXV(AUXV>,PRST or PAST,n,p,g),
    HAVE(HAVE>,INFI,n,p,g),
    FIVE(FIVE>,nobnof,PAPL,n,p,g);
VWAV("VWAV("+AUXV+","+HAVE+","+TOBE+","+FIVE+")">,nobnof,tens,n,p,g):    
    AUXV(AUXV>,PRST or PAST,n,p,g),
    HAVE(HAVE>,INFI,n,p,g),
    TOBE(TOBE>,PAPL,n,p,g),
    FIVE(FIVE>,nobnof,PRPL,n,p,g).

TINT("TINT("+IINT+")">,SING,ONE,PERS):		IINT(IINT>);
TINT("TINT("+IINT+")">,SING,TWO,PERS):		IINT(IINT>);
TINT("TINT("+QINT+")">,SING,THREE,g):		QINT(QINT>);
TINT("TINT("+IINT+")">,PLU,p,g):		IINT(IINT>).

TTRA("TTRA("+ITRA+")">,SING,ONE,PERS):		ITRA(ITRA>);
TTRA("TTRA("+ITRA+")">,SING,TWO,PERS):		ITRA(ITRA>);
TTRA("TTRA("+QTRA+")">,SING,THREE,g):		QTRA(QTRA>);
TTRA("TTRA("+ITRA+")">,PLU,p,g):		ITRA(ITRA>).

TMEI("TMEI("+IMEI+")">,SING,ONE,PERS):		IMEI(IMEI>);
TMEI("TMEI("+IMEI+")">,SING,TWO,PERS):		IMEI(IMEI>);
TMEI("TMEI("+QMEI+")">,SING,THREE,g):		QMEI(QMEI>);
TMEI("TMEI("+IMEI+")">,PLU,p,g):		IMEI(IMEI>).

TMET("TMET("+IMET+")">,SING,ONE,PERS):		IMET(IMET>);
TMET("TMET("+IMET+")">,SING,TWO,PERS):		IMET(IMET>);
TMET("TMET("+QMET+")">,SING,THREE,g):		QMET(QMET>);
TMET("TMET("+IMET+")">,PLU,p,g):		IMET(IMET>).

FIVE("FIVE("+YINT+")">,INTV,PAPL,n,p,g):		YINT(YINT>);
FIVE("FIVE("+YTRA+")">,TRAV,PAPL,n,p,g):		YTRA(YTRA>);
FIVE("FIVE("+YMEI+")">,MEIV,PAPL,n,p,g):		YMEI(YMEI>);
FIVE("FIVE("+YMET+")">,METV,PAPL,n,p,g):		YMET(YMET>);
FIVE("FIVE("+IINT+")">,INTV,INFI,n,p,g):		IINT(IINT>);
FIVE("FIVE("+ITRA+")">,TRAV,INFI,n,p,g):		ITRA(ITRA>);
FIVE("FIVE("+IMEI+")">,MEIV,INFI,n,p,g):		IMEI(IMEI>);
FIVE("FIVE("+IMET+")">,METV,INFI,n,p,g):		IMET(IMET>);
FIVE("FIVE("+XINT+")">,INTV,PRPL,n,p,g):		XINT(XINT>);
FIVE("FIVE("+XTRA+")">,TRAV,PRPL,n,p,g):		XTRA(XTRA>);
FIVE("FIVE("+XMEI+")">,MEIV,PRPL,n,p,g):		XMEI(XMEI>);
FIVE("FIVE("+XMET+")">,METV,PRPL,n,p,g):		XMET(XMET>).

TOBE("TOBE(am)">,PRST,SING,ONE,PERS):		"am", l;
TOBE("TOBE(is)">,PRST,SING,THREE,g):		"is", l;
TOBE("TOBE(are)">,PRST,SING,TWO,PERS):		"are", l;
TOBE("TOBE(are)">,PRST,PLU,p,g):		"are", l;
TOBE("TOBE(was)">,PAST,SING,ONE,PERS):		"was", l;
TOBE("TOBE(were)">,PAST,SING,TWO,PERS):		"were", l;
TOBE("TOBE(was)">,PAST,SING,THREE,g):		"was", l;
TOBE("TOBE(were)">,PAST,PLU,p,g):		"were", l;
TOBE("TOBE(been)">,PAPL,n,p,g):		"been", l;
TOBE("TOBE(be)">,INFI,n,p,g):		"be", l.

HAVE("HAVE(have)">,PRST,SING,ONE,PERS):		"have", l;
HAVE("HAVE(have)">,PRST,SING,TWO,PERS):		"have", l;
HAVE("HAVE(has)">,PRST,SING,THREE,g):		"has", l;
HAVE("HAVE(have)">,PRST,PLU,p,g):		"have", l;
HAVE("HAVE(had)">,PAST,SING,p,PERS):		"had", l;
HAVE("HAVE(had)">,PAST,SING,THREE,IMPR):	"had", l;
HAVE("HAVE(had)">,PAST,PLU,p,g):		"had", l;
HAVE("HAVE(have)">,INFI,n,p,g):			"have", l.

AUXV("AUXV("+TAUX+")">,PRST,n,p,g):		TAUX(TAUX>);
AUXV("AUXV("+STAX+")">,PRST,SING,ONE,g):	STAX(STAX>);
AUXV("AUXV("+PTAX+")">,PRST,SING,TWO,g):	PTAX(PTAX>);
AUXV("AUXV("+PTAX+")">,PRST,PLU,p,g):		PTAX(PTAX>);
AUXV("AUXV("+VAUX+")">,PAST,n,p,g):		VAUX(VAUX>);
AUXV("AUXV("+SVAX+")">,PAST,SING,ONE,g):	SVAX(SVAX>);
AUXV("AUXV("+PVAX+")">,PAST,SING,TWO,g):	PVAX(PVAX>);
AUXV("AUXV("+PVAX+")">,PAST,PLU,p,g):		PVAX(PVAX>).

PVPH("PVPH("+TOBE+","+FIVE+")">,tens,n,p,g):    
    TOBE(TOBE>,PRST or PAST,n,p,g),
    FIVE(FIVE>,wonm,PAPL,n,p,g);
PVPH("PVPH("+TOBE+","+FIVE+","+MVPH+")">,tens,n,p,g):    
    TOBE(TOBE>,PRST or PAST,n,p,g),
    FIVE(FIVE>,METV,PAPL,n,p,g),
    MVPH(MVPH>).


ADVB("ADVB(soon)">):		"soon", l;
ADVB("ADVB(often)">):		"often", l;
ADVB("ADVB(sometimes)">):	"sometimes", l;
ADVB("ADVB(never)">):		"never", l;
ADVB("ADVB(seldom)">):		"seldom", l;
ADVB("ADVB(always)">):		"always", l;
ADVB("ADVB(clearly)">):		"clearly", l.

ARTS("ARTS(a)">):		"a", l;
ARTS("ARTS(an)">):		"an", l.

ARTP("ARTP(the)">):		"the", l.


COOR("COOR(and)">):		"and", l;
COOR("COOR(but)">):		"but", l;
COOR("COOR(or)">):		"or", l;
COOR("COOR(according as)">):	"according as", l;
COOR("COOR(after)">):		"after", l;
COOR("COOR(after all)">):	"after all", l;
COOR("COOR(albeit)">):		"albeit", l;
COOR("COOR(as though)">):	"as though", l;
COOR("COOR(although)">):	"although", l;
COOR("COOR(as)">):		"as", l;
COOR("COOR(as if)">):		"as if", l;
COOR("COOR(as long as)">):	"as long as", l;
COOR("COOR(because)">):		"because", l;
COOR("COOR(before)">):		"before", l;
COOR("COOR(but that)">):	"but that", l;
COOR("COOR(but then)">):	"but then", l;
COOR("COOR(but then again)">):	"but then again", l;
COOR("COOR(considering)">):	"considering", l;
COOR("COOR(cos)">):		"cos", l;
COOR("COOR(directly)">):	"directly", l;
COOR("COOR(ere)">):		"ere", l;
COOR("COOR(except)">):		"except", l;
COOR("COOR(for)">):		"for", l;
COOR("COOR(forasmuch as)">):	"forasmuch as", l;
COOR("COOR(if)">):		"if", l;
COOR("COOR(immediately)">):	"immediately", l;
COOR("COOR(inasmuch as)">):	"inasmuch as", l;
COOR("COOR(in so far as)">):	"in so far as", l;
COOR("COOR(in as far as)">):	"in as far as", l;
COOR("COOR(insofar as)">):	"insofar as", l;
COOR("COOR(insomuch as)">):	"insomuch as", l;
COOR("COOR(lest)">):		"lest", l;
COOR("COOR(like)">):		"like", l;
COOR("COOR(nor)">):		"nor", l;
COOR("COOR(notwithstanding)">):	"notwithstanding", l;
COOR("COOR(now that)">):	"now that", l;
COOR("COOR(now)">):		"now", l;
COOR("COOR(once)">):		"once", l;
COOR("COOR(only)">):		"only", l;
COOR("COOR(provided)">):	"provided", l;
COOR("COOR(provided that)">):	"provided that", l;
COOR("COOR(providing)">):	"providing", l;
COOR("COOR(providing that)">):	"providing that", l;
COOR("COOR(seeing)">):		"seeing", l;
COOR("COOR(seeing that)">):	"seeing that", l;
COOR("COOR(seeing as)">):	"seeing as", l;
COOR("COOR(seeing as how)">):	"seeing as how", l;
COOR("COOR(since)">):		"since", l;
COOR("COOR(so)">):		"so", l;
COOR("COOR(suppose)">):		"suppose", l;
COOR("COOR(supposing)">):	"supposing", l;
COOR("COOR(than)">):		"than", l;
COOR("COOR(that)">):		"that", l;
COOR("COOR(though)">):		"though", l;
COOR("COOR(till)">):		"till", l;
COOR("COOR(unless)">):		"unless", l;
COOR("COOR(until)">):		"until", l;
COOR("COOR(till)">):		"till", l;
COOR("COOR(when)">):		"when", l;
COOR("COOR(whenever)">):	"whenever", l;
COOR("COOR(where)">):		"where", l;
COOR("COOR(whereas)">):		"whereas", l;
COOR("COOR(whereat)">):		"whereat", l;
COOR("COOR(wherefore)">):	"wherefore", l;
COOR("COOR(wherein)">):		"wherein", l;
COOR("COOR(whereof)">):		"whereof", l;
COOR("COOR(whereon)">):		"whereon", l;
COOR("COOR(wheresoever)">):	"wheresoever", l;
COOR("COOR(whereto)">):		"whereto", l;
COOR("COOR(whereunto)">):	"whereunto", l;
COOR("COOR(whereupon)">):	"whereupon", l;
COOR("COOR(wherever)">):	"wherever", l;
COOR("COOR(whether)">):		"whether", l;
COOR("COOR(while)">):		"while", l;
COOR("COOR(whilst)">):		"whilst", l;
COOR("COOR(why)">):		"why", l;
COOR("COOR(without)">):		"without", l;
COOR("COOR(yet)">):		"yet", l;
COOR("COOR(as well as)">):	"as well as", l;
COOR("COOR(just as)">):		"just as", l.

DETS("DETS(any)">):		"any", l;
DETS("DETS(this)">):		"this", l;
DETS("DETS(that)">):		"that", l;
DETS("DETS(no)">):		"no", l;
DETS("DETS(every)">):		"every", l.

DETP("DETP(some)">):		"some", l;
DETP("DETP(each)">):		"each", l;
DETP("DETP(all)">):		"all", l;
DETP("DETP(these)">):		"these", l;
DETP("DETP(those)">):		"those", l.

IINT("IINT(sleep)">):		"sleep", l;
IINT("IINT(sneeze)">):		"sneeze", l;
IINT("IINT(weep)">):		"weep", l;
IINT("IINT(fly)">):		"fly", l;
IINT("IINT(itch)">):		"itch", l;
IINT("IINT(grow old)">):	"grow old", l;
IINT("IINT(brighten)">):	"brighten", l.

IMEI("IMEI(go)">):		"go", l;
IMEI("IMEI(walk)">):		"walk", l;
IMEI("IMEI(come)">):		"come", l;
IMEI("IMEI(lie)">):		"lie", l;
IMEI("IMEI(listen)">):		"listen", l;
IMEI("IMEI(whistle)">):		"whistle", l;
IMEI("IMEI(nod)">):		"nod", l.

IMET("IMET(give)">):		"give", l;
IMET("IMET(take)">):		"take", l;
IMET("IMET(owe)">):		"owe", l;
IMET("IMET(show)">):		"show", l;
IMET("IMET(ask)">):		"ask", l;
IMET("IMET(explain)">):		"explain", l;
IMET("IMET(lend)">):		"lend", l.

ITRA("ITRA(wash)">):		"wash", l;
ITRA("ITRA(want)">):		"want", l;
ITRA("ITRA(see)">):		"see", l;
ITRA("ITRA(like)">):		"like", l;
ITRA("ITRA(love)">):		"love", l;
ITRA("ITRA(look at)">):		"look at", l;
ITRA("ITRA(hate)">):		"hate", l.

PLIM("PLIM(books)">):		"books", l;
PLIM("PLIM(pencils)">):		"pencils", l;
PLIM("PLIM(mice)">):		"mice", l;
PLIM("PLIM(teeth)">):		"teeth", l;
PLIM("PLIM(watches)">):		"watches", l;
PLIM("PLIM(umbrellas)">):	"umbrellas", l;
PLIM("PLIM(trees)">):		"trees", l.

PLPR("PLPR(men)">):		"men", l;
PLPR("PLPR(women)">):		"women", l;
PLPR("PLPR(computers)">):	"computers", l;
PLPR("PLPR(boys)">):		"boys", l;
PLPR("PLPR(girls)">):		"girls", l;
PLPR("PLPR(teachers)">):	"teachers", l;
PLPR("PLPR(indians)">):		"indians", l.

POSP("POSP(my)">):		"my", l;
POSP("POSP(your)">):		"your", l;
POSP("POSP(his)">):		"his", l;
POSP("POSP(her)">):		"her", l;
POSP("POSP(its)">):		"its", l;
POSP("POSP(our)">):		"our", l;
POSP("POSP(their)">):		"their", l.

PTAX("PTAX(are able to)">):	"are able to", l;
PTAX("PTAX(are about to)">):	"are about to", l;
PTAX("PTAX(are apt to)">):	"are apt to", l;
PTAX("PTAX(are bound to)">):	"are bound to", l;
PTAX("PTAX(are due to)">):	"are due to", l;
PTAX("PTAX(are going to)">):	"are going to", l;
PTAX("PTAX(are likely to)">):	"are likely to", l;
PTAX("PTAX(are meant to)">):	"are meant to", l;
PTAX("PTAX(are obliged to)">):	"are obliged to", l;
PTAX("PTAX(are supposed to)">):	"are supposed to", l;
PTAX("PTAX(are willing to)">):	"are willing to", l.

PVAX("PVAX(had been able to)">):	"had been able to", l;
PVAX("PVAX(had been about to)">):	"had been about to", l;
PVAX("PVAX(had been apt to)">):		"had been apt to", l;
PVAX("PVAX(had been bound to)">):	"had been bound to", l;
PVAX("PVAX(had been due to)">):		"had been due to", l;
PVAX("PVAX(had been going to)">):	"had been going to", l;
PVAX("PVAX(had been likely to)">):	"had been likely to", l;
PVAX("PVAX(had been meant to)">):	"had been meant to", l;
PVAX("PVAX(had been obliged to)">):	"had been obliged to", l;
PVAX("PVAX(had been supposed to)">):	"had been supposed to", l;
PVAX("PVAX(had been willing to)">):	"had been willing to", l;
PVAX("PVAX(have been able to)">):	"have been able to", l;
PVAX("PVAX(have been about to)">):	"have been about to", l;
PVAX("PVAX(have been apt to)">):	"have been apt to", l;
PVAX("PVAX(have been bound to)">):	"have been bound to", l;
PVAX("PVAX(have been due to)">):	"have been due to", l;
PVAX("PVAX(have been going to)">):	"have been going to", l;
PVAX("PVAX(have been likely to)">):	"have been likely to", l;
PVAX("PVAX(have been meant to)">):	"have been meant to", l;
PVAX("PVAX(have been obliged to)">):	"have been obliged to", l;
PVAX("PVAX(have been supposed to)">):	"have been supposed to", l;
PVAX("PVAX(have been willing to)">):	"have been willing to", l;
PVAX("PVAX(were able to)">):		"were able to", l;
PVAX("PVAX(were about to)">):		"were about to", l;
PVAX("PVAX(were apt to)">):		"were apt to", l;
PVAX("PVAX(were bound to)">):		"were bound to", l;
PVAX("PVAX(were due to)">):		"were due to", l;
PVAX("PVAX(were going to)">):		"were going to", l;
PVAX("PVAX(were likely to)">):		"were likely to", l;
PVAX("PVAX(were meant to)">):		"were meant to", l;
PVAX("PVAX(were obliged to)">):		"were obliged to", l;
PVAX("PVAX(were supposed to)">):	"were supposed to", l;
PVAX("PVAX(were willing to)">):		"were willing to", l.

RMKS("RMKS(in the first place)">):	"in the first place", l;
RMKS("RMKS(in the second place)">):	"in the second place", l;
RMKS("RMKS(first)">):			"first", l;
RMKS("RMKS(first of all)">):		"first of all", l;
RMKS("RMKS(second)">):			"second", l;
RMKS("RMKS(second of all)">):		"second of all", l;
RMKS("RMKS(third)">):			"third", l;
RMKS("RMKS(firstly)">):			"firstly", l;
RMKS("RMKS(secondly)">):		"secondly", l;
RMKS("RMKS(thirdly)">):			"thirdly", l;
RMKS("RMKS(last of all)">):		"last of all", l;
RMKS("RMKS(last)">):			"last", l;
RMKS("RMKS(on the one hand)">):		"on the one hand", l;
RMKS("RMKS(on the other hand)">):	"on the other hand", l;
RMKS("RMKS(for one thing)">):		"for one thing", l;
RMKS("RMKS(for another)">):		"for another", l;
RMKS("RMKS(for a start)">):		"for a start", l;
RMKS("RMKS(to begin with)">):		"to begin with", l;
RMKS("RMKS(to start with)">):		"to start with", l;
RMKS("RMKS(to conclude)">):		"to conclude", l;
RMKS("RMKS(next)">):			"next", l;
RMKS("RMKS(then)">):			"then", l;
RMKS("RMKS(finally)">):			"finally", l;
RMKS("RMKS(lastly)">):			"lastly", l;
RMKS("RMKS(correspondingly)">):		"correspondingly", l;
RMKS("RMKS(equally)">):			"equally", l;
RMKS("RMKS(likewise)">):		"likewise", l;
RMKS("RMKS(similarly)">):		"similarly", l;
RMKS("RMKS(again)">):			"again", l;
RMKS("RMKS(also)">):			"also", l;
RMKS("RMKS(further)">):			"further", l;
RMKS("RMKS(furthermore)">):		"furthermore", l;
RMKS("RMKS(more)">):			"more", l;
RMKS("RMKS(moreover)">):		"moreover", l;
RMKS("RMKS(altogether)">):		"altogether", l;
RMKS("RMKS(overall)">):			"overall", l;
RMKS("RMKS(therefore)">):		"therefore", l;
RMKS("RMKS(thus)">):			"thus", l;
RMKS("RMKS(specifically)">):		"specifically", l;
RMKS("RMKS(accordingly)">):		"accordingly", l;
RMKS("RMKS(consequently)">):		"consequently", l;
RMKS("RMKS(hence)">):			"hence", l;
RMKS("RMKS(now)">):			"now", l;
RMKS("RMKS(so)">):			"so", l;
RMKS("RMKS(somehow)">):			"somehow", l;
RMKS("RMKS(otherwise)">):		"otherwise", l;
RMKS("RMKS(rather)">):			"rather", l;
RMKS("RMKS(alternatively)">):		"alternatively", l;
RMKS("RMKS(contrariwise)">):		"contrariwise", l;
RMKS("RMKS(conversely)">):		"conversely", l;
RMKS("RMKS(instead)">):			"instead", l;
RMKS("RMKS(oppositely)">):		"oppositely", l;
RMKS("RMKS(anyhow)">):			"anyhow", l;
RMKS("RMKS(anyway)">):			"anyway", l;
RMKS("RMKS(anyways)">):			"anyways", l;
RMKS("RMKS(besides)">):			"besides", l;
RMKS("RMKS(however)">):			"however", l;
RMKS("RMKS(nevertheless)">):		"nevertheless", l;
RMKS("RMKS(nonetheless)">):		"nonetheless", l;
RMKS("RMKS(notwithstanding)">):		"notwithstanding", l;
RMKS("RMKS(still)">):			"still", l;
RMKS("RMKS(still and all)">):		"still and all", l;
RMKS("RMKS(though)">):			"though", l;
RMKS("RMKS(yet)">):			"yet", l;
RMKS("RMKS(incidentally)">):		"incidentally", l;
RMKS("RMKS(admittedly)">):		"admittedly", l;
RMKS("RMKS(meanwhile)">):		"meanwhile", l;
RMKS("RMKS(originally)">):		"originally", l;
RMKS("RMKS(subsequently)">):		"subsequently", l;
RMKS("RMKS(eventually)">):		"eventually", l;
RMKS("RMKS(in the same way)">):		"in the same way", l;
RMKS("RMKS(in particular)">):		"in particular", l;
RMKS("RMKS(in addition)">):		"in addition", l;
RMKS("RMKS(in all)">):			"in all", l;
RMKS("RMKS(in conclusion)">):		"in conclusion", l;
RMKS("RMKS(in sum)">):			"in sum", l;
RMKS("RMKS(in other words)">):		"in other words", l;
RMKS("RMKS(in consequence)">):		"in consequence", l;
RMKS("RMKS(in that case)">):		"in that case", l;
RMKS("RMKS(in contrast)">):		"in contrast", l;
RMKS("RMKS(in comparison)">):		"in comparison", l;
RMKS("RMKS(in any case)">):		"in any case", l;
RMKS("RMKS(in any event)">):		"in any event", l;
RMKS("RMKS(in spite of that)">):	"in spite of that", l;
RMKS("RMKS(in spite of it all)">):	"in spite of it all", l;
RMKS("RMKS(in the meantime)">):		"in the meantime", l;
RMKS("RMKS(in the meanwhile)">):	"in the meanwhile", l;
RMKS("RMKS(in a word)">):		"in a word", l;
RMKS("RMKS(in short)">):		"in short", l;
RMKS("RMKS(in fact)">):			"in fact", l;
RMKS("RMKS(by the same token)">):	"by the same token", l;
RMKS("RMKS(by way of contrast)">):	"by way of contrast", l;
RMKS("RMKS(by comparison)">):		"by comparison", l;
RMKS("RMKS(by way of comparison)">):	"by way of comparison", l;
RMKS("RMKS(by contrast)">):		"by contrast", l;
RMKS("RMKS(by the way)">):		"by the way", l;
RMKS("RMKS(by the by)">):		"by the by", l;
RMKS("RMKS(by the bye)">):		"by the bye", l;
RMKS("RMKS(what is more)">):		"what is more", l;
RMKS("RMKS(above all)">):		"above all", l;
RMKS("RMKS(on top of it all)">):	"on top of it all", l;
RMKS("RMKS(on the contrary)">):		"on the contrary", l;
RMKS("RMKS(to top it)">):		"to top it", l;
RMKS("RMKS(to top it all)">):		"to top it all", l;
RMKS("RMKS(to cap it)">):		"to cap it", l;
RMKS("RMKS(to cap it all)">):		"to cap it all", l;
RMKS("RMKS(to conclude)">):		"to conclude", l;
RMKS("RMKS(to sum up)">):		"to sum up", l;
RMKS("RMKS(to summarize)">):		"to summarize", l;
RMKS("RMKS(all in all)">):		"all in all", l;
RMKS("RMKS(all the same)">):		"all the same", l;
RMKS("RMKS(for example)">):		"for example", l;
RMKS("RMKS(for instance)">):		"for instance", l;
RMKS("RMKS(for all that)">):		"for all that", l;
RMKS("RMKS(that is)">):			"that is", l;
RMKS("RMKS(that is to say)">):		"that is to say", l;
RMKS("RMKS(that said)">):		"that said", l;
RMKS("RMKS(as a consequence)">):	"as a consequence", l;
RMKS("RMKS(as a result)">):		"as a result", l;
RMKS("RMKS(as a matter of fact)">):	"as a matter of fact", l;
RMKS("RMKS(of course)">):		"of course", l;
RMKS("RMKS(more accurately)">):		"more accurately", l;
RMKS("RMKS(more precisely)">):		"more precisely", l;
RMKS("RMKS(at any rate)">):		"at any rate", l;
RMKS("RMKS(at all events)">):		"at all events", l;
RMKS("RMKS(at the same time)">):	"at the same time", l;
RMKS("RMKS(at least)">):		"at least", l;
RMKS("RMKS(after all)">):		"after all", l.


STAX("STAX(am able to)">):	"am able to", l;
STAX("STAX(am about to)">):	"am about to", l;
STAX("STAX(am apt to)">):	"am apt to", l;
STAX("STAX(am bound to)">):	"am bound to", l;
STAX("STAX(am due to)">):	"am due to", l;
STAX("STAX(am going to)">):	"am going to", l;
STAX("STAX(am likely to)">):	"am likely to", l;
STAX("STAX(am meant to)">):	"am meant to", l;
STAX("STAX(am obliged to)">):	"am obliged to", l;
STAX("STAX(am supposed to)">):	"am supposed to", l;
STAX("STAX(am willing to)">):	"am willing to", l.

SVAX("SVAX(was able to)">):	"was able to", l;
SVAX("SVAX(was about to)">):	"was about to", l;
SVAX("SVAX(was apt to)">):	"was apt to", l;
SVAX("SVAX(was bound to)">):	"was bound to", l;
SVAX("SVAX(was due to)">):	"was due to", l;
SVAX("SVAX(was going to)">):	"was going to", l;
SVAX("SVAX(was likely to)">):	"was likely to", l;
SVAX("SVAX(was meant to)">):	"was meant to", l;
SVAX("SVAX(was obliged to)">):	"was obliged to", l;
SVAX("SVAX(was supposed to)">):	"was supposed to", l;
SVAX("SVAX(was willing to)">):	"was willing to", l;
SVAX("SVAX(had been able to)">):	"had been able to", l;
SVAX("SVAX(had been about to)">):	"had been about to", l;
SVAX("SVAX(had been apt to)">):		"had been apt to", l;
SVAX("SVAX(had been bound to)">):	"had been bound to", l;
SVAX("SVAX(had been due to)">):		"had been due to", l;
SVAX("SVAX(had been going to)">):	"had been going to", l;
SVAX("SVAX(had been likely to)">):	"had been likely to", l;
SVAX("SVAX(had been meant to)">):	"had been meant to", l;
SVAX("SVAX(had been obliged to)">):	"had been obliged to", l;
SVAX("SVAX(had been supposed to)">):	"had been supposed to", l;
SVAX("SVAX(had been willing to)">):	"had been willing to", l;
SVAX("SVAX(have been able to)">):	"have been able to", l;
SVAX("SVAX(have been about to)">):	"have been about to", l;
SVAX("SVAX(have been apt to)">):	"have been apt to", l;
SVAX("SVAX(have been bound to)">):	"have been bound to", l;
SVAX("SVAX(have been due to)">):	"have been due to", l;
SVAX("SVAX(have been going to)">):	"have been going to", l;
SVAX("SVAX(have been likely to)">):	"have been likely to", l;
SVAX("SVAX(have been meant to)">):	"have been meant to", l;
SVAX("SVAX(have been obliged to)">):	"have been obliged to", l;
SVAX("SVAX(have been supposed to)">):	"have been supposed to", l;
SVAX("SVAX(have been willing to)">):	"have been willing to", l.

TO("TO(to)">):		"to", l.

QINT("QINT(sleeps)">):		"sleeps", l;
QINT("QINT(sneezes)">):		"sneezes", l;
QINT("QINT(weeps)">):		"weeps", l;
QINT("QINT(flies)">):		"flies", l;
QINT("QINT(itches)">):		"itches", l;
QINT("QINT(grows old)">):	"grows old", l;
QINT("QINT(brightens)">):	"brightens", l.

QMEI("QMEI(goes)">):		"goes", l;
QMEI("QMEI(walks)">):		"walks", l;
QMEI("QMEI(comes)">):		"comes", l;
QMEI("QMEI(lies)">):		"lies", l;
QMEI("QMEI(listens)">):		"listens", l;
QMEI("QMEI(whistles)">):	"whistles", l;
QMEI("QMEI(nods)">):		"nods", l.

QMET("QMET(gives)">):		"gives", l;
QMET("QMET(takes)">):		"takes", l;
QMET("QMET(owes)">):		"owes", l;
QMET("QMET(shows)">):		"shows", l;
QMET("QMET(asks)">):		"asks", l;
QMET("QMET(explains)">):	"explains", l;
QMET("QMET(lends)">):		"lends", l.

QTRA("QTRA(washes)">):		"washes", l;
QTRA("QTRA(wants)">):		"wants", l;
QTRA("QTRA(sees)">):		"sees", l;
QTRA("QTRA(likes)">):		"likes", l;
QTRA("QTRA(loves)">):		"loves", l;
QTRA("QTRA(looks at)">):	"looks at", l;
QTRA("QTRA(hates)">):		"hates", l.

TAUX("TAUX(can)">):		"can", l;
TAUX("TAUX(will)">):		"will", l;
TAUX("TAUX(shall)">):		"shall", l;
TAUX("TAUX(ought to)">):	"ought to", l;
TAUX("TAUX(must)">):		"must", l;
TAUX("TAUX(may)">):		"may", l;
TAUX("TAUX(wont)">):		"wont", l.

VAUX("VAUX(could)">):		"could", l;
VAUX("VAUX(would)">):		"would", l;
VAUX("VAUX(should)">):		"should", l;
VAUX("VAUX(had to)">):		"had to", l;
VAUX("VAUX(was to)">):		"was to", l;
VAUX("VAUX(used to)">):		"used to", l;
VAUX("VAUX(liked to)">):	"liked to", l.

VINT("VINT(slept)">):		"slept", l;
VINT("VINT(sneezed)">):		"sneezed", l;
VINT("VINT(wept)">):		"wept", l;
VINT("VINT(flew)">):		"flew", l;
VINT("VINT(itched)">):		"itched", l;
VINT("VINT(grew old)">):	"grew old", l;
VINT("VINT(brightened)">):	"brightened", l.

VMEI("VMEI(went)">):		"went", l;
VMEI("VMEI(walked)">):		"walked", l;
VMEI("VMEI(came)">):		"came", l;
VMEI("VMEI(lied)">):		"lied", l;
VMEI("VMEI(nodded)">):		"nodded", l;
VMEI("VMEI(listened)">):	"listened", l;
VMEI("VMEI(whistled)">):	"whistled", l.

VMET("VMET(gave)">):		"gave", l;
VMET("VMET(took)">):		"took", l;
VMET("VMET(owed)">):		"owed", l;
VMET("VMET(showed)">):		"showed", l;
VMET("VMET(explained)">):	"explained", l;
VMET("VMET(asked)">):		"asked", l;
VMET("VMET(lent)">):		"lent", l.

VTRA("VTRA(washed)">):		"washed", l;
VTRA("VTRA(wanted)">):		"wanted", l;
VTRA("VTRA(saw)">):		"saw", l;
VTRA("VTRA(liked)">):		"liked", l;
VTRA("VTRA(loved)">):		"loved", l;
VTRA("VTRA(looked at)">):	"looked at", l;
VTRA("VTRA(hated)">):		"hated", l.

XINT("XINT(sleeping)">):	"sleeping", l;
XINT("XINT(sneezing)">):	"sneezing", l;
XINT("XINT(weeping)">):		"weeping", l;
XINT("XINT(flying)">):		"flying", l;
XINT("XINT(itching)">):		"itching", l;
XINT("XINT(growing old)">):	"growing old", l;
XINT("XINT(brightening)">):	"brightening", l.

XMEI("XMEI(going)">):		"going", l;
XMEI("XMEI(walking)">):		"walking", l;
XMEI("XMEI(coming)">):		"coming", l;
XMEI("XMEI(lying)">):		"lying", l;
XMEI("XMEI(listening)">):	"listening", l;
XMEI("XMEI(whistling)">):	"whistling", l;
XMEI("XMEI(nodding)">):		"nodding", l.

XMET("XMET(giving)">):		"giving", l;
XMET("XMET(taking)">):		"taking", l;
XMET("XMET(owing)">):		"owing", l;
XMET("XMET(showing)">):		"showing", l;
XMET("XMET(explaining)">):	"explaining", l;
XMET("XMET(asking)">):		"asking", l;
XMET("XMET(lending)">):		"lending", l.

XTRA("XTRA(washing)">):		"washing", l;
XTRA("XTRA(wanting)">):		"wanting", l;
XTRA("XTRA(seeing)">):		"seeing", l;
XTRA("XTRA(liking)">):		"liking", l;
XTRA("XTRA(loving)">):		"loving", l;
XTRA("XTRA(looking at)">):	"looking at", l;
XTRA("XTRA(hating)">):		"hating", l.

YINT("YINT(slept)">):		"slept", l;
YINT("YINT(sneezed)">):		"sneezed", l;
YINT("YINT(wept)">):		"wept", l;
YINT("YINT(flown)">):		"flown", l;
YINT("YINT(itched)">):		"itched", l;
YINT("YINT(grown old)">):	"grown old", l;
YINT("YINT(brightened)">):	"brightened", l.

YMEI("YMEI(gone)">):		"gone", l;
YMEI("YMEI(walked)">):		"walked", l;
YMEI("YMEI(come)">):		"come", l;
YMEI("YMEI(lied)">):		"lied", l;
YMEI("YMEI(listened)">):	"listened", l;
YMEI("YMEI(whistled)">):	"whistled", l;
YMEI("YMEI(nodded)">):		"nodded", l.

YMET("YMET(given)">):		"given", l;
YMET("YMET(taken)">):		"taken", l;
YMET("YMET(owed)">):		"owed", l;
YMET("YMET(shown)">):		"shown", l;
YMET("YMET(explained)">):	"explained", l;
YMET("YMET(asked)">):		"asked", l;
YMET("YMET(lent)">):		"lent", l.

YTRA("YTRA(washed)">):		"washed", l;
YTRA("YTRA(wanted)">):		"wanted", l;
YTRA("YTRA(seen)">):		"seen", l;
YTRA("YTRA(liked)">):		"liked", l;
YTRA("YTRA(loved)">):		"loved", l;
YTRA("YTRA(looked at)">):	"looked at", l;
YTRA("YTRA(hated)">):		"hated", l.

# Definition of lattice nr 0
n :: {} SING; PLU.

SING :: {} SING.
PLU :: {} PLU.

# Lattice nr 1  
p :: {}
		ONE;
		TWO;
		THREE.

ONE :: {} ONE.
TWO :: {} TWO.
THREE :: {} THREE.

# Lattice nr 2 
g :: {} PERS; IMPR.

PERS :: {} PERS.
IMPR :: {} IMPR.

# Lattice nr 3  
nobnof :: {} nonm; nowm; wonm; wowm.

nonm :: {} INTV; TRAV; MEIV; METV.
nowm :: {} MEIV; METV.
wonm :: {} TRAV; METV.
wowm :: {} METV.

INTV :: {} INTV.
TRAV :: {} TRAV.
MEIV :: {} MEIV.
METV :: {} METV.

# Lattice nr 4 
tens :: {} PRST; PAST; INFI; PRPL; PAPL; PRST or PAST.

PRST :: {} PRST.
PAST :: {} PAST.
INFI :: {} INFI.
PRPL :: {} PRPL.
PAPL :: {} PAPL.
PRST or PAST :: {} PRST; PAST.

SIPR("SIPR("+name+")">): 
        identifier(name>), l,
        lookup (>LEX SIPR,>name).

SIIM("SIIM("+name+")">): 
        identifier(name>), l,
        lookup (>LEX SIIM,>name).


ADIE("ADIE("+name+")">):
        identifier(name>),l,
        lookup (>LEX ADIE,>name).

lookup (>Channel, >key):
     talk to unix (>Channel, >key+nlcr, f>),
     more lookup (>f).

more lookup (>"1"):
    #type out (>"+\n"), 
     ->;
more lookup (>"0"):
    #type out (>"-\n"), 
    fail.

l : ! \t! +, ->;
l : ".".

%$TEX
\input{\jobname.ind}
\end{document}
%
