/*

    This file is a part of the GLAMMAR source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  Eric Voss, ericv@cs.kun.nl 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*

  file : glammar.h
  last change: 27 februari 1989.
  
  "glammar.h" is included in the generated code from the compiler.

*/
#include <stdio.h>
#define CSTORE_INPUT_HEAP_SIZE 300000
/*
    This heap is used to store the input and to evaluate affixes.
    It is not tested for overflow.
*/

#define AFFIX_HEAP_SIZE 200000
/*
    This heap is used to store affixes .
    It is not tested for overflow.
    For complete non-deterministic grammars this stack stays empty.
*/

/*
INPUT_MEMO_SIZE
    This size specifies the number of integers (bits) to represent 
    the memoize table state  for the current input character.
    If an integer takes 32 bits and INPUT_MEMO_SIZE is set to 64
    it means that 64 * 32 = 2048 characters can be memoized.
    It is tested for overflow.
*/
    
#define CONTINUATION_STACK_SIZE 3000

/*
    On this stack continuations are put on.
    In the beginning and end this stack is empty and less obvious also 
    in the middle (when found a parse) this stack is empty.
    It is tested for overflow.
    For deterministic grammars this stack is always empty.
*/
typedef  union { void (*q)() ; int *i;char *s,**l; AFFIX a; } cont;


#define COPY(x,y) (x)->t = (y)->t ; (x)->l = (y)->l ; (x)->r = (y)->r
#define SHARE(x,y) (x)->t = empty ; (x)->l = nil ; (x)->r = y 
#define MAKE(x,y) if ( (y)->t == undefined) { SHARE(x,y);} else { COPY (x,y); }

cont *q_stack,*q_top,*q;
int q_size = CONTINUATION_STACK_SIZE;
char *input,*cstore,*ip, *mip,*limitip, *empty = "",
     *c, *ct,*undefined = "undefined", *cstore_top,
     *fast_list_acces = "\001", *inputbuff = "",
      *set_ip_start_pos;

affix fla = {"@@@",0,0};

AFFIX affix_heap,afx_top,af;
int argc;
char ** arg_v; 
int  set_ip_start_num ;
int  tabstop = 8 ;
int rcount =0, rmax =0,parsecount=0,nrofchars,level=0,eval_count, emsg_count=0;
int cssize= CSTORE_INPUT_HEAP_SIZE;
int afhsize= AFFIX_HEAP_SIZE;
#ifdef MEMOIZE
 int memo_table[MEMOIZE][INPUT_MEMO_SIZE];
#endif
extern int interesting_level_number;
extern void found();

#define nil 0
#define true 1
#define false 0


void uterminal_();
void uchoice_();
void uex_choice();
void ux_star_ex_choice();
void ux_star_choice();
void ux_plus_ex_choice();
void ux_plus_choice();
int dterminal_();
int dchoice_();
int dex_choice();
int dx_star_ex_choice();
int dx_star_choice();
int dx_plus_ex_choice();
int dx_plus_choice();

void lkh_epiloque();
void lkh_proloque();

#ifdef INPUT_MEMO_SIZE
int runtime_input_size = INPUT_MEMO_SIZE * 8 * sizeof(int);
#else 
int runtime_input_size =  200000;
#endif 
#define nil 0
#define MEMTEMPS int m1= (rip-input)>>5, m2= (0X1 << ((rip-input)&31))
#define SET(pr) (memo_table[pr][m1] & m2) != 0
#define CLEAR(pr) memo_table[pr][m1] &= ~m2

char            in_file_name[256] = {""},
                out_file_name[256] = {""},
                current_file_name[256] = {""},
                error_msg[256] = {""};
char           *thischar;
FILE           *inputfile;
FILE           *output =0;
int             interesting_level_number = 0,
                output_to_stdout = 0;
int             input_from_stdin = 0;
int             set_line_num;
char            *set_line_pos; 
char            *set_file_name = "\0"; 
int             change_line_file = 0;
int             exit_code = 0;


char *argv[11];

int             ll_mode = false,  /* loop line mode */  ll_count=0;
int             abq_level = 1000000, report_stacksize = false, stack_bottum;

struct eaglist {
   AFFIX   table;
   AFFIX   key;
   AFFIX   value;
   struct eaglist *left;
   struct eaglist *right;
   struct eaglist *next;
}       initial_l= {&fla,&fla,&fla,0,0,0},*root = &initial_l;

affix _dont_care  = {"!@!",0,0}, *A_9999 = &_dont_care;
