/*

    This file is a part of the GLAMMAR source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  Eric Voss, ericv@cs.kun.nl 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "ge1.h"
#ifdef DEVALAFFIX
int             devalaffix(A, B)
register AFFIX A, B;
{
  register char  *rc = c;
  if (((A->r) == nil) && ((A->l) == nil))
    rc = (A->t);
  else {
    sprinta(A);
    *c++ = '\0';
  }
  if (c > cstore_top ) cstore_overflow();
  B -> t =  rc;
  B -> r =  nil;
  B -> l =  nil;
  return true;
}
#endif

#ifdef UEVALAFFIX
void uevalaffix() 
{ 
   register cont *rq = q;
register AFFIX A_1 = rq->a;
register AFFIX A_0 = (rq -1)->a;
   char *rc = c;
   if ( devalaffix (A_0, A_1)) {
      q = rq -3;
      (*(rq -2)->q)(); 
      rq = q +2;
   }
  c = rc;
   (rq -1)->a = A_0;
   rq->a = A_1;
   (rq + 1)->q = uevalaffix; 
   q = rq + 1; 
}
#endif

#ifdef UFAIL
void ufail() {             /* fail */
  (++q)->q = ufail;
}

#endif

#ifdef DFAIL
int dfail() {
  return false;
}
#endif

#ifdef USETEXITCODE
void usetexitcode() {             /* set exit code */
  exit_code = 2;
  CONTINUE; 
  (++q)->q = usetexitcode;
}
#endif

#ifdef DSETEXITCODE
int dsetexitcode() {
  exit_code = 2;
  return true;
}
#endif

#ifdef DGETENV
char * getenv();
int             dgetenv(A, B)
register AFFIX A, B;
{
  register char  *rc = c;
  if (((A->r) == nil) && ((A->l) == nil))
    rc = (A->t);
  else {
    sprinta(A);
    *c++ = '\0';
  }
  if (c > cstore_top ) cstore_overflow();
  B -> t =  getenv(rc);
  if (!B ->t)  return false;
  B -> r =  nil;
  B -> l =  nil;
  return true;
}
#endif

#ifdef UGETENV
void ugetenv() 
{ 
   register cont *rq = q;
register AFFIX A_1 = rq->a;
register AFFIX A_0 = (rq -1)->a;
   char *rc = c;
   if ( dgetenv (A_0, A_1)) {
      q = rq -3;
      (*(rq -2)->q)(); 
      rq = q +2;
   }
   c = rc;
   (rq -1)->a = A_0;
   rq->a = A_1;
   (rq + 1)->q = ugetenv; 
   q = rq + 1; 
}
#endif

#ifdef DERRORMESSAGE  
int x_errline(b,e)
char *b,*e;
{
   if (b> e) {
      *c++ = '\n';
      return;
   }
   if (e > (b+75) ) {
      b = e -75;
      *c++ = '@';
   }
   while (b<=e)
      *c++ = *b++;
}

int x_underline(b,e)
char *b,*e;
{
   if (b> e) {
      *c++ = '\n';
      return;
   }
   if (e> b+75) 
      b = e -76;
    for (; b <= e; b++) {
       if (b == mip) {
        int o = *mip;
        o &= 255;
        sprintf(c,"^(%o)\n",o);
        while (*++c);
        break;
       }
       else if (*b == '\t')
        *c++ = '\t';
       else 
        *c++ = '-';
    }
}
          
int x_errmsg()
{
	char *beginmsg,*endmsg,*count;
	int linenumber = 1, cc_error = false;


	if (*mip == '\0') {
		sprintf(c, "*** Context error, after parsing");
		while (*++c);
                cc_error = true;
	}
        else {
	/* say line number */
	linenumber = set_ip_start_num;
	for (count = set_ip_start_pos; count < mip;)
		if (*count++ == '\n')
			linenumber += 1;
	if (*count == '\n')
		linenumber += 1;
	sprintf(c, "*** line %d", linenumber);
	while (*++c);
        }

	/* say file */

	if (*current_file_name != '\0')  {
		sprintf (c,", file: %s", current_file_name);
		while (*++c);
	}

	if (rmax >0 ) {
		sprintf(c, ", while parsing \"%s\"",error_msg);
		while (*++c);
	}
        



        if (!cc_error) {
           *c++ = ':';

        
	   for (beginmsg = mip; *beginmsg != '\n'; beginmsg -= 1) ;
	   /* print  x_errline */
	   endmsg = mip;
	   for (endmsg = mip; *endmsg != '\n';endmsg +=1) ;
	   x_errline (beginmsg,endmsg);
	   x_underline (beginmsg+1,endmsg);
        } else {
           *c++ = '.';
           *c++ = '\n';
        }
	*c++ = '\0';
	return true;
}

int derrormessage(A_0)              /* newname */
register AFFIX A_0;
{
	int             lt = (int) c, lta = (int) 'A';
	A_0->t = c;
	A_0->l = nil;
	A_0->r = nil;
        emsg_count += 1;
	x_errmsg();
}
#endif


#ifdef UERRORMESSAGE 
void uerrormessage ()
{
	register cont *rq = q;
	register affix *A_0 = rq->a;
	char *rc = c;
	if ( derrormessage (A_0)) {
		q = rq -2;
		(*(rq -1)->q)();
		rq = q +1;
                emsg_count -= 1;
	}
	rq->a = A_0;
	(rq + 1)->q = uerrormessage;
	q = rq + 1;
	c = rc;
	if (rc > cstore_top ) cstore_overflow();
}
#endif
