
/*

    This file is a part of the GLAMMAR source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  Eric Voss, ericv@cs.kun.nl 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "ge1.h"
#ifdef USKIP
void uskip_() {
  q -= 1;
  (*(q + 1)->q) ();
}
#endif

#ifdef LKH
void lkh_epiloque() {
  char          **lkh = (q--)->l;
  ip = *lkh;
  q -= 1;
  (*(q + 1)->q) ();
  (++q)->l = lkh;
  (++q)->q = lkh_epiloque;
}
void lkh_proloque() {
  char          **lkh = (q--)->l;
  *lkh = ip;
  q -= 1;
  (*(q + 1)->q) ();
  (++q)->l = lkh;
  (++q)->q = lkh_proloque;
}
#endif

#ifdef UCUT
void ucut() {
  int            *cut_set = (q--)->i;
  *cut_set = 1;
  q -= 1;
  (*(q + 1)->q) ();
  (++q)->i = cut_set;
  (++q)->q = ucut;
}
#endif

#ifdef UIDENTIFIER
void uidentifier() {           /* identifier */

  register cont  *rq = q;
  char           *rip = ip, *rc = c;
  register affix *A_0 = (rq + 0)->a;
  {
    if (didentifier(A_0)) {
      q = rq + -2;
      (*(rq + -1)->q) ();
      rq = q - -1;
      if (mip < ip) {
        mip = ip;
        set_ip_start_pos = set_line_pos;
        set_ip_start_num = set_line_num;
      }
    }
    ip = rip;
    c = rc;
  if (rc > cstore_top ) cstore_overflow();
  }
  (rq + 0)->a = A_0;
  (rq + 1)->q = uidentifier;
  q = rq + 1;
}
#endif
#define TESTletter  (isalpha (*rip) )
#define TESTmorename  (isalnum (*rip) ) || (*rip == '_') || (*rip == '\'')

#ifdef  DIDENTIFIER
int didentifier(A_0)
register AFFIX A_0;
{
  register char *rip = ip, *rc = c;
  if (!TESTletter)
    return false;
  A_0 ->t = rc;
  A_0 ->r = nil;
  A_0 ->l = nil;
  do {
    *rc++ = *rip++;
  } while (TESTmorename);
  *rc++ = '\0';
  ip = rip;
  c = rc;
  if (rc > cstore_top ) cstore_overflow();
  return true;
}
#endif

#ifdef ULETTERDIGITSEQUENCE
void uletterdigitsequence() {           /* identifier */
  register cont  *rq = q;
  char           *rip = ip, *rc = c;
  register affix *A_0 = (rq + 0)->a;
  {
    if (dletterdigitsequence(A_0)) {
      q = rq + -2;
      (*(rq + -1)->q) ();
      rq = q - -1;
      if (mip < ip) {
        mip = ip;
        set_ip_start_pos = set_line_pos;
        set_ip_start_num = set_line_num;
      }
    }
    ip = rip;
    c = rc;
  if (rc > cstore_top ) cstore_overflow();
  }
  (rq + 0)->a = A_0;
  (rq + 1)->q = uletterdigitsequence;
  q = rq + 1;
}
#endif
#define TESTletter  (isalpha (*rip) )
#define TESTletdig  (isalnum (*rip) )

#ifdef DLETTERDIGITSEQUENCE
int dletterdigitsequence(A_0)
register AFFIX A_0;
{
  register char *rip = ip, *rc = c;
  if (!TESTletter)
    return false;
  A_0 ->t = rc;
  A_0 ->r = nil;
  A_0 ->l = nil;
  do {
    *rc++ = *rip++;
  } while (TESTletdig);
  *rc++ = '\0';
  ip = rip;
  c = rc;
  if (rc > cstore_top ) cstore_overflow();
  return true;
}
#endif

#ifdef UNLCR
void unlcr() {             /* nlcr */
  if ((*ip == '\0') || (dterminal_("\n"))) 
  {
    CONTINUE;
  }
  (++q)->q = unlcr;
}
#endif

#ifdef DNLCR
int dnlcr() {
  return (*ip == '\0') || (dterminal_("\n"));
}
#endif
#ifdef UBSLASH
void ubackslash() {             /* quote */
  if (dterminal_("\\"))
  {
    CONTINUE;
  }
  (++q)->q = ubackslash;
}
#endif

#ifdef DBSLASH
int dbackslash() {
  return  (dterminal_("\\"));
}
#endif

#ifdef UQUOTE
void uquote() {             /* quote */
  if (dterminal_("\""))
  {
    CONTINUE;
  }
  (++q)->q = uquote;
}
#endif

#ifdef DQUOTE
int dquote() {
  return  (dterminal_("\""));
}
#endif

#ifdef UENDOFSENTENCE
void uendofsentence() {           /* endofsentence */
  if (*ip == '\0') {
    q -= 1;
    (*(*(q + 1)).q) ();
  }
  (++q)->q = uendofsentence;
}
#endif

#ifdef DENDOFSENTENCE
int dendofsentence() {
  return (*ip == '\0');
}
#endif

