/* 
   Copyright (C) 1990 C van Reewijk, email: dutentb.uucp!reeuwijk

This file is part of GLASS.

GLASS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GLASS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLASS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* file: lltest.c

   Test of 'll' modules: read a file for a given datastructure
   and write it out again in pretty-printed format.
 */

#include <stdio.h>
#include <tmc.h>

#include "llcode.h"

int main(){
    toplevel_list ds;
    toplevel_list dscopy;

    if( fscan_toplevel_list( stdin, &ds ) ){
	fprintf( stderr, "Read error: %s\n", tmerrmsg );
    }
    dscopy = rdup_toplevel_list( ds );
    if( cmp_toplevel_list( ds, dscopy ) != 0 ){
	fprintf( stderr, "Strange, copy not equal to original\n" );
	exit( 1 );
    }
    ds = app_toplevel_list( ds, dscopy );
    fprint_toplevel_list( stdout, ds );
    setprint( stdout, 4, 80 );
    print_toplevel_list( ds );
    rfre_toplevel_list( ds );
    stat_ds( stderr );
    exit( 0 );
    return( 0 );
}
