/* 
   Copyright (C) 1990 C van Reewijk, email: dutentb.uucp!reeuwijk

This file is part of GLASS.

GLASS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GLASS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLASS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* file: tmmisc.c
   Various low-level routines.
 */

#include "tmdefs.h"

#include "debug.h"
#include "tmmisc.h"
#include "tmerror.h"

/******************************************************
 *                                                    *
 *            ALLOCATION ROUTINES                     *
 *                                                    *
 ******************************************************/

extern char *malloc();
extern char *realloc();

/* Allocate the given amount of memory and check if
   it has been done. If not, complain, and stop.
 */
char *ckmalloc( sz )
 unsigned sz;
{
    register char *adr;

    adr = malloc( sz );
    if( adr == CHARNIL ){
	error( NOROOM );
	exit( 1 );
    }
    return( adr );
}

/* Allocate the given amount of memory and check if
   it has been done. If not, complain, and stop.
 */
char *ckrealloc( old, sz )
 char *old;
 unsigned sz;
{
    register char *adr;

    adr = realloc( old, sz );
    if( adr == CHARNIL ){
	error( NOROOM );
	exit( 1 );
    }
    return( adr );
}

/* Same as fopen, but give error message if file can't be opened */
FILE *ckfopen( nm, acc )
 char *nm;
 char *acc;
{
    register FILE *hnd;

    hnd = fopen( nm, acc );
    if( NULL == hnd ){
	(void) strcpy( errarg, nm );
	sys_error( errno );
	exit( 1 );
    }
    return( hnd );
}
