/* 
   Copyright (C) 1990 C van Reewijk, email: dutentb.uucp!reeuwijk

This file is part of GLASS.

GLASS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GLASS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLASS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* file: tmds.c

   template file:      tmds.ct
   datastructure file: ds.ds
   tm version:         27 (Mon Sep 10 17:30:58 METDST 1990)
 */

/* Standard UNIX libraries */
#include <stdio.h>

/* Standard tm library */
#include <tmc.h>

/* Local definitions */
#include "tmdefs.h"

#include "tmds.h"
#include "tmstring.h"
#include "debug.h"
#include "tmglobal.h"

/* ---- start of /users/reeuwijk/esprit/lib/calu.ct ---- */

/* Routines for 'ds'.

   template file:      /users/reeuwijk/esprit/lib/calu.ct
   datastructure file: ds.ds
   tm version:         27 (Mon Sep 10 17:30:58 METDST 1990)
 */

#if defined( __STDC__ ) && __STDC__>0
#else
#define const
#endif

/* If DUMMYCODE is 1, fake code is generated to give lint the right
 * impression of the real code and not choke it with
 * that real code.
 */
#ifndef DUMMYCODE
#define DUMMYCODE 0
#endif

#if DUMMYCODE==0
#ifdef STAT
static long newcnt_constructor_list = 0;
static long frecnt_constructor_list = 0;
static long hitcnt_constructor_list = 0;
static long newcnt_ds_list = 0;
static long frecnt_ds_list = 0;
static long hitcnt_ds_list = 0;
static long newcnt_field_list = 0;
static long frecnt_field_list = 0;
static long hitcnt_field_list = 0;
static long newcnt_string_list = 0;
static long frecnt_string_list = 0;
static long hitcnt_string_list = 0;

static long newcnt_constructor = 0;
static long frecnt_constructor = 0;
static long hitcnt_constructor = 0;
static long newcnt_DsCons = 0;
static long frecnt_DsCons = 0;
static long hitcnt_DsCons = 0;
static long newcnt_DsTuple = 0;
static long frecnt_DsTuple = 0;
static long hitcnt_DsTuple = 0;
static long newcnt_field = 0;
static long frecnt_field = 0;
static long hitcnt_field = 0;
#endif


/* Caching variables.
 *
 * For each type or type list array of CACHESZ elements is maintained that
 * is filled by the fre_<type>() routines. If possible new_<type>() or
 * new_<cons> uses these elements.
 *
 * Although type elements can be shared by all constructors of a type, the
 * cache hit counts are maintained separately.
 *
 * All cacheix_<type> variables maintain the index of the first
 * free element in the array.
 */
#ifndef CACHESZ
#define CACHESZ 5
#endif

#ifdef USECACHE
#undef USECACHE
#endif

#if CACHESZ==0
#else
#define USECACHE
#endif

#ifdef USECACHE
static short int cacheix_constructor_list = 0;
static constructor_list cache_constructor_list[CACHESZ]; 
static short int cacheix_ds_list = 0;
static ds_list cache_ds_list[CACHESZ]; 
static short int cacheix_field_list = 0;
static field_list cache_field_list[CACHESZ]; 
static short int cacheix_string_list = 0;
static string_list cache_string_list[CACHESZ]; 
static short int cacheix_constructor = 0;
static constructor cache_constructor[CACHESZ];
static short int cacheix_ds = 0;
static ds cache_ds[CACHESZ];
static short int cacheix_field = 0;
static field cache_field[CACHESZ];
#endif

static const char tm_srcfile[] = __FILE__;

#ifdef STAT
static const char tm_allocfreed[] = "%-15s: %6ld allocated, %6ld freed, %6ld cache hits.%s\n";
#endif

#ifndef FIRSTROOM
/* Default initial room in arrays. (uneducated guess). */
#define FIRSTROOM 2
#endif

#ifndef FATAL
#define FATAL(msg) tmfatal(tm_srcfile,__LINE__,msg)
#endif

#ifndef WORDBUFSIZE
#define WORDBUFSIZE 100
#endif

/* Possible error strings. */
static const char tm_outofmemory[] = "out of memory";

#ifndef FATALTAG
#define FATALTAG(tag) tmbadtag(tm_srcfile,__LINE__,tag)
#endif

/**************************************************
 *    array room routines                         *
 **************************************************/
#if defined( __STDC__ ) && __STDC__>0
static void room_constructor_list( constructor_list, unsigned int );
static void room_ds_list( ds_list, unsigned int );
static void room_field_list( field_list, unsigned int );
static void room_string_list( string_list, unsigned int );
#endif

/* Announce that you will need room for 'rm' elements in
    constructor_list 'l'.
 */
static void room_constructor_list( l, rm )
 register constructor_list l;
 register unsigned int rm;
{
    if( l->room>rm ){
	return;
    }
    l->arr = (constructor *) realloc( (char *) l->arr, rm * sizeof(*(l->arr)) );
    if( l->arr == (constructor *)0 ){
	FATAL( tm_outofmemory );
    }
    l->room = rm;
}

/* Announce that you will need room for 'rm' elements in
    ds_list 'l'.
 */
static void room_ds_list( l, rm )
 register ds_list l;
 register unsigned int rm;
{
    if( l->room>rm ){
	return;
    }
    l->arr = (ds *) realloc( (char *) l->arr, rm * sizeof(*(l->arr)) );
    if( l->arr == (ds *)0 ){
	FATAL( tm_outofmemory );
    }
    l->room = rm;
}

/* Announce that you will need room for 'rm' elements in
    field_list 'l'.
 */
static void room_field_list( l, rm )
 register field_list l;
 register unsigned int rm;
{
    if( l->room>rm ){
	return;
    }
    l->arr = (field *) realloc( (char *) l->arr, rm * sizeof(*(l->arr)) );
    if( l->arr == (field *)0 ){
	FATAL( tm_outofmemory );
    }
    l->room = rm;
}

/* Announce that you will need room for 'rm' elements in
    string_list 'l'.
 */
static void room_string_list( l, rm )
 register string_list l;
 register unsigned int rm;
{
    if( l->room>rm ){
	return;
    }
    l->arr = (string *) realloc( (char *) l->arr, rm * sizeof(*(l->arr)) );
    if( l->arr == (string *)0 ){
	FATAL( tm_outofmemory );
    }
    l->room = rm;
}

/**************************************************
 *    Allocation routines                         *
 **************************************************/

#if defined( __STDC__ ) && __STDC__>0
#endif

constructor_list new_constructor_list()
{
    constructor_list new;

#ifdef USECACHE
    if( cacheix_constructor_list > 0 ){
	new = cache_constructor_list[--cacheix_constructor_list];
#ifdef STAT
	hitcnt_constructor_list++;
#endif
    }
    else {
#endif
	new = (constructor_list) malloc( sizeof(*new) );
	if( (char *)new == (char *)0 ){
	    FATAL( tm_outofmemory );
	}
#ifdef USECACHE
    }
#endif
    new->sz = 0;
    new->arr = (constructor *) malloc( FIRSTROOM*sizeof( *(new->arr) ) );
    new->room = FIRSTROOM;
    if( (char *)new->arr == (char *)0 ){
	FATAL( tm_outofmemory );
    }
#ifdef STAT
    newcnt_constructor_list++;
#endif
    return new;
}

ds_list new_ds_list()
{
    ds_list new;

#ifdef USECACHE
    if( cacheix_ds_list > 0 ){
	new = cache_ds_list[--cacheix_ds_list];
#ifdef STAT
	hitcnt_ds_list++;
#endif
    }
    else {
#endif
	new = (ds_list) malloc( sizeof(*new) );
	if( (char *)new == (char *)0 ){
	    FATAL( tm_outofmemory );
	}
#ifdef USECACHE
    }
#endif
    new->sz = 0;
    new->arr = (ds *) malloc( FIRSTROOM*sizeof( *(new->arr) ) );
    new->room = FIRSTROOM;
    if( (char *)new->arr == (char *)0 ){
	FATAL( tm_outofmemory );
    }
#ifdef STAT
    newcnt_ds_list++;
#endif
    return new;
}

field_list new_field_list()
{
    field_list new;

#ifdef USECACHE
    if( cacheix_field_list > 0 ){
	new = cache_field_list[--cacheix_field_list];
#ifdef STAT
	hitcnt_field_list++;
#endif
    }
    else {
#endif
	new = (field_list) malloc( sizeof(*new) );
	if( (char *)new == (char *)0 ){
	    FATAL( tm_outofmemory );
	}
#ifdef USECACHE
    }
#endif
    new->sz = 0;
    new->arr = (field *) malloc( FIRSTROOM*sizeof( *(new->arr) ) );
    new->room = FIRSTROOM;
    if( (char *)new->arr == (char *)0 ){
	FATAL( tm_outofmemory );
    }
#ifdef STAT
    newcnt_field_list++;
#endif
    return new;
}

string_list new_string_list()
{
    string_list new;

#ifdef USECACHE
    if( cacheix_string_list > 0 ){
	new = cache_string_list[--cacheix_string_list];
#ifdef STAT
	hitcnt_string_list++;
#endif
    }
    else {
#endif
	new = (string_list) malloc( sizeof(*new) );
	if( (char *)new == (char *)0 ){
	    FATAL( tm_outofmemory );
	}
#ifdef USECACHE
    }
#endif
    new->sz = 0;
    new->arr = (string *) malloc( FIRSTROOM*sizeof( *(new->arr) ) );
    new->room = FIRSTROOM;
    if( (char *)new->arr == (char *)0 ){
	FATAL( tm_outofmemory );
    }
#ifdef STAT
    newcnt_string_list++;
#endif
    return new;
}

constructor new_constructor( p_conname, p_confields )
 string p_conname;
 field_list p_confields;
{
    register constructor new;

#ifdef USECACHE
    if( cacheix_constructor > 0 ){
	new = cache_constructor[--cacheix_constructor];
#ifdef STAT
	hitcnt_constructor++;
#endif
    }
    else {
#endif
	new = (constructor) malloc( sizeof(*new));
	if( (char *)new == (char *)0 ){
	    FATAL( tm_outofmemory );
	}
#ifdef USECACHE
    }
#endif
    new->conname = p_conname;
    new->confields = p_confields;
#ifdef STAT
    newcnt_constructor++;
#endif
    return new;
}

ds new_DsCons( p_ctypename, p_conslist )
 string p_ctypename;
 constructor_list p_conslist;
{
    register ds new;

#ifdef USECACHE
    if( cacheix_ds > 0 ){
	new = cache_ds[--cacheix_ds];
#ifdef STAT
	hitcnt_DsCons++;
#endif
    }
    else {
#endif
	new = (ds) malloc( sizeof(*new));
	if( (char *)new == (char *)0 ){
	    FATAL( tm_outofmemory );
	}
#ifdef USECACHE
    }
#endif
    new->tag = TAGDsCons;
    new->DsCons.ctypename = p_ctypename;
    new->DsCons.conslist = p_conslist;
#ifdef STAT
    newcnt_DsCons++;
#endif
    return new;
}

ds new_DsTuple( p_ttypename, p_tuplefields )
 string p_ttypename;
 field_list p_tuplefields;
{
    register ds new;

#ifdef USECACHE
    if( cacheix_ds > 0 ){
	new = cache_ds[--cacheix_ds];
#ifdef STAT
	hitcnt_DsTuple++;
#endif
    }
    else {
#endif
	new = (ds) malloc( sizeof(*new));
	if( (char *)new == (char *)0 ){
	    FATAL( tm_outofmemory );
	}
#ifdef USECACHE
    }
#endif
    new->tag = TAGDsTuple;
    new->DsTuple.ttypename = p_ttypename;
    new->DsTuple.tuplefields = p_tuplefields;
#ifdef STAT
    newcnt_DsTuple++;
#endif
    return new;
}

field new_field( p_listlev, p_sename, p_setype )
 int p_listlev;
 string p_sename;
 string p_setype;
{
    register field new;

#ifdef USECACHE
    if( cacheix_field > 0 ){
	new = cache_field[--cacheix_field];
#ifdef STAT
	hitcnt_field++;
#endif
    }
    else {
#endif
	new = (field) malloc( sizeof(*new));
	if( (char *)new == (char *)0 ){
	    FATAL( tm_outofmemory );
	}
#ifdef USECACHE
    }
#endif
    new->listlev = p_listlev;
    new->sename = p_sename;
    new->setype = p_setype;
#ifdef STAT
    newcnt_field++;
#endif
    return new;
}

/**************************************************
 *    Freeing routines                            *
 **************************************************/

#if defined( __STDC__ ) && __STDC__>0
static void fre_constructor_list( constructor_list );
static void fre_ds_list( ds_list );
static void fre_field_list( field_list );
static void fre_string_list( string_list );
static void fre_constructor( constructor );
static void fre_ds( ds );
static void fre_field( field );
#endif

/* Free an element 'e' of type 'constructor'. */
static void fre_constructor( e )
 constructor e;
{
    if( e == constructorNIL ){
	return;
    }
#ifdef STAT
    frecnt_constructor++;
#endif
#ifdef USECACHE
    if( cacheix_constructor<CACHESZ ){
	cache_constructor[cacheix_constructor++] = e;
	return;
    }
#endif
    free( (char *) e );
}

/* Free an element 'e' of type 'ds'. */
static void fre_ds( e )
 ds e;
{
    if( e == dsNIL ){
	return;
    }
#ifdef STAT
    switch( e->tag ){
	case TAGDsCons:
	    frecnt_DsCons++;
	    break;

	case TAGDsTuple:
	    frecnt_DsTuple++;
	    break;

	default:
	    FATALTAG( (int) e->tag );
    }
#endif
#ifdef USECACHE
    if( cacheix_ds<CACHESZ ){
	cache_ds[cacheix_ds++] = e;
	return;
    }
#endif
    free( (char *) e );
}

/* Free an element 'e' of type 'field'. */
static void fre_field( e )
 field e;
{
    if( e == fieldNIL ){
	return;
    }
#ifdef STAT
    frecnt_field++;
#endif
#ifdef USECACHE
    if( cacheix_field<CACHESZ ){
	cache_field[cacheix_field++] = e;
	return;
    }
#endif
    free( (char *) e );
}

/* Free a list of constructor elements 'l'. */
static void fre_constructor_list( l )
 constructor_list l;
{
    if( l == constructor_listNIL ){
	return;
    }
#ifdef STAT
    frecnt_constructor_list++;
#endif
    free( (char *) l->arr );
#ifdef USECACHE
    if( cacheix_constructor_list<CACHESZ ){
	cache_constructor_list[cacheix_constructor_list++] = l;
	return;
    }
#endif
    free( (char *) l );
}

/* Free a list of ds elements 'l'. */
static void fre_ds_list( l )
 ds_list l;
{
    if( l == ds_listNIL ){
	return;
    }
#ifdef STAT
    frecnt_ds_list++;
#endif
    free( (char *) l->arr );
#ifdef USECACHE
    if( cacheix_ds_list<CACHESZ ){
	cache_ds_list[cacheix_ds_list++] = l;
	return;
    }
#endif
    free( (char *) l );
}

/* Free a list of field elements 'l'. */
static void fre_field_list( l )
 field_list l;
{
    if( l == field_listNIL ){
	return;
    }
#ifdef STAT
    frecnt_field_list++;
#endif
    free( (char *) l->arr );
#ifdef USECACHE
    if( cacheix_field_list<CACHESZ ){
	cache_field_list[cacheix_field_list++] = l;
	return;
    }
#endif
    free( (char *) l );
}

/* Free a list of string elements 'l'. */
static void fre_string_list( l )
 string_list l;
{
    if( l == string_listNIL ){
	return;
    }
#ifdef STAT
    frecnt_string_list++;
#endif
    free( (char *) l->arr );
#ifdef USECACHE
    if( cacheix_string_list<CACHESZ ){
	cache_string_list[cacheix_string_list++] = l;
	return;
    }
#endif
    free( (char *) l );
}

/**************************************************
 *    Append routines                             *
 **************************************************/

#if defined( __STDC__ ) && __STDC__>0
#endif

/* Append a ds element 'e' to list 'l'. */
void app_ds_list( l, e )
 ds_list l;
 ds e;
{
    if( l->sz >= l->room ){
	room_ds_list( l, (l->sz)+(l->sz) );
    }
    l->arr[l->sz] = e;
    l->sz++;
}

/* Append a constructor element 'e' to list 'l'. */
void app_constructor_list( l, e )
 constructor_list l;
 constructor e;
{
    if( l->sz >= l->room ){
	room_constructor_list( l, (l->sz)+(l->sz) );
    }
    l->arr[l->sz] = e;
    l->sz++;
}

/* Append a field element 'e' to list 'l'. */
void app_field_list( l, e )
 field_list l;
 field e;
{
    if( l->sz >= l->room ){
	room_field_list( l, (l->sz)+(l->sz) );
    }
    l->arr[l->sz] = e;
    l->sz++;
}

/* Append a string element 'e' to list 'l'. */
void app_string_list( l, e )
 string_list l;
 string e;
{
    if( l->sz >= l->room ){
	room_string_list( l, (l->sz)+(l->sz) );
    }
    l->arr[l->sz] = e;
    l->sz++;
}

/**************************************************
 *    Real append routines                        *
 **************************************************/

#if defined( __STDC__ ) && __STDC__>0
#endif

/**************************************************
 *    ins_<type>_list routines                    *
 **************************************************/

#if defined( __STDC__ ) && __STDC__>0
#endif

/**************************************************
 *    Concatenate routines                        *
 **************************************************/

#if defined( __STDC__ ) && __STDC__>0
#endif

/**********************************************
 *    Real concatenate routines               *
 **********************************************/

#if defined( __STDC__ ) && __STDC__>0
#endif

/**************************************************
 *    Recursive freeing routines                  *
 **************************************************/

#if defined( __STDC__ ) && __STDC__>0
static void rfre_ds( ds );
static void rfre_constructor( constructor );
static void rfre_field( field );
static void rfre_constructor_list( constructor_list );
static void rfre_field_list( field_list );
#endif

static void rfre_ds();
static void rfre_constructor();
static void rfre_field();
static void rfre_constructor_list();
static void rfre_field_list();

/* Recursively free an element 'e' of type 'ds'
   and all elements in it.
 */
static void rfre_ds( e )
 ds e;
{
    if( e == dsNIL ){
	return;
    }
    switch( e->tag ){
	case TAGDsCons:
	    rfre_string( e->DsCons.ctypename );
	    rfre_constructor_list( e->DsCons.conslist );
	    break;

	case TAGDsTuple:
	    rfre_string( e->DsTuple.ttypename );
	    rfre_field_list( e->DsTuple.tuplefields );
	    break;

	default:
	    FATALTAG( (int) e->tag );
    }
    fre_ds( e );
}

/* Recursively free an element 'e' of type 'constructor'
   and all elements in it.
 */
static void rfre_constructor( e )
 constructor e;
{
    if( e == constructorNIL ){
	return;
    }
    rfre_string( e->conname );
    rfre_field_list( e->confields );
    fre_constructor( e );
}

/* Recursively free an element 'e' of type 'field'
   and all elements in it.
 */
static void rfre_field( e )
 field e;
{
    if( e == fieldNIL ){
	return;
    }
    rfre_int( e->listlev );
    rfre_string( e->sename );
    rfre_string( e->setype );
    fre_field( e );
}

/* Recursively free a list of elements 'e' of type constructor. */
static void rfre_constructor_list( e )
 constructor_list e;
{
    unsigned int ix;

    if( e == constructor_listNIL ){
	return;
    }
    for( ix=0; ix<e->sz; ix++ ) rfre_constructor( e->arr[ix] );
    fre_constructor_list( e );
}

/* Recursively free a list of elements 'e' of type ds. */
void rfre_ds_list( e )
 ds_list e;
{
    unsigned int ix;

    if( e == ds_listNIL ){
	return;
    }
    for( ix=0; ix<e->sz; ix++ ) rfre_ds( e->arr[ix] );
    fre_ds_list( e );
}

/* Recursively free a list of elements 'e' of type field. */
static void rfre_field_list( e )
 field_list e;
{
    unsigned int ix;

    if( e == field_listNIL ){
	return;
    }
    for( ix=0; ix<e->sz; ix++ ) rfre_field( e->arr[ix] );
    fre_field_list( e );
}

/* Recursively free a list of elements 'e' of type string. */
void rfre_string_list( e )
 string_list e;
{
    unsigned int ix;

    if( e == string_listNIL ){
	return;
    }
    for( ix=0; ix<e->sz; ix++ ) rfre_string( e->arr[ix] );
    fre_string_list( e );
}

/**************************************************
 *    print_<type> and print_<type>_list routines *
 **************************************************/

#if defined( __STDC__ ) && __STDC__>0
static void print_ds( ds );
static void print_constructor( constructor );
static void print_field( field );
static void print_constructor_list( constructor_list );
static void print_field_list( field_list );
#endif

static void print_ds();
static void print_constructor();
static void print_field();
static void print_constructor_list();
static void print_field_list();

/* Print an element 't' of type 'ds'
   using print optimizer.
 */
static void print_ds( t )
 ds t;
{
    if( t == dsNIL ){
	printword( "@" );
	return;
    }
    opencons();
    switch( t->tag ){
	case TAGDsCons:
	    printword( "DsCons" );
	    print_string( t->DsCons.ctypename );
	    print_constructor_list( t->DsCons.conslist );
	    break;

	case TAGDsTuple:
	    printword( "DsTuple" );
	    print_string( t->DsTuple.ttypename );
	    print_field_list( t->DsTuple.tuplefields );
	    break;

	default:
	    FATALTAG( (int) t->tag );
    }
    closecons();
}

/* Print an element 't' of type 'constructor'
   using print optimizer.
 */
static void print_constructor( t )
 constructor t;
{
    if( t == constructorNIL ){
	printword( "@" );
	return;
    }
    opentuple();
    print_string( t->conname );
    print_field_list( t->confields );
    closetuple();
}

/* Print an element 't' of type 'field'
   using print optimizer.
 */
static void print_field( t )
 field t;
{
    if( t == fieldNIL ){
	printword( "@" );
	return;
    }
    opentuple();
    print_int( t->listlev );
    print_string( t->sename );
    print_string( t->setype );
    closetuple();
}

/* Print a list of elements 'l' of type 'constructor'
   using print optimizer.
 */
static void print_constructor_list( l )
 constructor_list l;
{
    unsigned int ix;

    if( l == constructor_listNIL ){
	printword( "@" );
	return;
    }
    openlist();
    for( ix=0; ix<l->sz; ix++ ) print_constructor( l->arr[ix] );
    closelist();
}

/* Print a list of elements 'l' of type 'ds'
   using print optimizer.
 */
void print_ds_list( l )
 ds_list l;
{
    unsigned int ix;

    if( l == ds_listNIL ){
	printword( "@" );
	return;
    }
    openlist();
    for( ix=0; ix<l->sz; ix++ ) print_ds( l->arr[ix] );
    closelist();
}

/* Print a list of elements 'l' of type 'field'
   using print optimizer.
 */
static void print_field_list( l )
 field_list l;
{
    unsigned int ix;

    if( l == field_listNIL ){
	printword( "@" );
	return;
    }
    openlist();
    for( ix=0; ix<l->sz; ix++ ) print_field( l->arr[ix] );
    closelist();
}

/***************************************************
 *   fprint_<type> and fprint_<type>_list routines *
 ***************************************************/

#if defined( __STDC__ ) && __STDC__>0
#endif


/**************************************************
 *    Duplication routines                        *
 **************************************************/

#if defined( __STDC__ ) && __STDC__>0
#endif


/**************************************************
 *    Comparison routines.                        *
 **************************************************/

#if defined( __STDC__ ) && __STDC__>0
#endif


/**************************************************
 *    Scan routines.                              *
 **************************************************/

#if defined( __STDC__ ) && __STDC__>0
#endif


/**************************************************
 *    del_<type>_list routines                    *
 **************************************************/

#if defined( __STDC__ ) && __STDC__>0
#endif

/************************************************************
*    Miscellaneous routines                                 *
************************************************************/
/* Flush the allocation caches. */
void flush_ds()
{
#ifdef USECACHE
    register short int ix;

    for( ix=0; ix<cacheix_constructor_list; ix++ ){
	free( (char *) cache_constructor_list[ix] );
    }
    cacheix_constructor_list = 0;
    for( ix=0; ix<cacheix_ds_list; ix++ ){
	free( (char *) cache_ds_list[ix] );
    }
    cacheix_ds_list = 0;
    for( ix=0; ix<cacheix_field_list; ix++ ){
	free( (char *) cache_field_list[ix] );
    }
    cacheix_field_list = 0;
    for( ix=0; ix<cacheix_string_list; ix++ ){
	free( (char *) cache_string_list[ix] );
    }
    cacheix_string_list = 0;
    for( ix=0; ix<cacheix_constructor; ix++ ){
	free( (char *) cache_constructor[ix] );
    }
    cacheix_constructor = 0;
    for( ix=0; ix<cacheix_ds; ix++ ){
	free( (char *) cache_ds[ix] );
    }
    cacheix_ds = 0;
    for( ix=0; ix<cacheix_field; ix++ ){
	free( (char *) cache_field[ix] );
    }
    cacheix_field = 0;
#endif
}

/* Print allocation and freeing statistics to file 'f'. */
void stat_ds( f )
 FILE *f;
{
#ifdef STAT
	fprintf( f, tm_allocfreed, "[constructor]", newcnt_constructor_list, frecnt_constructor_list, hitcnt_constructor_list, ((newcnt_constructor_list==frecnt_constructor_list)? "": "<-") );
	fprintf( f, tm_allocfreed, "[ds]", newcnt_ds_list, frecnt_ds_list, hitcnt_ds_list, ((newcnt_ds_list==frecnt_ds_list)? "": "<-") );
	fprintf( f, tm_allocfreed, "[field]", newcnt_field_list, frecnt_field_list, hitcnt_field_list, ((newcnt_field_list==frecnt_field_list)? "": "<-") );
	fprintf( f, tm_allocfreed, "[string]", newcnt_string_list, frecnt_string_list, hitcnt_string_list, ((newcnt_string_list==frecnt_string_list)? "": "<-") );
	fprintf(f,tm_allocfreed,"constructor",newcnt_constructor,frecnt_constructor,hitcnt_constructor,((newcnt_constructor==frecnt_constructor)? "": "<-") );
	fprintf(f,tm_allocfreed,"DsCons",newcnt_DsCons,frecnt_DsCons,hitcnt_DsCons,((newcnt_DsCons==frecnt_DsCons)? "": "<-") );
	fprintf(f,tm_allocfreed,"DsTuple",newcnt_DsTuple,frecnt_DsTuple,hitcnt_DsTuple,((newcnt_DsTuple==frecnt_DsTuple)? "": "<-") );
	fprintf(f,tm_allocfreed,"field",newcnt_field,frecnt_field,hitcnt_field,((newcnt_field==frecnt_field)? "": "<-") );
#else
	f = f; /* to prevent 'f unused' from compiler and lint */
#endif
}

#else
/* WARNING: The code below is dummy code to fool lint. */

/* new_<cons> and new_<type> routines */
ds new_DsCons( p_ctypename, p_conslist )
 string p_ctypename;
 constructor_list p_conslist;
{
    p_ctypename = p_ctypename;
    p_conslist = p_conslist;
    return (ds)0;
}

ds new_DsTuple( p_ttypename, p_tuplefields )
 string p_ttypename;
 field_list p_tuplefields;
{
    p_ttypename = p_ttypename;
    p_tuplefields = p_tuplefields;
    return (ds)0;
}


constructor new_constructor( p_conname, p_confields )
 string p_conname;
 field_list p_confields;
{
    p_conname = p_conname;
    p_confields = p_confields;
    return (constructor)0;
}
field new_field( p_listlev, p_sename, p_setype )
 int p_listlev;
 string p_sename;
 string p_setype;
{
    p_listlev = p_listlev;
    p_sename = p_sename;
    p_setype = p_setype;
    return (field)0;
}
ds_list new_ds_list(){ return (ds_list)0; }
constructor_list new_constructor_list(){ return (constructor_list)0; }
field_list new_field_list(){ return (field_list)0; }
string_list new_string_list(){ return (string_list)0; }

/* room_<type>_list() routines */

/* app_<type>_list() routines */
void app_ds_list( l, e )
 ds_list l;
 ds e;
{
    l = l;
    e = e;
}
void app_constructor_list( l, e )
 constructor_list l;
 constructor e;
{
    l = l;
    e = e;
}
void app_field_list( l, e )
 field_list l;
 field e;
{
    l = l;
    e = e;
}
void app_string_list( l, e )
 string_list l;
 string e;
{
    l = l;
    e = e;
}

/* append_<type>_list() routines */

/* ins_<type>_list() routines */

/* del_<type>_list() routines */

/* conc_<type>_list() routines */

/* concat_<type>_list() routines */

/* fre_<type>_list() routines */

/* rfre_<type>_list() routines */
void rfre_ds_list( l ) ds_list l; { l=l; }
void rfre_string_list( l ) string_list l; { l=l; }

/* print_<type>() routines */
void print_ds_list( l ) ds_list l; { l=l; }

/* fprint_<type>() routines */

/* rdup_<type>() routines */

/* fscan_<type>() routines */

/* cmp_<type>() routines */

/* misc. functions */
void flush_ds(){}
void stat_ds( f ) FILE *f; { f=f; }
#endif
/* ---- end of /users/reeuwijk/esprit/lib/calu.ct ---- */
