/* file: cvr.h
 *
 * declaration of routines in cvr library.
 */

#ifndef _GOTLIBCVR

/* Storage for a symbol string */
struct _cvr_sym {
   struct _cvr_sym *next; /* next in list */
   char *symstr;           /* pointer to the string */
   int priority;	   /* the higher, the more important */
};

typedef struct _cvr_sym *symbol;

#define symbolNIL (symbol)0
#define rfre_symbol(s)
#define fre_symbol(s)
#define rdup_symbol(s) (s)
#define symbolstr(s) ((s)->symstr)
#define setprior(s,n) (s)->priority=(n)
#define getprior(s) ((s)->priority)
#define cmp_symbol(a,b) (a==b?0:(a<b?-1:1))
#define print_symbol(s) print_string(symbolstr(s))
#define fprint_symbol(f,s) fprint_string(f,symbolstr(s))
extern symbol addsymbol();
extern int fscan_symbol();
extern symbol findsymbol();
extern symbol gensymbol();
extern void initsymbol();
extern void flushsymbol();

extern char *ckmalloc();
extern char *ckcalloc();
extern char *ckrealloc();

/* structure to describe debugging flags */
typedef struct _cvr_db_flags {
    char flagchar;       /* char to switch the flag on */
    int *flagadr;        /* pointer to the flag */
    char *flagdescr;     /* description string */
} dbflag;

#define dbflagNIL (dbflag *)0
extern dbflag *finddbflag();
extern void setdbflags();
extern void helpdbflags();
#define _GOTLIBCVR 1
#endif
