
/*

    This file is a part of the GLASS source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  S.J. Klaver, R Doesborg
              email: simon@sagan.nl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include <stdio.h>
#include <tmc.h>
#include <curses.h>
#include "envir.h"
#include "menuds.h"
#include "actionds.h"
#include "dprocs.h"
#include "gconst.h"
#include "handleparms.h"
#include "globalvars.h"

extern char *malloc();
extern int free();
extern char *strcpy();
extern char *strcat();

int execute_action (gl, act)
  gluefile gl;
  int act;
{
   char *mess;
   char *volname, *dirname,
        *glfilename, *gldir;
   char *intstring;
   int key;
   int err = 0;

   switch (act) {
     case 1:
       handle_parms (gl, 14, PARMLINE);
       dirname = get_parval(gl, 14, "DIR");
       volname = get_parval(gl, 14, "FILNAM");
       intstring = get_parval(gl, 14, "OFFSET");
       mess = malloc(strlen(volname) + strlen(dirname)
                     + strlen(intstring) + 10);
       sprintf(mess, "vi +%s %s/%s", intstring, dirname, volname);
       endwin();
       system(mess);
       free(mess);
       /* doupdate(); */
       break;
     case 2:
       mess = malloc(100);
       glfilename = get_parval(gl, 11, "FILNAM");
       gldir = get_parval(gl, 11, "DIR");
       sprintf(mess, "%s/bin/simplex %s %s/%s", MAINDIR, 
                      MAINDIR, gldir, glfilename);
       endwin();
       printf ("\n\n");
       system(mess);
       printf ("Press <return> to continue ...\n"); 
       key = wgetch(stdscr);
       wrefresh(curscr);
       /* doupdate(); */
       free(mess);
       break;
     case 3:
       mess = malloc(100);
       glfilename = get_parval(gl, 11, "FILNAM");
       gldir = get_parval(gl, 11, "DIR");
       sprintf(mess, "%s/bin/multiplex %s %s/%s", MAINDIR, 
                      MAINDIR, gldir, glfilename);
       endwin();
       printf ("\n\n");
       system(mess);
       printf ("Press <return> to continue ...\n"); 
       key = wgetch(stdscr);
       wrefresh(curscr);
       /* doupdate(); */
       free(mess);
       break;
     case 5: 
       handle_parms (gl, 12, PARMLINE);
       refresh();
       break;
     case 7: 
       handle_parms (gl, 11, PARMLINE);
       refresh();
       dirname = get_parval(gl, 11, "DIR");
       volname = get_parval(gl, 11, "FILNAM");
       mess = malloc(strlen(dirname) + strlen(volname) + strlen(MAINDIR)
                     + strlen("/bin/glass ") + 2);
       sprintf(mess, "glass %s/%s", dirname, volname);
       endwin();
       printf ("\n\n");
       system(mess);

       printf ("Press <return> to continue ...\n"); 
       key = wgetch(stdscr);
       wrefresh(curscr);
       /* doupdate(); */
       free(mess);
       break;
     case 20:
       mess = malloc(40);
       volname = get_parval(gl, 12, "CURVOL");
       sprintf(mess, "Default volume: %s\n", volname);
       err = wdisplay_string(stdscr, mess, 15, 10, NORMAL);
       free(mess);
       wdelayed_delete(stdscr, 15);
       break;
     default:
       mess = malloc(50);
       sprintf(mess, "Action %d was chosen (not implemented yet)", act);
       err = wdisplay_string(stdscr, mess, 15, 10, BOLD);
       free(mess);
       wdelayed_delete(stdscr, 23);
       wdelayed_delete(stdscr, 20);
       wdelayed_delete(stdscr, 15);
       break;
   }
   return(err);
}

int execute_command (gl, cstring)
  gluefile gl;
  string cstring;
{
  int err = 0;
  int key;
  char *comm;

  endwin(); 
  printf("\n\n");
  comm = malloc(strlen(cstring)+6);
  if (cshell) {
    strcpy(comm, "csh ");
    strcat(comm, cstring);
  }
  else
    strcpy(comm, cstring);
  err = system (comm);

  wmove(curscr, 22, 1);
  fprintf(stderr, "Press <return> to continue ..");
  getchar (); 

  /* doupdate(); */
  wrefresh (curscr);  
   
  return(err);
}
