
/*

    This file is a part of the GLASS source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  S.J. Klaver, R Doesborg
              email: simon@sagan.nl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include <stdio.h>
#include <tmc.h>
#include <curses.h>
#include "envir.h"
#include "gconst.h"
#include "menuds.h"
#include "handlemenu.h"
#include "checkglue.h"
#include "globalvars.h"
#include "tctypes.h"
#include "tc.h"

/* The following two declarations suppress warning messages */
extern char *malloc();
extern char *strcpy();
enum { YES = 1, NO = 0};

/********************************************************/
/* Read_options reads and checks command line options   */
/********************************************************/
int read_options (argc, argv)
  int argc;
  char *argv[];
{
  char *hargv;
  int err = 0;

  /* Before reading the options, initialize all globals */
  cshell = NO;
  inputfilename = NULL;
  outputfilename = NULL;
  mainmenuid = 0;
  mainparid = 0;

  argv++;                     /* skip the program name */
  argc--;
  while (argc>0) {
    if (**argv != '-') {
      printf("Illegal argument: %s\n", *argv);
      printf("Use glue -x for help.\n");
      err=1;
    }
    else {
      hargv = *argv;
      hargv++;             /* skip the character '-' */
      switch (*hargv) {
        case 'i':
          argv++;
          argc--;
          if (argc>0) {
            inputfilename = malloc(strlen(*argv)+1);
            strcpy(inputfilename, *argv);
          }
          else {
            printf("Not enough arguments\n");
            err = 1;
          }
          break;
        case 'o':
          argv++;
          argc--;
          if (argc>0) {
            outputfilename = malloc(strlen(*argv)+1);
            strcpy(outputfilename, *argv);
          }
          else {
            printf("Not enough arguments\n");
            err = 1;
          }
          break;
        case 'c':
          cshell = YES;
          break;
        case 'm':
          hargv++;
          if (*hargv == (char)0) {
            argv++;
            argc--;
            hargv = *argv;
          }
          mainmenuid = atoi(hargv);
          break;
        case 'p':
          hargv++;
          if (*hargv == (char)0) {
            argv++;
            argc--;
            hargv = *argv;
          }
          mainparid = atoi(hargv);
          break;
        case 'x':
          printf("Usage:  glue <options>\n\n");
          printf("Possible options are:\n\n");
          printf("   -i file : use file as menu data file.\n");
          printf("   -m n    : start with menu n as main menu.\n");
          printf("   -p n    : only ask for parameter set n.\n");
          printf("   -c      : use cshell for shell escapes.\n");
          printf("   -o file : use file as parameter output file.\n");
          printf("   -x      : this help information.\n");
          err = 1;
          break;
        default:
          printf("The option -%c is not defined\n", *hargv);
          printf("Usage:  glue <options>\n\n");
          printf("Possible options are:\n\n");
          printf("   -i file : use file as menu data file.\n");
          printf("   -m n    : start with menu n as main menu.\n");
          printf("   -p n    : only ask for parameter set n.\n");
          printf("   -c      : use cshell for shell escapes.\n");
          printf("   -o file : use file as parameter output file.\n");
          printf("   -x      : this help information.\n");
          err = 1;
          break;
      }
    }
    argv++;
    argc--;
  }
  return(err);
}


/**********************************************************/
/*                                                        */
/* GLUE main program.                                     */
/*                                                        */
/* Allowed parameters:                                    */
/*  -i infile   : input file                              */
/*  -o outfile  : parameter settings output file          */
/*  -c          : use csh for parameter setting syntax    */
/*              : and for shell escapes                   */
/*  -m n        : n is number of main menu                */
/*  -p n        : n is number of main parameter set       */
/*                                                        */
/**********************************************************/

int main (argc, argv)
  int argc;
  char *argv[];
{
  gluefile gl;
  FILE *infile;
  char *str;

  /* termcap variables               */
  char *termtype, *bp, *termcapbuf;
  int res;
  keystrings ks;
  /* termcap variables end           */
  /* ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ */
  
  str = (char *)malloc(100);
  sprintf(str, "MAINDIR=%s", MAINDIR);
  putenv(str);

  /* Reading command line options         */
  if (read_options(argc, argv)) exit(1);   
  /* Command line options read            */
  /* ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ */

  /* The following reads the menus input file. Default file name */
  /* is "glass-menu.dat". This can be overrule with glue -m            */

  if (inputfilename==NULL) {
    char filename[256];
    strcpy(filename,LIBDIR);
    strcat(filename,"/glass-menu.dat");
    infile = fopen(filename, "r");
    if (infile == NULL) {
      fprintf(stderr,"glue: %s: No such file\n",filename);
      exit(1);
    }
  }
  else
    infile = fopen(inputfilename, "r");
  if (infile != NULL) {
    if (fscan_gluefile(infile, &gl) == 1) {
      printf("\nGLUE-E, Errors during compilation of menu description\n");
      exit(1);
    }
  }
  else {
    printf("GLUE-E, Can't find file %s", 
                         (inputfilename==NULL) ? "glass-menu.dat" : inputfilename);
    exit(1);
  }
  fclose(infile);
  /* Menus read                                               */
  /* ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ */

  if (check_glueds (gl, mainparid)) {
    printf("\nGLUE-E, Data structure inconsistency\n");
    printf("GLUE-E, Check ");
    if (inputfilename==NULL)
      printf("glass-menu.dat\n");
    else
      printf(inputfilename);
    exit(1);
  }
  /* Menus read and checked                                   */
  /* ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ */

  /* termcap routines                                         */
  /* The following code reads the terminal type and reads     */
  /* terminal dependent information from the termcap database */

  termtype = (char *) getenv ("TERM");
  /* printf ("Terminal type is %s\n", termtype); */
  bp = (char*) malloc (1024);
  /* the bp value should be retained throughout the program   */
  res = tgetent (bp, termtype);   
  switch (res) {
    case -1: printf ("Termcap file cannot be opened.\n"); break;
    case 0:  printf ("No entry for this terminal.\n"); break;
    case 1: ;  /* printf ("Termcap file opened.\n"); */
  }
  termcapbuf = (char*) malloc (1000); 
  /* strings returned by termcap routines go to this buffer   */
  initkeystrings (&ks, &termcapbuf);
  initattrstrings (&termcapbuf);
  /* End of termcap code                                      */
  /* ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ */

  if (mainparid == 0) {
    parms_to_envir(gl);        /* put all defaults in environment */
    start_menu(gl, mainmenuid);
  }
  else {
    init_screen();
    handle_parms (gl, mainparid, PARMLINEPAR);
    if (outputfilename == NULL)
      parms_to_file (gl, mainparid, "setpars", cshell); 
    else 
      parms_to_file (gl, mainparid, outputfilename, cshell); 
    endwin();
  }
  exit(0);
}
