%TEX
\documentstyle[11pt]{article}
\author{Eric Voss\\
University of Nijmegen. } 
\title{Tm Eag Show}
\parskip 0pt plus 1pt
\parindent 0pt
%

meta data structure description (DET+rules+N+list rules+N+Constants>):
  layout,
  rules(list rules>,rules>).

rules (x+xx>,r+rr>):
   rule (x>,r>), ->,";", layout, rules (xx>, rr>);
rules (empty>,empty>):.

rule (x>,N+alts+N>):
  identifier(left hand side>), layout,
  "::=", layout, ->,
  alts (>"walk "+left hand side,x>,alts>);
rule (x>,N+alts+N>):
  identifier(left hand side>), layout,
  "==", layout,
  synomym (>"walk "+left hand side,x>,alts>).

synomym (>l, x>, l+ " (>i,>"+struct+",\n\t\t"+show+">):\n\t"+ walk+".\n\n">):
  member (x>,struct>,show>,walk>).

alts (>l, x+xx>,alt+more alts>):
   alt (>l,x>,alt>), more alts(>l,xx>,more alts>).

more alts (>l, x+xx>,";\n"+alt+ more  alts>):
  "|", layout, alt (>l, x>,alt>), ->,
   more alts(>l,xx>,more alts>);
more alts (>l, empty>,".\n\n">):
  . 

alt (>l, x+xx>, 
     l+"(>i,> "+ constructor+" * "+struct+ more  struct +",\n\t\t"+#
     "i+\"("+constructor+quote+"+"+show+ more  show +"+\")\">): "+cut+"\n\t"+ 
       walk + more  walk>):
  identifier(constructor>),not equal (>constructor,>"i"),layout, 
  member (x>,struct>,show>,walk>), ->,
  more members (xx>,more  struct >, more show>,more walk>), 
  not last (>"->,",cut>);
alt (>l, empty>, 
         l+ " (>i,> "+constructor+", \" ("+ constructor+")\">):"+cut>):
  identifier(constructor>),not equal (>constructor,>"i"),layout, 
  not last (>"->",cut>).

not last (>c,c>): ? "|", ->;
not last (>c,"">):.
 
member (x>,struct>, show>,walk+"(>i+I,>"+struct+","+show+">)" >):
     identifier (struct>),not equal (>struct,>"i"),layout, 
     where (>"show "+struct, show>),
     ":", layout,
     type (x>,walk>);
member (x>,struct>, show>, walk>):
     "(", layout, tupple els (x>, struct>, show>, walk>) ,
     ")", layout.

tupple els ( x + xx + tupple def>, tupple name>, tupple show>,tupple walk>):
     member (x>, s>, t>, w>),
     more tupple els (xx>, ss>, tt>,ww>),
     tupple code (>s+ss,>t+tt,>w+ww,tupple def>, tupple name>, tupple show>, 
                          tupple walk>).

more tupple els (x +xx>, " * "+s + ss>, "+\", \"+"+t+tt>,",\n\t"+w + ww>):
    "," , layout, ->,
    member (x>, s>, t>,w>),
    more tupple els (xx>, ss>, tt>,ww>);
more tupple els (empty>, empty>,empty>, empty>):.


tupple code (>s,>t,>w, tupple def>, n>, show>, tupple walk>):
     some name (n>),
     where (>"walk "+n, walk>),
     where (>"show "+n, show>),
     where ( > walk +"(>i,> TUPPLE * "+s + ",\" (\"+"+t+"+\" ) \">):\n\t"+ 
                 w+  ".\n\n", tupple def>),
     where (>walk +"(>i,>"+n+","+show+">)", tupple walk>).
    

more members (x+xx>," * "+s + ss >, "+"+t+tt>,",\n\t"+w+ww>):
    member (x>,s>,t>,w>), ->,
    more members (xx>,ss>,tt>,ww>);
more members (empty>,empty>,empty>,empty>):.


type (empty>,type+" ">):
   identifier (tp>), layout, ->,
   where (>"walk "+tp, type>);
type (x>,type list>):
   "[",layout,
    identifier(tp>), layout,
    where (>"walk "+tp, type>),
    where (>type + " list ", type list>),
    where (>type + " els ", type els>),
    where (>"show "+tp , show>),
    where (>show+" els " , show els>),
   "]",layout,
    list code (>type,>type list, >type els, >show, >show els, x>).

list code  (> type, >type list, >type els, >show, >show els,list code >):
     excludes (>type list,>empty), ->,
     add to (>type list,>empty,>empty),
     where ( >"more "+type els, more type els>),
     where ( > type list+"(>i, >LIST * "+type+"*"+type els+ ", i+\"[\"+"+
                                   show+"+"+show els+"+i+\"]\">):\n\t"+# 
                   type+"(>i+I+I,>"+type+","+show+">),->,\n\t"+#
                  type els+"(>i,>"+type els+","+show els+  ">);\n\n"+
              type list +"(>i,>LIST*empty,i+\"[]\">):.\n\n"+

       type els +"(>i,>"+type+" * "+type els+",\",\"+"+show+"+"+show els+">):\n\t"+#
                type+"(>i+I+I,>"+type+","+show+">),->,\n\t"+#
                type els+ "(>i,>"+type els+ ","+show els+">);\n"+
       type els +"(>i,>empty,empty>):.\n\n", list code>);
list code  (> type, >type list, >type els, >show, >show els,empty >):.

#
Open symbol  :: "\t\"(\", layout".
Close symbol :: ",\n\t\")\", layout".
N            :: nlcr.

Constants :: Inum+Fnum+String+Bool+Symbol.

Inum   :: "\nwalk i num (>i,>I NUM * i num,\" \"+i num>) : .\n\n".

Fnum   :: "walk f num (>i,> F NUM *f num,\" \"+f num>) : .\n\n".


String   :: "walk string (>i,> STRING * string,\" \"+ quote+string+quote>) : .\n\n".

Symbol  :: "walk symbol (>i,>symbol,string>) : walk string (>i,>symbol,string>).\n\n".

Bool   :: "walk bool (>i,> BOOL * T or F , T or F>) : .\n\n".


DET  :: "#-d \n".

layout:
    !\n\t !*  (ig>),
    comment.

comment:
    "||", ->,
    ^!\n! * (ign>), layout;
comment: .
