
%TEX
\documentstyle[11pt]{article}
\author{Eric Voss\\
University of Nijmegen. } 
\title{Tm Eag Scan}
\parskip 0pt plus 1pt
\parindent 0pt
%

meta data structure description (OPT+r+rules+N+lr+list rules+N+Constants>):
  layout,
  first rule (lr>,r>), ";", layout,
  rules(list rules>,rules>).

rules (x+xx>,r+rr>):
   rule (x>,r>), ->,";", layout, rules (xx>, rr>);
rules (empty>,empty>):.

rule (x>,N+closed code +alts+N>):
  identifier(left hand side>), layout,
  "::=", layout, ->,
  alts (>"scan "+left hand side,x>,alts>),
       closed clause code (>"scan "+left hand side, closed code>);
rule (x>,N+alts+N>):
  identifier(left hand side>), layout,
  "==", layout,
  synomym (>"scan "+left hand side,x>,alts>).

synomym (>l, x>, l+ " ("+struct+">):\n\t"+ scan+".\n\n">):
  member (x>,struct>,scan>).

first rule (x>,N+alts+N>):
  identifier(left hand side>), layout,
  "==", layout,
  first synomym (>"scan "+left hand side,x>,alts>).

first synomym (>l, x>, l+ " ("+"walk "+struct+">):\n\tlayout,\n\t"+ scan+",\n\t"+show+".\n\n">):
  ?showmember (show>),
  member (x>,struct>,scan>).


show member  ("walk "+tp+ " list (>N,>"+a+",walk "+a+">)">):
    identifier (a>), layout,":",layout,
   "[",layout,
    identifier(tp>), layout, "]",layout.

alts (>l, x+xx>,alt+more alts>):
   alt (>l,x>,alt>), more alts(>l,xx>,more alts>).

closed clause code (>l,
         l+ " ( out>):\n   " + 
         Open symbol+ ", ->,"+# 
         l+ " ( out>)" + 
         Close symbol+";\n">):.

more alts (>l, x+xx>,", ->;\n"+alt+ more  alts>):
  "|", layout, alt (>l, x>,alt>), ->,
   more alts(>l,xx>,more alts>);
more alts (>l, empty>,".\n\n">):
  . 

alt (>l, x+xx>, 
         l+ " ( "+ constructor+" * "+struct+ more  struct +">):\n\t" + 
         quote+constructor+quote+", layout,\n\t"+
         scan + more  scan >):
  identifier(constructor>),layout, 
  member (x>,struct>,scan>), ->,
  more members (xx>,more  struct >, more scan>);
alt (>l, empty>, 
         l+ " ( "+ constructor+">):\n\t" + 
         quote+constructor+quote+", layout">):
  identifier(constructor>),layout.

member (x>,name>, type+"("+name+">)" >):
     identifier (name>),->,layout, 
     ":", layout,
     type (x>,type>);
member (x>,struct>, scan>):
     "(", layout, tupple els (x>, struct>, scan>) ,
     ")", layout.

tupple els ( x + xx + tupple def>, tupple name>, tupple scan>):
     member (x>, s>, t>),
     more tupple els (xx>, ss>, tt>),
     tupple code (>s+ss,>t+tt, tupple def>, tupple name>, tupple scan>).

more tupple els (x +xx>, " * "+s + ss>, ",\",\",layout,\n\t"+t + tt>):
    "," , layout, ->,
    member (x>, s>, t>),
    more tupple els (xx>, ss>, tt>);
more tupple els (empty>, empty>, empty>):.


tupple code (>s,>t, t1+tupple def>, lhs>, tupple scan>):
     some name (lhs>), 
     closed clause code (>lhs, t1>),
     where ( > lhs +"(TUPPLE * "+s + ">):\n\t"+t+".\n\n", tupple def>), 
     where (>lhs +"("+lhs+">)", tupple scan>).
    

more members (x+xx>," * "+s + ss >, ",\n\t"+t+tt>):
    member (x>,s>,t>), ->,
    more members (xx>,ss>,tt>);
more members (empty>,empty>,empty>):.


type (empty>,type+" ">):
   identifier (tp>), layout, ->,
   where (>"scan "+tp, type>);
type (x>,type list>):
   "[",layout,
    identifier(tp>), layout,
    where (>"scan "+tp, type>),
    where (>type + " list ", type list>),
    where (>type + " els ", type els>),
   "]",layout,
    list code (>type,>type list, >type els, x>).

list code  (> type, >type list, >type els, ccc+list code >):
     excludes (>OCCUR, >type list), ->,
     add to (>OCCUR, >type list,>empty),
     closed clause code (>type list,ccc>),
     where ( >"more "+type els, more type els>),
     where ( > type list+"( LIST * "+type els+ ">):\n\t"+ 
                 "\"[\",layout, "+#
                  type els+"("+type els+  
                 ">), \"]\",layout.\n\n"+#

             type els +"("+type+" * "+type els+">):\n\t"+
                type+"("+type+">),->,\n\t"+#
                more type els+ "("+type els+ ">);\n"+
             type els +"(empty>):.\n\n"+#

             more type els +"("+type+" * "+more type els+">):\n\t"+
                "\",\",layout, ->,\n\t"+#
                type+"("+type+">),\n\t"+
                more type els+ "("+more type els+ ">);\n"+#
             more type els +"(empty>):.\n\n\n", list code>);
list code  (> type, >type list, >type els, empty>):.


layout:
    !\n\t !*  (ig>),
    comment.

comment:
    "||", ->,
    ^!\n! * (ign>), layout;
comment: .

#
Open symbol  :: "\t\"(\", layout".
Close symbol :: ",\n\t\")\", layout".
N            :: nlcr.

Constants :: Layout+Inum+Fnum+String+Bool+Symbol.

Layout    :: "\n\nlayout:\n\t!\\n\\t !*  (ig>),\n\tcomment.\n\n"+#
       "comment:\n\t\"||\", ->, ^!\\n! * (ign>), layout;\ncomment: .\n\n".

Inum   :: 
          "scan i num (out >) : \"(\", layout,->, scan i num(out>),\n\t" +
          "\")\", layout,->;\n" +
           "scan i num (I NUM * i num>) : !0123456789!+(inum>), layout.\n\n".

Fnum   :: 
          "scan f num (out >) : \"(\", layout,->, scan f num(out>),\n\t" +
          "\")\", layout,->;\n" +
         "scan f num (F NUM * f num>) : !.+-eE0123456789!+(fnum>), layout.\n\n".

String   :: 
          "scan string (out >) : \"(\", layout,->, scan string(out>),\n\t" +
          "\")\", layout,->;\n" +
      "scan string (STRING*string>):quote,^!\\n\"!*(string>),quote,layout.\n\n".

Symbol  :: 
          "scan symbol (out >) : \"(\", layout,->, scan symbol(out>),\n\t" +
          "\")\", layout,->;\n" +
              "scan symbol (string>) : scan string (string>).\n\n".

Bool   :: 
          "scan bool (out >) : \"(\", layout,->, scan bool(out>),\n\t" +
          "\")\", layout,->;\n" +
          "scan bool (BOOL * True >) : \"True\", layout,->;\n" +
          "scan bool (BOOL * False >) : \"False\", layout.\n\n".
OCCUR :: "O".
OPT :: "#-d\n".
