/*

    This file is a part of the GLAMMAR source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  Eric Voss, ericv@cs.kun.nl 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "ge1.h"

#ifdef DUNIXCON 
#define MAX_CON 32
  int talkto();

FILE *Unix_in[MAX_CON],*Unix_out[MAX_CON];

int    UnixConnectionSetUp[32]=  { 
        false, false,false ,false,false,false,false,false,
        false, false,false ,false,false,false,false,false,
        false, false,false ,false,false,false,false,false,
        false, false,false ,false,false,false,false,false,
};

int connection_count = 0;

#define EVAL(a,b)   b = c;\
                        sprinta (a);\
                        *c++ = '\0';



int dsetupconnectiontounix(B,C)    /* setupconnectiontounix */
register AFFIX B,C ;
{
    char    *A;
    if (connection_count < 31) {
      EVAL(B, A);
      if (!talkto(A))
         return false;
      UnixConnectionSetUp[connection_count] = true;
       
      C ->t = c; 
      (void)  sprintf(c, "%d\0", connection_count++);
      c += 4;
      
      return true;
    }
    return false;
  }

int dtalktounix(B,A_0,A_1)    /* talktounix */
register AFFIX B,A_0,A_1;
{
    int connection = atoi (B->t);
    FILE *in = Unix_in[connection];
    FILE *out = Unix_out[connection];
    if (UnixConnectionSetUp[connection] && !feof(in)) {
      register char *rc =c;
      A_1 ->t = rc;
      A_1 ->l = nil;
      A_1 ->r = nil;
      printa(out, A_0);
      fflush(out);
      --rc;
      do {
        *++rc = getc(in) ;
        if  (*rc == '\\') {
          *++rc = getc(in) ;
          if (*rc == '\n') *--rc = getc(in) ;
        }

      } while  ((*rc != '\n') && (!feof(in)));
    *rc++ = '\0';
    c = rc;
  if (rc > cstore_top ) cstore_overflow();
    return true;
  }
  return false;  
}


int talkto(cmd)
char    *cmd;
{
  int to_child[2], to_parent[2], pid, cnt = 1;
  char *args = cmd;

  pipe(to_child);
  pipe(to_parent);

  argv[0] = cmd;

  while (*args++ != '\0') {
    if (*args == ' ')  {
      *args = '\0';
      while (*++args == ' ') ;
      argv[cnt++] = args;
      if (cnt == 10) {
        fprintf(stderr,"set up connection to unix: too much args (>9)\n");
        return false;
      }
    }
  }
  argv[cnt] = NULL;


  if (pid = vfork(), pid == 0) {
    int err = 0;

    close(0);
    dup(to_child[0]);
    close (1);
    dup(to_parent[1]);
    close(to_child[0]);
    close(to_child[1]);
    close(to_parent[1]);
    close(to_parent[0]);
    err = execvp(cmd, argv);
    fprintf (stderr,"execvp: (%d) No such command %s\n", err,cmd);
    exit(1); 
  } else if (pid > 0) {  /* in the parent */

    Unix_in[connection_count] = fdopen(to_parent[0],"r");
    Unix_out[connection_count] = fdopen(to_child[1],"w");

    if (Unix_in[connection_count] == NULL) 
      return false;
    close(to_child[0]);
    close(to_parent[1]);


  } else {
    fprintf (stderr, "Couldnt fork process %s\n", cmd);
    return false;
  }
  return true;
}

int dgetfromunix(A_0,A_1)    
register AFFIX A_1;
register AFFIX A_0;
{
    char    *A;
    register char *rc;
      EVAL(A_0, A);
      if (talkto(A))
      {
         FILE *in = Unix_in[connection_count];
         FILE *out = Unix_out[connection_count];
         rc = c;
         A_1 ->t = rc;
         A_1 ->l = nil;
         A_1 ->r = nil;
         while  (!feof(in))
           *rc++ = getc(in) ;
        *(rc-1) = '\0';
        c = rc;
  if (rc > cstore_top ) cstore_overflow();
        fclose (in);
        fclose (out);
        return true;
    }
    return false;
}
#endif

#ifdef UUNIXCON
void usetupconnectiontounix () 
{ 
   register cont *rq = q;
register AFFIX A_1 = rq->a;
register AFFIX A_0 = (rq -1) ->a;
   char *rc = c; 
   if ( dsetupconnectiontounix (A_0,A_1)) {
      q = rq -3;
      (*(rq -2)->q)(); 
      rq = q +2;
   }
   (rq -1) ->a = A_0;
   rq->a = A_1;
   (rq + 1)->q = usetupconnectiontounix; 
   q = rq + 1; 
   c = rc;
}

void utalktounix () 
{ 
   register cont *rq = q;
register AFFIX A_2 = rq->a;
register AFFIX A_1 = (rq -1)->a;
register AFFIX A_0 = (rq -2)->a;
   char *rc = c; 
   if ( dtalktounix (A_0, A_1,A_2)) {
      q = rq -4;
      (*(rq -3)->q)(); 
      rq = q +3;
   }
   (rq -2)->a = A_0;
   (rq -1)->a = A_1;
   rq->a = A_2;
   (rq + 1)->q = utalktounix; 
   q = rq + 1; 
   c = rc;
}

void ugetfromunix ()
{
   register cont *rq = q;
register AFFIX A_1 = rq->a;
register AFFIX A_0 = (rq -1)->a;
   char *rc = c; 
   if ( dgetfromunix (A_0, A_1)) {
      q = rq -3;
      (*(rq -2)->q)();
      rq = q +2;
   }
   (rq -1)->a = A_0;
   rq->a = A_1;
   (rq + 1)->q = ugetfromunix;
   q = rq + 1;
   c = rc;
}
#endif
